/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common.data;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0015\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\rH&\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\rH&J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H&J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H&J\u000e\u0010;\u001a\u00020/2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020/2\u0006\u0010\u0006\u001a\u00020\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0012\u00103\u001a\u000204X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u000208X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00109R\u0012\u00100\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001b\u00a8\u0006@"}, d2={"Lsite/siredvin/digitalitems/common/data/DigitizedSomething;", "T", "", "id", "Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "item", "currentTime", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "<init>", "(Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;Ljava/lang/Object;JLnet/minecraft/server/level/ServerPlayer;)V", "compoundTag", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)V", "getId", "()Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "setId", "(Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;)V", "something", "getSomething", "()Ljava/lang/Object;", "setSomething", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "digitizedAt", "getDigitizedAt", "()J", "setDigitizedAt", "(J)V", "lastRefresh", "getLastRefresh", "setLastRefresh", "decaysAt", "getDecaysAt", "setDecaysAt", "ownerUUID", "Ljava/util/UUID;", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "fromCompound", "tag", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Object;", "toCompound", "shrink", "", "amount", "", "grow", "somethingTagName", "", "getSomethingTagName", "()Ljava/lang/String;", "isEmpty", "", "()Z", "getAmount", "serialize", "decayed", "level", "Lnet/minecraft/world/level/Level;", "refresh", "digitalitems-forge-1.20.1"})
public abstract class DigitizedSomething<T> {
    @NotNull
    private ByteArrayWrapper id;
    private T something;
    private long digitizedAt;
    private long lastRefresh;
    private long decaysAt;
    @Nullable
    private UUID ownerUUID;

    @NotNull
    public final ByteArrayWrapper getId() {
        return this.id;
    }

    public final void setId(@NotNull ByteArrayWrapper byteArrayWrapper) {
        Intrinsics.checkNotNullParameter((Object)byteArrayWrapper, (String)"<set-?>");
        this.id = byteArrayWrapper;
    }

    public final T getSomething() {
        return this.something;
    }

    public final void setSomething(T t) {
        this.something = t;
    }

    public final long getDigitizedAt() {
        return this.digitizedAt;
    }

    public final void setDigitizedAt(long l) {
        this.digitizedAt = l;
    }

    public final long getLastRefresh() {
        return this.lastRefresh;
    }

    public final void setLastRefresh(long l) {
        this.lastRefresh = l;
    }

    public final long getDecaysAt() {
        return this.decaysAt;
    }

    public final void setDecaysAt(long l) {
        this.decaysAt = l;
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@Nullable UUID uUID) {
        this.ownerUUID = uUID;
    }

    public DigitizedSomething(@NotNull ByteArrayWrapper id, T item, long currentTime, @Nullable ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.something = item;
        this.digitizedAt = currentTime;
        this.lastRefresh = currentTime;
        this.decaysAt = currentTime + ModConfig.INSTANCE.getDecayTicks();
        ServerPlayer serverPlayer = player;
        this.ownerUUID = serverPlayer != null ? serverPlayer.m_20148_() : null;
    }

    public DigitizedSomething(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        byte[] byArray = compoundTag.m_128463_("id");
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByteArray(...)");
        this.id = new ByteArrayWrapper(byArray);
        CompoundTag compoundTag2 = compoundTag.m_128469_(this.getSomethingTagName());
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"getCompound(...)");
        this.something = this.fromCompound(compoundTag2);
        this.digitizedAt = compoundTag.m_128454_("digitizedAt");
        this.lastRefresh = compoundTag.m_128454_("lastRefresh");
        this.decaysAt = compoundTag.m_128454_("decaysAt");
        this.ownerUUID = compoundTag.m_128403_("ownerUUID") ? compoundTag.m_128342_("ownerUUID") : null;
    }

    public abstract T fromCompound(@NotNull CompoundTag var1);

    @NotNull
    public abstract CompoundTag toCompound();

    public abstract void shrink(int var1);

    public abstract void grow(int var1);

    @NotNull
    public abstract String getSomethingTagName();

    public abstract boolean isEmpty();

    public abstract long getAmount();

    public final void serialize(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        compoundTag.m_128382_("id", this.id.getByteArray());
        compoundTag.m_128365_(this.getSomethingTagName(), (Tag)this.toCompound());
        compoundTag.m_128356_("digitizedAt", this.digitizedAt);
        compoundTag.m_128356_("lastRefresh", this.lastRefresh);
        compoundTag.m_128356_("decaysAt", this.decaysAt);
        if (this.ownerUUID != null) {
            UUID uUID = this.ownerUUID;
            Intrinsics.checkNotNull((Object)uUID);
            compoundTag.m_128362_("ownerUUID", uUID);
        }
    }

    public final boolean decayed(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!ModConfig.INSTANCE.getEnableDecay()) {
            return false;
        }
        MinecraftServer minecraftServer = level.m_7654_();
        Intrinsics.checkNotNull((Object)minecraftServer);
        return this.decaysAt <= minecraftServer.m_129783_().m_46467_();
    }

    public final void refresh(long currentTime) {
        this.lastRefresh = currentTime;
        this.decaysAt = currentTime + ModConfig.INSTANCE.getDecayTicks();
    }
}

