/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.digitalitems.UtilsKt;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.data.DigitizedEnergyStrategy;
import site.siredvin.digitalitems.common.data.DigitizedFluidStrategy;
import site.siredvin.digitalitems.common.data.DigitizedItemStrategy;
import site.siredvin.digitalitems.common.data.DigitizedSomething;
import site.siredvin.digitalitems.common.data.DigitizedSomethingStrategy;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.plugins.InventoryPlugin;
import site.siredvin.tweakium.modules.plugins.SuppliedRudimentInventoryPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001eB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J&\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001d2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/digitalitems/computercraft/AdvancedDigitizerPeripheral;", "T", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "peripheralOwner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "isEnabled", "", "()Z", "getType", "", "peripheralConfiguration", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "digitize", "Ldan200/computercraft/api/lua/MethodResult;", "access", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "rematerialize", "refresh", "mode", "id", "Ljava/nio/ByteBuffer;", "get", "", "Companion", "digitalitems-forge-1.20.1"})
public final class AdvancedDigitizerPeripheral<T extends IPeripheralOwner>
extends OwnedPeripheral<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SecureRandom rand = new SecureRandom();
    @NotNull
    public static final String TYPE = "advanced_digitizer";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("digitalitems", "advanced_digitizer");
    @NotNull
    private static final Map<String, DigitizedSomethingStrategy<?, ?>> STRATEGIES;

    public AdvancedDigitizerPeripheral(@NotNull T peripheralOwner) {
        Intrinsics.checkNotNullParameter(peripheralOwner, (String)"peripheralOwner");
        super(TYPE, peripheralOwner);
        if (peripheralOwner instanceof BlockEntityPeripheralOwner) {
            Level level = ((BlockEntityPeripheralOwner)peripheralOwner).getLevel();
            Intrinsics.checkNotNull((Object)level);
            SlottedAgnosticItemStorage slottedAgnosticItemStorage = ((BlockEntityPeripheralOwner)peripheralOwner).getStorage();
            Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
            this.addPlugin((IPeripheralPlugin)new InventoryPlugin(level, slottedAgnosticItemStorage));
        } else {
            this.addPlugin((IPeripheralPlugin)new SuppliedRudimentInventoryPlugin(() -> AdvancedDigitizerPeripheral._init_$lambda$0(peripheralOwner), () -> AdvancedDigitizerPeripheral._init_$lambda$1(peripheralOwner)));
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map base = super.getPeripheralConfiguration();
        base.put("decayEnabled", ModConfig.INSTANCE.getEnableDecay());
        base.put("decayTicks", ModConfig.INSTANCE.getDecayTicks());
        base.put("itemStackLimit", ModConfig.INSTANCE.getItemStackLimit());
        base.put("fluidStackLimit", ModConfig.INSTANCE.getFluidStackLimit());
        base.put("energyStackLimit", ModConfig.INSTANCE.getEnergyStackLimit());
        return base;
    }

    /*
     * Enabled aggressive block sorting
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult digitize(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        ByteArrayWrapper byteArrayWrapper;
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String mode = arguments.getString(0);
        Optional optional = arguments.optString(1);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optString(...)");
        String source = (String)OptionalsKt.getOrDefault((Optional)optional, (Object)"self");
        Object filter = arguments.get(2);
        Optional optional2 = arguments.optLong(3);
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"optLong(...)");
        Long limit = (Long)OptionalsKt.getOrNull((Optional)optional2);
        Optional optional3 = arguments.optBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"optBytes(...)");
        ByteBuffer destination = (ByteBuffer)OptionalsKt.getOrNull((Optional)optional3);
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        if (limit != null) {
            UtilsKt.assertBetween(limit, 1L, strategy.getLimitLimit(), "limit");
        }
        Intrinsics.checkNotNull((Object)source);
        Object object = destination;
        if (object != null) {
            byte[] byArray = UtilsKt.toSafeArray((ByteBuffer)object);
            object = byArray;
            if (byArray != null) {
                byteArrayWrapper = UtilsKt.wrap((byte[])object);
                return strategy.digitize(access, source, filter, limit, byteArrayWrapper, this.getPeripheralOwner());
            }
        }
        byteArrayWrapper = null;
        return strategy.digitize(access, source, filter, limit, byteArrayWrapper, this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult rematerialize(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String mode = arguments.getString(0);
        ByteBuffer id = arguments.getBytes(1);
        Optional optional = arguments.optLong(2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optLong(...)");
        Long limit = (Long)OptionalsKt.getOrNull((Optional)optional);
        Optional optional2 = arguments.optString(3);
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"optString(...)");
        String destination = (String)OptionalsKt.getOrDefault((Optional)optional2, (Object)"self");
        if (limit != null) {
            UtilsKt.assertBetween(limit, 1L, 64L, "limit");
        }
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        Intrinsics.checkNotNull((Object)id);
        ByteArrayWrapper byteArrayWrapper = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        Intrinsics.checkNotNull((Object)destination);
        return strategy.rematerialize(access, byteArrayWrapper, limit, destination, this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    public final boolean refresh(@NotNull String mode, @NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        ByteArrayWrapper byteArrayWrapper = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        return strategy.refresh(byteArrayWrapper, level);
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> get(@NotNull String mode, @NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy2 = digitizedSomethingStrategy instanceof DigitizedSomethingStrategy ? digitizedSomethingStrategy : null;
        if (digitizedSomethingStrategy2 == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy2;
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level2);
        Object obj = strategy.getById(UtilsKt.wrap(UtilsKt.toSafeArray(id)), sd, level2);
        if (obj == null) {
            return null;
        }
        Object something = obj;
        return strategy.represent((DigitizedSomething<?>)something, level2);
    }

    private static final Level _init_$lambda$0(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        Level level = $peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        return level;
    }

    private static final SlottedAgnosticItemStorage _init_$lambda$1(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = $peripheralOwner.getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        return slottedAgnosticItemStorage;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"item", (Object)new DigitizedItemStrategy()), TuplesKt.to((Object)"fluid", (Object)new DigitizedFluidStrategy()), TuplesKt.to((Object)"energy", (Object)new DigitizedEnergyStrategy())};
        STRATEGIES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR%\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/digitalitems/computercraft/AdvancedDigitizerPeripheral$Companion;", "", "<init>", "()V", "rand", "Ljava/security/SecureRandom;", "getRand", "()Ljava/security/SecureRandom;", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "STRATEGIES", "", "Lsite/siredvin/digitalitems/common/data/DigitizedSomethingStrategy;", "getSTRATEGIES", "()Ljava/util/Map;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecureRandom getRand() {
            return rand;
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final Map<String, DigitizedSomethingStrategy<?, ?>> getSTRATEGIES() {
            return STRATEGIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

