/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common.data;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.storage.fluid.AgnosticFluidStack;
import site.siredvin.broccolium.modules.storage.fluid.AgnosticFluidStorageLookup;
import site.siredvin.broccolium.modules.storage.fluid.FluidStorageUtils;
import site.siredvin.broccolium.modules.storage.fluid.api.AgnosticFluidStorage;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.data.DigitizedFluid;
import site.siredvin.digitalitems.common.data.DigitizedSomethingStrategy;
import site.siredvin.digitalitems.common.setup.ModCriterias;
import site.siredvin.digitalitems.common.setup.ModStats;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.ISidedPeripheral;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J1\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010$J1\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010(JA\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0002J \u00101\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0014J0\u00102\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0014J(\u00104\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u00105\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u00106\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00022\b\u00107\u001a\u0004\u0018\u000108H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00069"}, d2={"Lsite/siredvin/digitalitems/common/data/DigitizedFluidStrategy;", "Lsite/siredvin/digitalitems/common/data/DigitizedSomethingStrategy;", "Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "Lsite/siredvin/digitalitems/common/data/DigitizedFluid;", "<init>", "()V", "mode", "", "getMode", "()Ljava/lang/String;", "stackLimit", "", "getStackLimit", "()J", "getByIdRaw", "id", "Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "sd", "Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData;", "pop", "", "digitizedSomething", "singleRepresent", "", "something", "isSame", "", "another", "isEmpty", "amount", "extractFromStorage", "target", "Lsite/siredvin/broccolium/modules/storage/fluid/api/AgnosticFluidStorage;", "filter", "limit", "simulate", "(Lsite/siredvin/broccolium/modules/storage/fluid/api/AgnosticFluidStorage;Ljava/lang/Object;Ljava/lang/Long;Z)Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "extractFromSelf", "owner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;Ljava/lang/Object;Ljava/lang/Long;Z)Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "extract", "access", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "level", "Lnet/minecraft/world/level/Level;", "source", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Lnet/minecraft/world/level/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Long;Z)Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "storeInStorage", "storeInSelf", "store", "destination", "put", "peripheralOwner", "awardDigitization", "player", "Lnet/minecraft/server/level/ServerPlayer;", "digitalitems-forge-1.20.1"})
public final class DigitizedFluidStrategy
extends DigitizedSomethingStrategy<AgnosticFluidStack, DigitizedFluid> {
    @Override
    @NotNull
    protected String getMode() {
        return "fluid";
    }

    @Override
    protected long getStackLimit() {
        return ModConfig.INSTANCE.getFluidStackLimit();
    }

    @Override
    @Nullable
    protected DigitizedFluid getByIdRaw(@NotNull ByteArrayWrapper id, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        return sd.getFluid(id);
    }

    @Override
    protected void pop(@NotNull DigitizedFluid digitizedSomething, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)digitizedSomething, (String)"digitizedSomething");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        sd.popFluid(digitizedSomething.getId());
    }

    @Override
    @NotNull
    protected Object singleRepresent(@NotNull AgnosticFluidStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return LuaRepresentation.INSTANCE.forFluidStack(something);
    }

    @Override
    protected boolean isSame(@NotNull AgnosticFluidStack something, @NotNull AgnosticFluidStack another) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return FluidStorageUtils.INSTANCE.canStack(something, another);
    }

    @Override
    protected boolean isEmpty(@NotNull AgnosticFluidStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return something.isEmpty();
    }

    @Override
    protected long amount(@NotNull AgnosticFluidStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return (long)something.getAmount();
    }

    private final AgnosticFluidStack extractFromStorage(AgnosticFluidStorage target, Object filter, Long limit, boolean simulate) {
        if (simulate) {
            AgnosticFluidStack stack = filter == null ? (AgnosticFluidStack)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)target.getFluids()), DigitizedFluidStrategy::extractFromStorage$lambda$0)) : (AgnosticFluidStack)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)target.getFluids()), arg_0 -> DigitizedFluidStrategy.extractFromStorage$lambda$1(filter, arg_0)));
            Long l = limit;
            return stack.copyWithCount(l != null ? (double)l.longValue() : stack.getAmount());
        }
        if (filter == null) {
            Long l = limit;
            return target.takeFluid(DigitizedFluidStrategy::extractFromStorage$lambda$2, l != null ? (double)l.longValue() : Double.MAX_VALUE);
        }
        Long l = limit;
        return target.takeFluid(arg_0 -> DigitizedFluidStrategy.extractFromStorage$lambda$3(filter, arg_0), l != null ? (double)l.longValue() : Double.MAX_VALUE);
    }

    @Override
    @NotNull
    protected AgnosticFluidStack extractFromSelf(@NotNull IPeripheralOwner owner, @Nullable Object filter, @Nullable Long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        throw new LuaException("Digitizer itself is invalid target for fluid extraction");
    }

    @Override
    @NotNull
    protected AgnosticFluidStack extract(@NotNull IComputerAccess access, @NotNull Level level, @NotNull String source, @Nullable Object filter, @Nullable Long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        IPeripheral iPeripheral = access.getAvailablePeripheral(source);
        if (iPeripheral == null) {
            throw new LuaException("Cannot find " + source);
        }
        IPeripheral peripheral = iPeripheral;
        Direction direction = peripheral instanceof ISidedPeripheral ? ((ISidedPeripheral)peripheral).getSide() : null;
        AgnosticFluidStorage agnosticFluidStorage = (AgnosticFluidStorage)AgnosticFluidStorageLookup.INSTANCE.extractFromUnknown(level, peripheral.getTarget(), direction);
        if (agnosticFluidStorage == null) {
            throw new LuaException(source + " is not fluid storage");
        }
        AgnosticFluidStorage storage = agnosticFluidStorage;
        return this.extractFromStorage(storage, filter, limit, simulate);
    }

    private final long storeInStorage(AgnosticFluidStorage target, AgnosticFluidStack something, long limit) {
        long realLimit = RangesKt.coerceAtMost((long)limit, (long)((long)something.getAmount()));
        AgnosticFluidStack stackToStore = (long)something.getAmount() != realLimit ? something.copyWithCount((double)realLimit) : something.copy();
        double amountToStore = stackToStore.getAmount();
        AgnosticFluidStack reminder = target.storeFluid(stackToStore);
        return (long)(reminder.getAmount() + (something.getAmount() - amountToStore));
    }

    @Override
    protected long storeInSelf(@NotNull IPeripheralOwner owner, @NotNull AgnosticFluidStack something, long limit) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        throw new LuaException("Digitizer itself is invalid target for fluid storage");
    }

    @Override
    protected long store(@NotNull IComputerAccess access, @NotNull Level level, @NotNull String destination, @NotNull AgnosticFluidStack something, long limit) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        IPeripheral iPeripheral = access.getAvailablePeripheral(destination);
        if (iPeripheral == null) {
            throw new LuaException("Cannot find " + destination);
        }
        IPeripheral peripheral = iPeripheral;
        Direction direction = peripheral instanceof ISidedPeripheral ? ((ISidedPeripheral)peripheral).getSide() : null;
        AgnosticFluidStorage agnosticFluidStorage = (AgnosticFluidStorage)AgnosticFluidStorageLookup.INSTANCE.extractFromUnknown(level, peripheral.getTarget(), direction);
        if (agnosticFluidStorage == null) {
            throw new LuaException(destination + " is not fluid storage");
        }
        AgnosticFluidStorage storage = agnosticFluidStorage;
        return this.storeInStorage(storage, something, limit);
    }

    @Override
    protected void put(@NotNull ByteArrayWrapper id, @NotNull AgnosticFluidStack something, @NotNull IPeripheralOwner peripheralOwner, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        Level level = peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Player player = peripheralOwner.getOwner();
        DigitizedFluid item = new DigitizedFluid(id, something, level.m_46467_(), player instanceof ServerPlayer ? (ServerPlayer)player : null);
        sd.add(item);
        sd.m_77762_();
    }

    @Override
    protected void awardDigitization(@NotNull AgnosticFluidStack something, @Nullable ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        if (player != null) {
            player.m_6278_(ModStats.INSTANCE.getDIGITALIZED_FLUIDS().get(), (int)something.getAmount());
            ModCriterias.INSTANCE.getDIGITALIZE_FLUIDS().trigger(player);
            if (something.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
                player.m_6278_(ModStats.INSTANCE.getDIGITALIZED_LAVA().get(), (int)something.getAmount());
                ModCriterias.INSTANCE.getDIGITALIZE_LAVA().trigger(player);
            }
        }
    }

    private static final boolean extractFromStorage$lambda$0(AgnosticFluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isEmpty();
    }

    private static final boolean extractFromStorage$lambda$1(Object $filter, AgnosticFluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PlatformRegistries.INSTANCE.getFLUIDS().getKey((Object)it.getFluid()).toString(), (Object)$filter);
    }

    private static final boolean extractFromStorage$lambda$2(AgnosticFluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean extractFromStorage$lambda$3(Object $filter, AgnosticFluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PlatformRegistries.INSTANCE.getFLUIDS().getKey((Object)it.getFluid()).toString(), (Object)$filter);
    }
}

