/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common.data;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.digitalitems.UtilsKt;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.data.DigitizedItem;
import site.siredvin.digitalitems.common.data.DigitizedSomethingStrategy;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.ISidedPeripheral;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.plugins.PeripheralPluginUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J1\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010$J1\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010(JA\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0002J \u00101\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0014J0\u00102\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0014J(\u00104\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u00105\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u00106\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00022\b\u00107\u001a\u0004\u0018\u000108H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00069"}, d2={"Lsite/siredvin/digitalitems/common/data/DigitizedItemStrategy;", "Lsite/siredvin/digitalitems/common/data/DigitizedSomethingStrategy;", "Lnet/minecraft/world/item/ItemStack;", "Lsite/siredvin/digitalitems/common/data/DigitizedItem;", "<init>", "()V", "mode", "", "getMode", "()Ljava/lang/String;", "stackLimit", "", "getStackLimit", "()J", "getByIdRaw", "id", "Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "sd", "Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData;", "pop", "", "digitizedSomething", "singleRepresent", "", "something", "isSame", "", "another", "isEmpty", "amount", "extractFromStorage", "target", "Lsite/siredvin/broccolium/modules/storage/item/api/AgnosticItemStorage;", "filter", "limit", "simulate", "(Lsite/siredvin/broccolium/modules/storage/item/api/AgnosticItemStorage;Ljava/lang/Object;Ljava/lang/Long;Z)Lnet/minecraft/world/item/ItemStack;", "extractFromSelf", "owner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;Ljava/lang/Object;Ljava/lang/Long;Z)Lnet/minecraft/world/item/ItemStack;", "extract", "access", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "level", "Lnet/minecraft/world/level/Level;", "source", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Lnet/minecraft/world/level/Level;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Long;Z)Lnet/minecraft/world/item/ItemStack;", "storeInStorage", "storeInSelf", "store", "destination", "put", "peripheralOwner", "awardDigitization", "player", "Lnet/minecraft/server/level/ServerPlayer;", "digitalitems-forge-1.20.1"})
public final class DigitizedItemStrategy
extends DigitizedSomethingStrategy<ItemStack, DigitizedItem> {
    @Override
    @NotNull
    protected String getMode() {
        return "item";
    }

    @Override
    protected long getStackLimit() {
        return ModConfig.INSTANCE.getItemStackLimit();
    }

    @Override
    @Nullable
    protected DigitizedItem getByIdRaw(@NotNull ByteArrayWrapper id, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        return sd.get(id);
    }

    @Override
    protected void pop(@NotNull DigitizedItem digitizedSomething, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)digitizedSomething, (String)"digitizedSomething");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        sd.pop(digitizedSomething.getId());
    }

    @Override
    @NotNull
    protected Object singleRepresent(@NotNull ItemStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)something, null, (int)2, null);
    }

    @Override
    protected boolean isSame(@NotNull ItemStack something, @NotNull ItemStack another) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return ItemStorageUtils.INSTANCE.canStack(something, another);
    }

    @Override
    protected boolean isEmpty(@NotNull ItemStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return something.m_41619_();
    }

    @Override
    protected long amount(@NotNull ItemStack something) {
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        return something.m_41613_();
    }

    private final ItemStack extractFromStorage(AgnosticItemStorage target, Object filter, Long limit, boolean simulate) {
        if (simulate) {
            ItemStack itemStack;
            Object object = filter;
            if (object == null) {
                itemStack = (ItemStack)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)target.getItems()), DigitizedItemStrategy::extractFromStorage$lambda$0));
            } else if (object instanceof Number) {
                if (!(target instanceof SlottedAgnosticItemStorage)) {
                    throw new LuaException("Cannot use slot filter with not-slotted storage");
                }
                itemStack = ((SlottedAgnosticItemStorage)target).getItem(((Number)filter).intValue() - 1);
            } else {
                Predicate predicate = PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(filter);
                itemStack = (ItemStack)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)target.getItems()), arg_0 -> DigitizedItemStrategy.extractFromStorage$lambda$1(predicate, arg_0)));
            }
            ItemStack stack = itemStack;
            Long l = limit;
            ItemStack itemStack2 = stack.m_255036_(l != null ? (int)l.longValue() : RangesKt.coerceAtMost((int)stack.m_41613_(), (int)stack.m_41741_()));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copyWithCount(...)");
            return itemStack2;
        }
        if (filter == null) {
            Long l = limit;
            return target.takeItems(DigitizedItemStrategy::extractFromStorage$lambda$2, l != null ? (int)l.longValue() : Integer.MAX_VALUE);
        }
        if (filter instanceof Number) {
            if (!(target instanceof SlottedAgnosticItemStorage)) {
                throw new LuaException("Cannot use slot filter with not-slotted storage");
            }
            Long l = limit;
            return ((SlottedAgnosticItemStorage)target).takeItems(l != null ? (int)l.longValue() : Integer.MAX_VALUE, ((Number)filter).intValue() - 1, ((Number)filter).intValue() - 1, DigitizedItemStrategy::extractFromStorage$lambda$3);
        }
        Long l = limit;
        return target.takeItems(PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(filter), l != null ? (int)l.longValue() : Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    protected ItemStack extractFromSelf(@NotNull IPeripheralOwner owner, @Nullable Object filter, @Nullable Long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = owner.getStorage();
        if (slottedAgnosticItemStorage == null) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        SlottedAgnosticItemStorage inventory = slottedAgnosticItemStorage;
        return this.extractFromStorage((AgnosticItemStorage)inventory, filter, limit, simulate);
    }

    @Override
    @NotNull
    protected ItemStack extract(@NotNull IComputerAccess access, @NotNull Level level, @NotNull String source, @Nullable Object filter, @Nullable Long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        IPeripheral iPeripheral = access.getAvailablePeripheral(source);
        if (iPeripheral == null) {
            throw new LuaException("Cannot find " + source);
        }
        IPeripheral peripheral = iPeripheral;
        Direction direction = peripheral instanceof ISidedPeripheral ? ((ISidedPeripheral)peripheral).getSide() : null;
        AgnosticItemStorage agnosticItemStorage = (AgnosticItemStorage)AgnosticItemStorageLookup.INSTANCE.extractFromUnknown(level, peripheral.getTarget(), direction);
        if (agnosticItemStorage == null) {
            throw new LuaException(source + " is not inventory or item storage");
        }
        AgnosticItemStorage storage = agnosticItemStorage;
        return this.extractFromStorage(storage, filter, limit, simulate);
    }

    private final long storeInStorage(AgnosticItemStorage target, ItemStack something, long limit) {
        int realLimit = RangesKt.coerceAtMost((int)((int)limit), (int)something.m_41613_());
        ItemStack stackToStore = something.m_41613_() != realLimit ? something.m_255036_(realLimit) : something.m_41777_();
        int amountToStore = stackToStore.m_41613_();
        Intrinsics.checkNotNull((Object)stackToStore);
        ItemStack reminder = target.storeItem(stackToStore);
        return reminder.m_41613_() + (something.m_41613_() - amountToStore);
    }

    @Override
    protected long storeInSelf(@NotNull IPeripheralOwner owner, @NotNull ItemStack something, long limit) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = owner.getStorage();
        if (slottedAgnosticItemStorage == null) {
            return something.m_41613_();
        }
        SlottedAgnosticItemStorage inventory = slottedAgnosticItemStorage;
        return this.storeInStorage((AgnosticItemStorage)inventory, something, limit);
    }

    @Override
    protected long store(@NotNull IComputerAccess access, @NotNull Level level, @NotNull String destination, @NotNull ItemStack something, long limit) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        IPeripheral iPeripheral = access.getAvailablePeripheral(destination);
        if (iPeripheral == null) {
            throw new LuaException("Cannot find " + destination);
        }
        IPeripheral peripheral = iPeripheral;
        Direction direction = peripheral instanceof ISidedPeripheral ? ((ISidedPeripheral)peripheral).getSide() : null;
        AgnosticItemStorage agnosticItemStorage = (AgnosticItemStorage)AgnosticItemStorageLookup.INSTANCE.extractFromUnknown(level, peripheral.getTarget(), direction);
        if (agnosticItemStorage == null) {
            throw new LuaException(destination + " is not inventory or item storage");
        }
        AgnosticItemStorage storage = agnosticItemStorage;
        return this.storeInStorage(storage, something, limit);
    }

    @Override
    protected void put(@NotNull ByteArrayWrapper id, @NotNull ItemStack something, @NotNull IPeripheralOwner peripheralOwner, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)something, (String)"something");
        Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        Level level = peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Player player = peripheralOwner.getOwner();
        DigitizedItem item = new DigitizedItem(id, something, level.m_46467_(), player instanceof ServerPlayer ? (ServerPlayer)player : null);
        sd.add(item);
        sd.m_77762_();
    }

    @Override
    protected void awardDigitization(@NotNull ItemStack something, @Nullable ServerPlayer player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)something, (String)"something");
            ServerPlayer serverPlayer = player;
            if (serverPlayer == null) break block0;
            UtilsKt.awardDigitalization(serverPlayer, something);
        }
    }

    private static final boolean extractFromStorage$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.m_41619_();
    }

    private static final boolean extractFromStorage$lambda$1(Predicate $predicate, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $predicate.test(it);
    }

    private static final boolean extractFromStorage$lambda$2(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean extractFromStorage$lambda$3(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

