/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitizedEnergy;
import site.siredvin.digitalitems.common.data.DigitizedFluid;
import site.siredvin.digitalitems.common.data.DigitizedItem;
import site.siredvin.digitalitems.common.data.DigitizedSomething;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\f\u001a\u00020\r\"\f\b\u0000\u0010\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u000e0\u0005H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0006J*\u0010\u001d\u001a\u00020\u001e\"\f\b\u0000\u0010\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u000e0\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "digitizedItems", "", "Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "Lsite/siredvin/digitalitems/common/data/DigitizedItem;", "digitizedFluids", "Lsite/siredvin/digitalitems/common/data/DigitizedFluid;", "digitizedEnergy", "Lsite/siredvin/digitalitems/common/data/DigitizedEnergy;", "pruneSomething", "", "T", "Lsite/siredvin/digitalitems/common/data/DigitizedSomething;", "l", "Lnet/minecraft/world/level/Level;", "map", "prune", "add", "item", "get", "id", "pop", "getFluid", "popFluid", "getEnergy", "popEnergy", "saveSomething", "Lnet/minecraft/nbt/ListTag;", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Companion", "digitalitems-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nDigitalItemsSavedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigitalItemsSavedData.kt\nsite/siredvin/digitalitems/common/data/DigitalItemsSavedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n*S KotlinDebug\n*F\n+ 1 DigitalItemsSavedData.kt\nsite/siredvin/digitalitems/common/data/DigitalItemsSavedData\n*L\n87#1:160\n87#1:161,2\n*E\n"})
public final class DigitalItemsSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<ByteArrayWrapper, DigitizedItem> digitizedItems = new LinkedHashMap();
    @NotNull
    private Map<ByteArrayWrapper, DigitizedFluid> digitizedFluids = new LinkedHashMap();
    @NotNull
    private Map<ByteArrayWrapper, DigitizedEnergy> digitizedEnergy = new LinkedHashMap();
    @Nullable
    private static DigitalItemsSavedData instance;

    private final <T extends DigitizedSomething<?>> void pruneSomething(Level l, Map<ByteArrayWrapper, T> map) {
        if (!ModConfig.INSTANCE.getEnableDecay()) {
            return;
        }
        long currentTime = l.m_46467_();
        Iterator<Map.Entry<ByteArrayWrapper, T>> it = map.entrySet().iterator();
        it.forEachRemaining(arg_0 -> DigitalItemsSavedData.pruneSomething$lambda$1(arg_0 -> DigitalItemsSavedData.pruneSomething$lambda$0(currentTime, it, arg_0), arg_0));
        this.m_77762_();
    }

    public final void prune(@NotNull Level l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.pruneSomething(l, this.digitizedItems);
        this.pruneSomething(l, this.digitizedEnergy);
        this.pruneSomething(l, this.digitizedFluids);
    }

    public final void add(@NotNull DigitizedItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.digitizedItems.put(item.getId(), item);
        this.m_77762_();
    }

    public final void add(@NotNull DigitizedFluid item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.digitizedFluids.put(item.getId(), item);
        this.m_77762_();
    }

    public final void add(@NotNull DigitizedEnergy item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.digitizedEnergy.put(item.getId(), item);
        this.m_77762_();
    }

    @Nullable
    public final DigitizedItem get(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.digitizedItems.get(id);
    }

    @Nullable
    public final DigitizedItem pop(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedItem result = this.digitizedItems.remove(id);
        if (result != null) {
            this.m_77762_();
        }
        return result;
    }

    @Nullable
    public final DigitizedFluid getFluid(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.digitizedFluids.get(id);
    }

    @Nullable
    public final DigitizedFluid popFluid(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedFluid result = this.digitizedFluids.remove(id);
        if (result != null) {
            this.m_77762_();
        }
        return result;
    }

    @Nullable
    public final DigitizedEnergy getEnergy(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.digitizedEnergy.get(id);
    }

    @Nullable
    public final DigitizedEnergy popEnergy(@NotNull ByteArrayWrapper id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedEnergy result = this.digitizedEnergy.remove(id);
        if (result != null) {
            this.m_77762_();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends DigitizedSomething<?>> ListTag saveSomething(Map<ByteArrayWrapper, T> map) {
        void $this$filterTo$iv$iv;
        ListTag items = new ListTag();
        Iterable $this$filter$iv = map.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DigitizedSomething it = (DigitizedSomething)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((List)destination$iv$iv).forEach(arg_0 -> DigitalItemsSavedData.saveSomething$lambda$3(items, arg_0));
        return items;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_("items", (Tag)this.saveSomething(this.digitizedItems));
        tag.m_128365_("fluids", (Tag)this.saveSomething(this.digitizedFluids));
        tag.m_128365_("energies", (Tag)this.saveSomething(this.digitizedEnergy));
        return tag;
    }

    private static final Unit pruneSomething$lambda$0(long $currentTime, Iterator $it, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        DigitizedSomething value = (DigitizedSomething)entry.getValue();
        if ($currentTime >= value.getDecaysAt()) {
            $it.remove();
        }
        return Unit.INSTANCE;
    }

    private static final void pruneSomething$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void saveSomething$lambda$3(ListTag $items, DigitizedSomething digitizedItem) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)digitizedItem, (String)"digitizedItem");
        CompoundTag digitizedItemTag = new CompoundTag();
        digitizedItem.serialize(digitizedItemTag);
        $items.add((Object)digitizedItemTag);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData$Companion;", "", "<init>", "()V", "instance", "Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData;", "getFrom", "l", "Lnet/minecraft/world/level/Level;", "create", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DigitalItemsSavedData getFrom(@NotNull Level l) {
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            if (!(l instanceof ServerLevel)) {
                throw new IllegalCallerException("may only be called server side!");
            }
            if (instance != null) {
                DigitalItemsSavedData digitalItemsSavedData = instance;
                Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData));
                return digitalItemsSavedData;
            }
            instance = (DigitalItemsSavedData)((ServerLevel)l).m_7654_().m_129783_().m_8895_().m_164861_(Companion::getFrom$lambda$0, Companion::getFrom$lambda$1, "digitalitems");
            DigitalItemsSavedData digitalItemsSavedData = instance;
            Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData));
            digitalItemsSavedData.prune(l);
            DigitalItemsSavedData digitalItemsSavedData2 = instance;
            Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData2));
            return digitalItemsSavedData2;
        }

        @NotNull
        public final DigitalItemsSavedData create() {
            return new DigitalItemsSavedData();
        }

        @NotNull
        public final DigitalItemsSavedData load(@NotNull CompoundTag tag) {
            ListTag list;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            DigitalItemsSavedData data = this.create();
            if (tag.m_128441_("items") && tag.m_128423_("items") instanceof ListTag) {
                Tag tag2 = Objects.requireNonNull(tag.m_128423_("items"));
                Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
                list = (ListTag)tag2;
                list.forEach(arg_0 -> Companion.load$lambda$2(data, arg_0));
            }
            if (tag.m_128441_("fluids") && tag.m_128423_("fluids") instanceof ListTag) {
                Tag tag3 = Objects.requireNonNull(tag.m_128423_("fluids"));
                Intrinsics.checkNotNull((Object)tag3, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
                list = (ListTag)tag3;
                list.forEach(arg_0 -> Companion.load$lambda$3(data, arg_0));
            }
            if (tag.m_128441_("energies") && tag.m_128423_("energies") instanceof ListTag) {
                Tag tag4 = Objects.requireNonNull(tag.m_128423_("energies"));
                Intrinsics.checkNotNull((Object)tag4, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
                list = (ListTag)tag4;
                list.forEach(arg_0 -> Companion.load$lambda$4(data, arg_0));
            }
            return data;
        }

        private static final DigitalItemsSavedData getFrom$lambda$0(CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return Companion.load(tag);
        }

        private static final DigitalItemsSavedData getFrom$lambda$1() {
            return Companion.create();
        }

        private static final void load$lambda$2(DigitalItemsSavedData $data, Tag tag1) {
            Intrinsics.checkNotNullParameter((Object)((Object)$data), (String)"$data");
            Intrinsics.checkNotNullParameter((Object)tag1, (String)"tag1");
            Tag tag = Objects.requireNonNull(tag1);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            DigitizedItem di = new DigitizedItem((CompoundTag)tag);
            if (!di.isEmpty()) {
                $data.digitizedItems.put(di.getId(), di);
            }
        }

        private static final void load$lambda$3(DigitalItemsSavedData $data, Tag tag1) {
            Intrinsics.checkNotNullParameter((Object)((Object)$data), (String)"$data");
            Intrinsics.checkNotNullParameter((Object)tag1, (String)"tag1");
            Tag tag = Objects.requireNonNull(tag1);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            DigitizedFluid di = new DigitizedFluid((CompoundTag)tag);
            if (!di.isEmpty()) {
                $data.digitizedFluids.put(di.getId(), di);
            }
        }

        private static final void load$lambda$4(DigitalItemsSavedData $data, Tag tag1) {
            Intrinsics.checkNotNullParameter((Object)((Object)$data), (String)"$data");
            Intrinsics.checkNotNullParameter((Object)tag1, (String)"tag1");
            Tag tag = Objects.requireNonNull(tag1);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            DigitizedEnergy di = new DigitizedEnergy((CompoundTag)tag);
            if (!di.isEmpty()) {
                $data.digitizedEnergy.put(di.getId(), di);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

