/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.computercraft;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.digitalitems.UtilsKt;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.data.DigitizedItem;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.plugins.InventoryPlugin;
import site.siredvin.tweakium.modules.plugins.SuppliedRudimentInventoryPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001(B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020!H\u0007J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001cH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020!H\u0007J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u000b\u001a\u00020!H\u0007R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lsite/siredvin/digitalitems/computercraft/DigitizerPeripheral;", "T", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "peripheralOwner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "checkID", "Lsite/siredvin/digitalitems/common/data/DigitizedItem;", "sd", "Lsite/siredvin/digitalitems/common/data/DigitalItemsSavedData;", "id", "Lsite/siredvin/digitalitems/common/data/ByteArrayWrapper;", "isEnabled", "", "()Z", "getType", "", "decayEnabled", "getDecayEnabled", "decayTicks", "", "getDecayTicks", "()J", "digitize", "", "slotOp", "Ljava/util/Optional;", "", "digitizeAmount", "amount", "innerRematerializeAmount", "rematerialize", "Ljava/nio/ByteBuffer;", "rematerializeAmount", "refresh", "", "getIDInfo", "", "", "Companion", "digitalitems-forge-1.20.1"})
public final class DigitizerPeripheral<T extends IPeripheralOwner>
extends OwnedPeripheral<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SecureRandom rand = new SecureRandom();
    @NotNull
    public static final String TYPE = "digitizer";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("digitalitems", "digitizer");

    public DigitizerPeripheral(@NotNull T peripheralOwner) {
        Intrinsics.checkNotNullParameter(peripheralOwner, (String)"peripheralOwner");
        super(TYPE, peripheralOwner);
        if (peripheralOwner instanceof BlockEntityPeripheralOwner) {
            Level level = ((BlockEntityPeripheralOwner)peripheralOwner).getLevel();
            Intrinsics.checkNotNull((Object)level);
            SlottedAgnosticItemStorage slottedAgnosticItemStorage = ((BlockEntityPeripheralOwner)peripheralOwner).getStorage();
            Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
            this.addPlugin((IPeripheralPlugin)new InventoryPlugin(level, slottedAgnosticItemStorage));
        } else {
            this.addPlugin((IPeripheralPlugin)new SuppliedRudimentInventoryPlugin(() -> DigitizerPeripheral._init_$lambda$0(peripheralOwner), () -> DigitizerPeripheral._init_$lambda$1(peripheralOwner)));
        }
    }

    private final DigitizedItem checkID(DigitalItemsSavedData sd, ByteArrayWrapper id) throws LuaException {
        DigitizedItem item;
        block3: {
            block2: {
                item = sd.get(id);
                if (item == null) break block2;
                Level level = this.getPeripheralOwner().getLevel();
                Intrinsics.checkNotNull((Object)level);
                if (!item.decayed(level)) break block3;
            }
            sd.pop(id);
            throw new LuaException("Invalid item ID");
        }
        return item;
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    @LuaFunction(mainThread=true)
    public final boolean getDecayEnabled() {
        return ModConfig.INSTANCE.getEnableDecay();
    }

    @LuaFunction(mainThread=true)
    public final long getDecayTicks() {
        return ModConfig.INSTANCE.getDecayTicks();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final byte[] digitize(@NotNull Optional<Integer> slotOp) throws LuaException {
        Intrinsics.checkNotNullParameter(slotOp, (String)"slotOp");
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = this.getPeripheralOwner().getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        Optional<Integer> optional = slotOp.map(arg_0 -> DigitizerPeripheral.digitize$lambda$3(DigitizerPeripheral::digitize$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        Object object = OptionalsKt.getOrDefault(optional, (Object)0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return this.digitizeAmount(slottedAgnosticItemStorage.getItem(((Number)object).intValue()).m_41613_(), slotOp);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final byte[] digitizeAmount(int amount, @NotNull Optional<Integer> slotOp) throws LuaException {
        byte[] id;
        block4: {
            Intrinsics.checkNotNullParameter(slotOp, (String)"slotOp");
            Optional<Integer> optional = slotOp.map(arg_0 -> DigitizerPeripheral.digitizeAmount$lambda$5(DigitizerPeripheral::digitizeAmount$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
            Integer slot = (Integer)OptionalsKt.getOrDefault(optional, (Object)0);
            SlottedAgnosticItemStorage slottedAgnosticItemStorage = this.getPeripheralOwner().getStorage();
            Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
            Intrinsics.checkNotNull((Object)slot);
            ItemStack item = slottedAgnosticItemStorage.getItem(slot.intValue());
            if (item.m_150930_(Items.f_41852_)) {
                throw new LuaException("There is nothing to digitize");
            }
            if (amount <= 0) {
                throw new LuaException("Invalid amount");
            }
            if (item.m_41613_() < amount) {
                throw new LuaException("Fewer items present than requested for digitization");
            }
            id = new byte[16];
            rand.nextBytes(id);
            Level level = this.getPeripheralOwner().getLevel();
            Intrinsics.checkNotNull((Object)level);
            DigitalItemsSavedData data = DigitalItemsSavedData.Companion.getFrom(level);
            ByteArrayWrapper byteArrayWrapper = UtilsKt.wrap(id);
            SlottedAgnosticItemStorage slottedAgnosticItemStorage2 = this.getPeripheralOwner().getStorage();
            Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage2);
            ItemStack itemStack = slottedAgnosticItemStorage2.takeItems(amount, slot.intValue(), slot.intValue(), ItemStorageUtils.INSTANCE.getALWAYS()).m_41777_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            Level level2 = this.getPeripheralOwner().getLevel();
            Intrinsics.checkNotNull((Object)level2);
            Player player = this.getPeripheralOwner().getOwner();
            DigitizedItem digitizedItem = new DigitizedItem(byteArrayWrapper, itemStack, level2.m_46467_(), player instanceof ServerPlayer ? (ServerPlayer)player : null);
            if (((ItemStack)digitizedItem.getSomething()).m_41613_() <= 0) {
                throw new LuaException("Something strange happened and nothing was digitized");
            }
            data.add(digitizedItem);
            data.m_77762_();
            Player player2 = this.getPeripheralOwner().getOwner();
            ServerPlayer serverPlayer = player2 instanceof ServerPlayer ? (ServerPlayer)player2 : null;
            if (serverPlayer == null) break block4;
            UtilsKt.awardDigitalization(serverPlayer, (ItemStack)digitizedItem.getSomething());
        }
        return id;
    }

    public final int innerRematerializeAmount(@NotNull ByteArrayWrapper id, int amount, @NotNull DigitalItemsSavedData sd) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)sd), (String)"sd");
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData sd2 = DigitalItemsSavedData.Companion.getFrom(level);
        DigitizedItem item = this.checkID(sd2, id);
        if (amount <= 0) {
            throw new LuaException("Invalid amount");
        }
        if (((ItemStack)item.getSomething()).m_41613_() < amount) {
            throw new LuaException("Fewer items present in ID than requested for rematerialization");
        }
        ItemStack itemStack = ((ItemStack)item.getSomething()).m_41777_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        ItemStack limitedAmount = itemStack;
        limitedAmount.m_41764_(amount);
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = this.getPeripheralOwner().getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        ItemStack remaining = slottedAgnosticItemStorage.storeItem(limitedAmount);
        ItemStack itemStack2 = (ItemStack)item.getSomething();
        itemStack2.m_41764_(itemStack2.m_41613_() - (limitedAmount.m_41613_() - remaining.m_41613_()));
        if (((ItemStack)item.getSomething()).m_41613_() == 0) {
            sd2.pop(id);
        } else {
            Level level2 = this.getPeripheralOwner().getLevel();
            Intrinsics.checkNotNull((Object)level2);
            item.refresh(level2.m_46467_());
        }
        sd2.m_77762_();
        return limitedAmount.m_41613_() - remaining.m_41613_();
    }

    @LuaFunction(mainThread=true)
    public final int rematerialize(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level);
        ByteArrayWrapper trueID = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        DigitizedItem item = this.checkID(sd, trueID);
        return this.innerRematerializeAmount(trueID, ((ItemStack)item.getSomething()).m_41613_(), sd);
    }

    @LuaFunction(mainThread=true)
    public final int rematerializeAmount(@NotNull ByteBuffer id, int amount) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ByteArrayWrapper trueID = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level);
        return this.innerRematerializeAmount(trueID, amount, sd);
    }

    @LuaFunction(mainThread=true)
    public final void refresh(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level2);
        DigitizedItem item = this.checkID(sd, UtilsKt.wrap(UtilsKt.toSafeArray(id)));
        long currentTime = level2.m_46467_();
        item.refresh(currentTime);
        sd.m_77762_();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getIDInfo(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level2);
        DigitizedItem item = this.checkID(sd, UtilsKt.wrap(UtilsKt.toSafeArray(id)));
        HashMap root = new HashMap();
        long currentTime = level2.m_46467_();
        Long l = currentTime;
        ((Map)root).put("currentTime", l);
        ((Map)root).put("digitizedAt", item.getDigitizedAt());
        ((Map)root).put("decaysAt", item.getDecaysAt());
        ((Map)root).put("lastRefresh", item.getLastRefresh());
        ((Map)root).put("item", LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)((ItemStack)item.getSomething()), null, (int)2, null));
        return root;
    }

    private static final Level _init_$lambda$0(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        Level level = $peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        return level;
    }

    private static final SlottedAgnosticItemStorage _init_$lambda$1(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = $peripheralOwner.getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        return slottedAgnosticItemStorage;
    }

    private static final Integer digitize$lambda$2(Integer it) {
        return it - 1;
    }

    private static final Integer digitize$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer digitizeAmount$lambda$4(Integer it) {
        return it - 1;
    }

    private static final Integer digitizeAmount$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/digitalitems/computercraft/DigitizerPeripheral$Companion;", "", "<init>", "()V", "rand", "Ljava/security/SecureRandom;", "getRand", "()Ljava/security/SecureRandom;", "TYPE", "", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecureRandom getRand() {
            return rand;
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

