/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices;

import dev.ultreon.devices.UltreonDevices;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class DevicesEarlyConfig {
    private static final File FILE = Path.of("config", new String[0]).resolve("devices-early-config.json").toFile();
    public boolean enableBetaApps = false;
    public boolean enableDebugApps = false;

    public static DevicesEarlyConfig load() {
        DevicesEarlyConfig devicesEarlyConfig;
        FileReader reader = new FileReader(FILE);
        try {
            devicesEarlyConfig = (DevicesEarlyConfig)UltreonDevices.GSON.fromJson((Reader)reader, DevicesEarlyConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                DevicesEarlyConfig devicesEarlyConfig2 = new DevicesEarlyConfig();
                devicesEarlyConfig2.save();
                return devicesEarlyConfig2;
            }
            catch (IOException e) {
                UltreonDevices.LOGGER.error("Failed to load devices early config", (Throwable)e);
                return new DevicesEarlyConfig();
            }
        }
        reader.close();
        return devicesEarlyConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            UltreonDevices.GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            UltreonDevices.LOGGER.error("Failed to save devices early config", (Throwable)e);
        }
    }
}

