/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Spinner;
import dev.ultreon.devices.api.app.listener.ItemClickListener;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemList<E>
extends Component
implements Iterable<E> {
    private static final int LOADING_BACKGROUND = new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB();
    protected int width;
    protected int visibleItems;
    protected int offset;
    protected int selected = -1;
    protected boolean showAll = true;
    protected boolean resized = false;
    protected boolean initialized = false;
    protected boolean loading = false;
    protected List<E> items = class_2371.method_10211();
    protected ListItemRenderer<E> renderer = null;
    protected ItemClickListener<E> itemClickListener = null;
    protected Button btnUp;
    protected Button btnDown;
    protected Layout layoutLoading;
    protected int textColor = Color.WHITE.getRGB();
    protected int backgroundColor = Color.GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();
    private Comparator<E> sorter = null;

    public ItemList(int left, int top, int width, int visibleItems) {
        super(left, top);
        this.width = width;
        this.visibleItems = visibleItems;
    }

    public ItemList(int left, int top, int width, int visibleItems, boolean showAll) {
        this(left, top, width, visibleItems);
        this.showAll = showAll;
    }

    @Override
    public void init(Layout layout) {
        this.btnUp = new Button(this.left + this.width - 12, this.top, Icons.CHEVRON_UP);
        this.btnUp.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.scrollUp();
            }
        });
        this.btnUp.setEnabled(false);
        this.btnUp.setVisible(false);
        this.btnUp.setSize(12, 12);
        layout.addComponent(this.btnUp);
        this.btnDown = new Button(this.left + this.width - 12, this.top + this.getHeight() - 12, Icons.CHEVRON_DOWN);
        this.btnDown.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.scrollDown();
            }
        });
        this.btnDown.setEnabled(false);
        this.btnDown.setVisible(false);
        this.btnDown.setSize(12, 12);
        layout.addComponent(this.btnDown);
        this.layoutLoading = new Layout(this.left, this.top, this.getWidth(), this.getHeight());
        this.layoutLoading.setVisible(this.loading);
        this.layoutLoading.addComponent(new Spinner((this.layoutLoading.width - 12) / 2, (this.layoutLoading.height - 12) / 2));
        this.layoutLoading.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> graphics.method_25294(x, y, x + width, y + height, LOADING_BACKGROUND));
        layout.addComponent(this.layoutLoading);
        this.updateButtons();
        this.updateComponent();
        this.initialized = true;
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            E item;
            int i;
            int height = 13;
            if (this.renderer != null) {
                height = this.renderer.getHeight();
            }
            int size = this.getSize();
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor());
            Color borderColor = bgColor.darker().darker();
            graphics.method_25294(this.xPosition + 1, this.yPosition + 1, this.xPosition + this.width - 1, this.yPosition + size * height + size, bgColor.getRGB());
            this.drawHorizontalLine(graphics, this.xPosition, this.xPosition + this.width - 1, this.yPosition, borderColor.getRGB());
            this.drawVerticalLine(graphics, this.xPosition, this.yPosition, this.yPosition + size * height + size, borderColor.getRGB());
            this.drawVerticalLine(graphics, this.xPosition + this.width - 1, this.yPosition, this.yPosition + size * height + size, borderColor.getRGB());
            this.drawHorizontalLine(graphics, this.xPosition, this.xPosition + this.width - 1, this.yPosition + size * height + size, borderColor.getRGB());
            for (i = 0; i < size - 1 && i < this.items.size(); ++i) {
                item = this.getItem(i);
                if (item == null) continue;
                if (this.renderer != null) {
                    this.renderer.render(graphics, item, mc, this.xPosition + 1, this.yPosition + i * this.renderer.getHeight() + 1 + i, this.width - 2, this.renderer.getHeight(), i + this.offset == this.selected);
                    this.drawHorizontalLine(graphics, this.xPosition + 1, this.xPosition + this.width - 1, this.yPosition + i * height + i + height + 1, borderColor.getRGB());
                    continue;
                }
                graphics.method_25294(this.xPosition + 1, this.yPosition + i * 14 + 1, this.xPosition + this.width - 1, this.yPosition + 13 + i * 14 + 1, i + this.offset != this.selected ? bgColor.brighter().getRGB() : bgColor.brighter().brighter().getRGB());
                graphics.method_25303(mc.field_1772, item.toString(), this.xPosition + 3, this.yPosition + 3 + i * 14, this.textColor);
                this.drawHorizontalLine(graphics, this.xPosition + 1, this.xPosition + this.width - 2, this.yPosition + i * height + i + height + 1, borderColor.getRGB());
            }
            i = size - 1;
            item = this.getItem(i);
            if (item != null) {
                if (this.renderer != null) {
                    this.renderer.render(graphics, item, mc, this.xPosition + 1, this.yPosition + i * this.renderer.getHeight() + 1 + i, this.width - 2, this.renderer.getHeight(), i + this.offset == this.selected);
                    this.drawHorizontalLine(graphics, this.xPosition + 1, this.xPosition + this.width - 1, this.yPosition + i * height + i + height + 1, borderColor.getRGB());
                } else {
                    graphics.method_25294(this.xPosition + 1, this.yPosition + i * 14 + 1, this.xPosition + this.width - 1, this.yPosition + 13 + i * 14 + 1, i + this.offset != this.selected ? bgColor.brighter().getRGB() : bgColor.brighter().brighter().getRGB());
                    graphics.method_25303(ComputerScreen.getFont(), item.toString(), this.xPosition + 3, this.yPosition + 3 + i * 14, this.textColor);
                }
            }
            if (this.items.size() > this.visibleItems) {
                graphics.method_25294(this.xPosition + this.width, this.yPosition, this.xPosition + this.width + 10, this.yPosition + size * height + size, Color.DARK_GRAY.getRGB());
                this.drawVerticalLine(graphics, this.xPosition + this.width + 10, this.yPosition + 11, this.yPosition + size * height + size - 11, borderColor.getRGB());
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled || this.loading) {
            return;
        }
        int height = this.renderer != null ? this.renderer.getHeight() : 13;
        int size = this.getSize();
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + size * height + size)) {
            for (int i = 0; i < size && i < this.items.size(); ++i) {
                if (!GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + 1, this.yPosition + i * height + i, this.xPosition + this.width - 1, this.yPosition + i * height + i + height)) continue;
                if (mouseButton == 0) {
                    this.selected = i + this.offset;
                }
                if (this.itemClickListener == null) continue;
                this.itemClickListener.onClick(this.items.get(i + this.offset), i + this.offset, mouseButton);
            }
        }
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (!this.visible || !this.enabled || this.loading) {
            return;
        }
        int height = this.renderer != null ? this.renderer.getHeight() : 13;
        int size = this.getSize();
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + size * height + size)) {
            if (direction) {
                this.scrollUp();
            } else {
                this.scrollDown();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        int size = this.getSize();
        return (this.renderer != null ? this.renderer.getHeight() : 13) * size + size + 1;
    }

    private int getSize() {
        if (this.showAll) {
            return this.visibleItems;
        }
        return Math.max(1, Math.min(this.visibleItems, this.items.size()));
    }

    private void scrollUp() {
        if (this.offset > 0) {
            --this.offset;
            this.updateButtons();
        }
    }

    private void scrollDown() {
        if (this.getSize() + this.offset < this.items.size()) {
            ++this.offset;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.btnDown.setEnabled(this.getSize() + this.offset < this.items.size());
        this.btnUp.setEnabled(this.offset > 0);
    }

    private void updateComponent() {
        this.btnUp.setVisible(this.items.size() > this.visibleItems);
        this.btnDown.setVisible(this.items.size() > this.visibleItems);
        this.btnDown.top = this.top + this.getHeight() - 12;
        if (!this.resized && this.items.size() > this.visibleItems) {
            this.width -= 11;
            this.resized = true;
        } else if (this.resized && this.items.size() <= this.visibleItems) {
            this.width += 11;
            this.resized = false;
        }
    }

    private void updateScroll() {
        if (this.offset + this.visibleItems > this.items.size()) {
            this.offset = Math.max(0, this.items.size() - this.visibleItems);
        }
    }

    public void setListItemRenderer(ListItemRenderer<E> renderer) {
        this.renderer = renderer;
    }

    public void setItemClickListener(ItemClickListener<E> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public void addItem(@NotNull E e) {
        this.items.add(e);
        this.sort();
        if (this.initialized) {
            this.updateButtons();
            this.updateComponent();
        }
    }

    public E removeItem(int index) {
        if (index >= 0 && index < this.items.size()) {
            E e = this.items.remove(index);
            if (index == this.selected) {
                this.selected = -1;
            }
            if (this.initialized) {
                this.updateButtons();
                this.updateComponent();
                this.updateScroll();
            }
            return e;
        }
        return null;
    }

    public E getItem(int pos) {
        if (pos >= 0 && pos + this.offset < this.items.size()) {
            return this.items.get(pos + this.offset);
        }
        return null;
    }

    @Nullable
    public E getSelectedItem() {
        if (this.selected >= 0 && this.selected < this.items.size()) {
            return this.items.get(this.selected);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedIndex(int index) {
        if (index < 0) {
            index = -1;
        }
        this.selected = index;
    }

    public List<E> getItems() {
        return this.items;
    }

    public void setItems(List<E> newItems) {
        this.items.clear();
        this.items.addAll(newItems);
        this.sort();
        if (this.initialized) {
            this.offset = 0;
            this.updateButtons();
            this.updateComponent();
        }
    }

    public void removeAll() {
        this.items.clear();
        this.selected = -1;
        if (this.initialized) {
            this.updateButtons();
            this.updateComponent();
            this.updateScroll();
        }
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color.getRGB();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        if (this.initialized) {
            this.layoutLoading.setVisible(loading);
        }
    }

    public void sortBy(Comparator<E> sorter) {
        this.sorter = sorter;
        this.sort();
    }

    public void sort() {
        if (this.sorter != null) {
            Collections.sort(this.items, this.sorter);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.items.iterator();
    }
}

