/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.core.ComputerScreen;
import java.text.DecimalFormat;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class NumberSelector
extends Component {
    protected DecimalFormat format = new DecimalFormat("0");
    protected int current = 1;
    protected int min = 1;
    protected int max = 100;
    protected int width;
    protected Button btnUp;
    protected TextField display;
    protected Button btnDown;
    private boolean holding = false;
    private int holdCount = 0;

    public NumberSelector(int left, int top, int width) {
        super(left, top);
        this.width = width;
    }

    @Override
    public void init(Layout layout) {
        this.btnUp = new Button(this.left, this.top, COMPONENTS_GUI, 111, 12, 8, 5);
        this.btnUp.setSize(this.width, 11);
        this.btnUp.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.current < this.max) {
                ++this.current;
                this.display.setText(this.format.format(this.current));
                this.updateButtons();
            }
        });
        layout.addComponent(this.btnUp);
        this.display = new TextField(this.left, this.top + 10, this.width);
        this.display.setEditable(false);
        this.display.setText(this.format.format(this.current));
        layout.addComponent(this.display);
        this.btnDown = new Button(this.left, this.top + 24, COMPONENTS_GUI, 119, 12, 8, 5);
        this.btnDown.setSize(this.width, 11);
        this.btnDown.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.current > this.min) {
                --this.current;
                this.display.setText(this.format.format(this.current));
                this.updateButtons();
            }
        });
        layout.addComponent(this.btnDown);
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
    }

    @Override
    public void handleTick() {
        if (class_310.method_1551().field_1729.method_1608()) {
            if (this.holding) {
                this.btnUp.handleMouseClick(0, 0, 0);
                this.btnDown.handleMouseClick(0, 0, 0);
            } else {
                ++this.holdCount;
                if (this.holdCount > 10) {
                    this.holding = true;
                }
            }
        } else {
            this.holdCount = 0;
            this.holding = false;
        }
    }

    public void updateButtons() {
        this.btnUp.setEnabled(true);
        this.btnDown.setEnabled(true);
        if (this.current == this.max) {
            this.btnUp.setEnabled(false);
        }
        if (this.current == this.min) {
            this.btnDown.setEnabled(false);
        }
    }

    public void setMin(int min) {
        if (min < 0 || min > this.max) {
            throw new IllegalArgumentException("The min value must be more or equal to zero and less than or equal to the max value");
        }
        this.min = min;
        if (this.current < min) {
            this.current = min;
        }
    }

    public void setMax(int max) {
        if (max < 0 || max < this.min) {
            throw new IllegalArgumentException("The max value must be more or equal to zero and more than or equal to the min value");
        }
        this.max = max;
        if (this.current > max) {
            this.current = max;
        }
    }

    public int getNumber() {
        return this.current;
    }

    public void setNumber(int current) {
        if (current < this.min || current > this.max) {
            throw new IllegalArgumentException("The current value must be within range of the min and max boundaries");
        }
        this.current = current;
        this.display.setText(Integer.toString(current));
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
    }
}

