/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.api.app.listener.ReleaseListener;
import dev.ultreon.devices.api.app.listener.SlideListener;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class Slider
extends Component {
    protected boolean dragging = false;
    protected int clickX;
    protected int width;
    protected int prevSliderX;
    protected int newSliderX;
    protected int sliderColor = Color.WHITE.getRGB();
    protected int backgroundColor = Color.DARK_GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();
    protected ClickListener clickListener = null;
    protected ReleaseListener releaseListener = null;
    protected SlideListener slideListener = null;

    public Slider(int left, int top, int width) {
        super(left, top);
        this.width = width;
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor());
            graphics.method_25294(this.xPosition, this.yPosition + 4, this.xPosition + this.width, this.yPosition + 8, bgColor.darker().darker().getRGB());
            graphics.method_25294(this.xPosition + 1, this.yPosition + 5, this.xPosition + this.width - 1, this.yPosition + 7, bgColor.getRGB());
            graphics.method_25294(this.xPosition + this.newSliderX, this.yPosition, this.xPosition + this.newSliderX + 8, this.yPosition + 12, bgColor.darker().darker().getRGB());
            graphics.method_25294(this.xPosition + this.newSliderX + 1, this.yPosition + 1, this.xPosition + this.newSliderX + 7, this.yPosition + 11, bgColor.brighter().brighter().getRGB());
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + this.newSliderX, this.yPosition, this.xPosition + this.newSliderX + 8, this.yPosition + 12)) {
            this.dragging = true;
            this.clickX = mouseX;
            if (this.clickListener != null) {
                this.clickListener.onClick(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (this.dragging) {
            this.newSliderX = this.prevSliderX + (mouseX - this.clickX);
            if (this.newSliderX < 0) {
                this.newSliderX = 0;
            }
            if (this.newSliderX >= this.width - 8) {
                this.newSliderX = this.width - 8;
            }
            if (this.slideListener != null) {
                this.slideListener.onSlide(this.getPercentage());
            }
        }
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        this.dragging = false;
        this.prevSliderX = this.newSliderX;
        if (this.releaseListener != null) {
            this.releaseListener.onRelease(this, 0);
        }
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + 12)) {
            this.prevSliderX = this.newSliderX++;
            if (direction) {
                if (this.newSliderX >= this.width - 8) {
                    this.newSliderX = this.width - 8;
                }
            } else {
                --this.newSliderX;
                if (this.newSliderX < 0) {
                    this.newSliderX = 0;
                }
            }
            if (this.slideListener != null) {
                this.slideListener.onSlide(this.getPercentage());
            }
        }
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setReleaseListener(ReleaseListener releaseListener) {
        this.releaseListener = releaseListener;
    }

    public void setSlideListener(SlideListener slideListener) {
        this.slideListener = slideListener;
    }

    public float getPercentage() {
        return (float)this.newSliderX / (float)(this.width - 8);
    }

    public void setPercentage(float percentage) {
        if (percentage < 0.0f || percentage > 1.0f) {
            return;
        }
        this.newSliderX = (int)((float)(this.width - 8) * percentage);
    }

    public void setSliderColor(Color color) {
        this.sliderColor = color.getRGB();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color.getRGB();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }
}

