/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.io;

import dev.ultreon.devices.api.io.DriveRoot;
import dev.ultreon.devices.api.io.FSResponse;
import dev.ultreon.devices.api.io.Folder;
import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_3902;
import org.jetbrains.annotations.Nullable;

public class Drive {
    private final String name;
    private final UUID uuid;
    private final Type type;
    private boolean synced = false;
    @Deprecated
    private Folder root;

    public Drive(class_2487 driveTag) {
        this.name = driveTag.method_10558("name");
        if (!driveTag.method_10545("uuid")) {
            throw new IllegalArgumentException("Drive must have a uuid");
        }
        this.uuid = driveTag.method_25926("uuid");
        this.type = Type.fromString(driveTag.method_10558("type"));
    }

    public Drive(String name, UUID uuid, Type type) {
        this.name = name;
        this.uuid = uuid;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Type getType() {
        return this.type;
    }

    @Deprecated
    public Folder getRoot() {
        return null;
    }

    @Deprecated
    public void syncRoot(Folder root) {
        if (!this.synced) {
            this.root = root;
            root.setDrive(this);
            root.validate();
            this.synced = true;
        }
    }

    @Deprecated
    public boolean isSynced() {
        return this.synced;
    }

    @Deprecated
    @Nullable
    public final Folder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        if (path.equals("/")) {
            return this.root;
        }
        Folder prev = this.root;
        String[] folders = path.split("/");
        if (folders.length > 0 && folders.length <= 10) {
            for (int i = 1; i < folders.length; ++i) {
                Folder temp = prev.getFolder(folders[i]);
                if (temp == null) {
                    return null;
                }
                prev = temp;
            }
            return prev;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public void exists(Path dirApplicationData, Consumer<FSResponse<Boolean>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeExists(dirApplicationData), callback);
    }

    public void info(Path path, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeInfo(path), callback);
    }

    public void list(Path currentFolder, Consumer<FSResponse<List<FileInfo>>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeList(currentFolder), callback);
    }

    public void delete(Path path, Consumer<FSResponse<class_3902>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeDelete(path), callback);
    }

    public void createFile(Path currentFolder, String name, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeNewFile(currentFolder, name, false), callback);
    }

    public void createFile(Path currentFolder, String name, boolean override, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeNewFile(currentFolder, name, override), callback);
    }

    public void createDirectory(Path currentFolder, String name, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeNewFolder(currentFolder, name, false), callback);
    }

    public void copy(Path currentFolder, Path path, boolean override, Consumer<FSResponse<FileInfo>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeCopy(currentFolder, path, override), callback);
    }

    public void move(Path source, Path destination, boolean override, Consumer<FSResponse<class_3902>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeMove(source, destination, override), callback);
    }

    public void rename(Path path, String name, Consumer<FSResponse<class_3902>> callback) {
        FileSystem.request(this.uuid, FileAction.Factory.makeRename(path, name), callback);
    }

    public void write(Path path, byte[] data, Consumer<FSResponse<FileInfo>> callback) {
        if (data.length < 1024) {
            FileSystem.request(this.uuid, FileAction.Factory.makeWrite(path, -1L, data), callback);
        } else if (data.length < 0x400000) {
            this.writeLarge(path, data, callback);
        } else {
            callback.accept(new FSResponse<Object>(false, 9, null, "File too large"));
        }
    }

    public void read(Path path, Consumer<FSResponse<byte[]>> callback) {
        this.info(path, info -> {
            if (!info.success()) {
                callback.accept(new FSResponse<Object>(false, 10, null, "File does not exist"));
                return;
            }
            if (((FileInfo)info.data()).getSize() >= 1024L) {
                this.readLarge(path, ((FileInfo)info.data()).getSize(), callback);
            } else {
                FileSystem.request(this.uuid, FileAction.Factory.makeRead(path), callback);
            }
        });
    }

    private void readLarge(final Path path, final long size, final Consumer<FSResponse<byte[]>> callback) {
        final byte[] output = new byte[(int)size];
        final AtomicInteger offset = new AtomicInteger(0);
        final int length = (int)Math.min(1024L, size - (long)offset.get());
        Object ref = new Object(){

            void fsResponseConsumer(FSResponse<byte[]> r) {
                if (!r.success()) {
                    callback.accept(r);
                    return;
                }
                int len = r.data().length;
                System.arraycopy(r.data(), 0, output, offset.get(), len);
                if (offset.get() == length) {
                    callback.accept(new FSResponse<byte[]>(true, 1, output, ""));
                    return;
                }
                FileSystem.request(Drive.this.uuid, FileAction.Factory.makeRead(path, offset.getAndSet(offset.get() + r.data().length) + r.data().length, (int)Math.min(1024L, size - (long)offset.get())), this::fsResponseConsumer);
            }
        };
        FileSystem.request(this.uuid, FileAction.Factory.makeRead(path, offset.get(), length), (ref)::fsResponseConsumer);
    }

    public DataPath getRootDirectory() {
        return new DataPath(this.uuid, Path.of("/"));
    }

    public DataPath getDirectory(Path path) {
        return new DataPath(this.uuid, path);
    }

    public void open(Consumer<FSResponse<DriveRoot>> callback) {
    }

    public void createDirectories(Path path, Consumer<FSResponse<FileInfo>> o) {
        FileSystem.request(this.uuid, FileAction.Factory.makeNewFolders(path), o);
    }

    private void writeLarge(final Path path, final byte[] data, final Consumer<FSResponse<FileInfo>> callback) {
        byte[] buffer = new byte[1024];
        final AtomicInteger offset = new AtomicInteger(0);
        final int length = Math.min(1024, data.length - offset.get());
        System.arraycopy(data, 0, buffer, 0, length);
        Object ref = new Object(){

            void fsResponseConsumer(FSResponse<FileInfo> r) {
                if (!r.success()) {
                    callback.accept(r);
                    return;
                }
                if (offset.get() + length == data.length) {
                    callback.accept(r);
                    return;
                }
                if (!Drive.this.writeNext(path, data, offset.addAndGet(length), this::fsResponseConsumer)) {
                    Drive.this.info(path, callback);
                }
            }
        };
        FileSystem.request(this.uuid, FileAction.Factory.makeWrite(path, offset.get(), buffer), (ref)::fsResponseConsumer);
    }

    private boolean writeNext(Path path, byte[] data, int offset, Consumer<FSResponse<FileInfo>> callback) {
        int length = Math.min(1024, data.length - offset);
        if (length <= 0) {
            return false;
        }
        byte[] buffer = new byte[length];
        System.arraycopy(data, offset, buffer, 0, length);
        FileSystem.request(this.uuid, FileAction.Factory.makeWrite(path, offset, buffer), callback);
        return true;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK,
        UNKNOWN;


        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.toString().equals(type)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

