/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.utils;

import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.programs.system.object.Account;
import dev.ultreon.devices.programs.system.task.TaskAdd;
import dev.ultreon.devices.programs.system.task.TaskGetBalance;
import dev.ultreon.devices.programs.system.task.TaskPay;
import dev.ultreon.devices.programs.system.task.TaskRemove;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class BankUtil
implements WorldSavedData {
    public static final BankUtil INSTANCE = new BankUtil();
    private final Map<UUID, Account> uuidToAccount = new HashMap<UUID, Account>();

    private BankUtil() {
    }

    public static void getBalance(Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskGetBalance().setCallback(callback));
    }

    public static void pay(String uuid, int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskPay().setCallback(callback));
    }

    public static void add(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskAdd(amount).setCallback(callback));
    }

    public static void remove(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskRemove(amount).setCallback(callback));
    }

    public Account getAccount(class_1657 player) {
        if (!this.uuidToAccount.containsKey(player.method_5667())) {
            this.uuidToAccount.put(player.method_5667(), new Account(0));
        }
        return this.uuidToAccount.get(player.method_5667());
    }

    public Account getAccount(UUID uuid) {
        return this.uuidToAccount.get(uuid);
    }

    @Override
    public void save(class_2487 tag) {
        class_2499 accountList = new class_2499();
        for (UUID uuid : this.uuidToAccount.keySet()) {
            class_2487 accountTag = new class_2487();
            Account account = this.uuidToAccount.get(uuid);
            accountTag.method_10582("uuid", uuid.toString());
            accountTag.method_10569("balance", account.getBalance());
            accountList.add((Object)accountTag);
        }
        tag.method_10566("accounts", (class_2520)accountList);
    }

    @Override
    public void load(class_2487 tag) {
        class_2499 accountList = (class_2499)tag.method_10580("accounts");
        for (int i = 0; i < accountList.size(); ++i) {
            class_2487 accountTag = accountList.method_10602(i);
            UUID uuid = UUID.fromString(accountTag.method_10558("uuid"));
            Account account = new Account(accountTag.method_10550("balance"));
            this.uuidToAccount.put(uuid, account);
        }
    }
}

