/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.utils;

import dev.ultreon.devices.UltreonDevices;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OnlineRequest {
    private static OnlineRequest instance = null;
    private final Queue<RequestWrapper> requests = new ConcurrentLinkedQueue<RequestWrapper>();
    private Thread thread;
    private volatile boolean running = true;

    private OnlineRequest() {
        this.start();
    }

    public static OnlineRequest getInstance() {
        if (instance == null) {
            instance = new OnlineRequest();
        }
        return instance;
    }

    public static void checkURLForSuspicions(URI url) throws IOException {
        if (!OnlineRequest.isSafe(url.getHost()) || !url.getScheme().equals("https")) {
            throw new IOException("Unsafe URL");
        }
    }

    public static boolean isSafeAddress(String address) {
        try {
            URI url = new URI(address);
            return OnlineRequest.isSafe(url.getHost());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSafe(String host) {
        return switch (host) {
            case "ultreon.gitlab.io", "cdn.discordapp.com", "jab125.com", "jab125.dev", "raw.githubusercontent.com", "github.com", "i.imgur.com", "i.giphy.com", "avatars1.githubusercontent.com" -> true;
            default -> false;
        };
    }

    private void start() {
        this.thread = new Thread((Runnable)new RequestRunnable(), "Online Request Thread");
        this.thread.start();
    }

    public void make(String url, ResponseHandler handler) {
        this.make(url, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make(String url, ResponseHandler handler, boolean bypassCheck) {
        if (!bypassCheck) {
            try {
                OnlineRequest.checkURLForSuspicions(new URI(url));
            }
            catch (IOException e) {
                handler.handle(false, e.getMessage().getBytes());
                return;
            }
            catch (URISyntaxException e) {
                handler.handle(false, "Malformed URL".getBytes());
                return;
            }
        }
        Queue<RequestWrapper> queue = this.requests;
        synchronized (queue) {
            this.requests.offer(new RequestWrapper(url, handler));
            this.requests.notify();
        }
    }

    public void stop() {
        this.running = false;
        this.thread.interrupt();
    }

    private class RequestRunnable
    implements Runnable {
        private RequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (OnlineRequest.this.running) {
                try {
                    Queue<RequestWrapper> queue = OnlineRequest.this.requests;
                    synchronized (queue) {
                        OnlineRequest.this.requests.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                while (!OnlineRequest.this.requests.isEmpty()) {
                    URI url;
                    RequestWrapper wrapper = OnlineRequest.this.requests.poll();
                    try {
                        url = new URI(wrapper.url);
                    }
                    catch (URISyntaxException e) {
                        wrapper.handler.handle(false, "Malformed URL".getBytes());
                        continue;
                    }
                    try {
                        HttpClient client = HttpClient.newHttpClient();
                        try {
                            HttpRequest request = HttpRequest.newBuilder().uri(url).GET().build();
                            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                            try {
                                wrapper.handler.handle(response.statusCode() >= 200 && response.statusCode() < 400, response.body().getBytes());
                            }
                            catch (Exception e) {
                                UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
                                try {
                                    wrapper.handler.handle(false, "Internal error".getBytes());
                                }
                                catch (Exception ex) {
                                    UltreonDevices.LOGGER.error("A double fault has occurred.", (Throwable)ex);
                                }
                            }
                        }
                        finally {
                            if (client == null) continue;
                            client.close();
                        }
                    }
                    catch (Exception e) {
                        UltreonDevices.LOGGER.error("An error has occurred.", (Throwable)e);
                        try {
                            wrapper.handler.handle(false, "Internal error".getBytes());
                        }
                        catch (Exception ex) {
                            UltreonDevices.LOGGER.error("A double fault has occurred.", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    public static interface ResponseHandler {
        public void handle(boolean var1, byte[] var2);
    }

    private record RequestWrapper(String url, ResponseHandler handler) {
    }
}

