/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.block.ClientLaptopWrapper;
import dev.ultreon.devices.block.ColoredBlock;
import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.computer.LaptopBlockEntity;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.item.FlashDriveItem;
import dev.ultreon.devices.util.BlockEntityUtil;
import dev.ultreon.devices.util.Colorable;
import dev.ultreon.mods.xinexlib.Env;
import dev.ultreon.mods.xinexlib.EnvExecutor;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComputerBlock
extends DeviceBlock {
    public ComputerBlock(class_4970.class_2251 properties) {
        super(properties, DeviceType.COMPUTER);
    }

    @NotNull
    public class_1269 method_55766(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hitResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof LaptopBlockEntity) {
            LaptopBlockEntity laptop = (LaptopBlockEntity)blockEntity;
            if (player.method_18276()) {
                if (!level.field_9236) {
                    laptop.openClose((class_1297)player);
                }
                return class_1269.field_5812;
            }
            if (laptop.isOpen()) {
                if (level.field_9236) {
                    EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> ClientLaptopWrapper.execute(laptop));
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @NotNull
    protected class_9062 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hitResult) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof LaptopBlockEntity)) {
            return class_9062.field_47731;
        }
        LaptopBlockEntity laptop = (LaptopBlockEntity)blockEntity;
        if (hitResult.method_17780() != ((class_2350)state.method_11654((class_2769)field_11177)).method_35833(class_2350.class_2351.field_11052)) {
            return class_9062.field_47731;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (!heldItem.method_7960() && heldItem.method_7909() instanceof FlashDriveItem && laptop.canChangeAttachment()) {
            if (laptop.getFileSystem().attachDrive(heldItem.method_7972())) {
                DebugLog.logTime(level.method_8510(), "Attached Drive");
                laptop.setAttachmentCooldown(10);
                heldItem.method_7934(1);
                return class_9062.method_55644((boolean)level.field_9236);
            }
            return class_9062.field_47733;
        }
        if (!laptop.canChangeAttachment()) {
            return class_9062.field_47731;
        }
        class_1799 detachedDrive = laptop.getFileSystem().detachDrive();
        if (detachedDrive == null) {
            return class_9062.field_47731;
        }
        DebugLog.logTime(level.method_8510(), "Detached Drive");
        laptop.setAttachmentCooldown(10);
        class_2338 summonPos = pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_35833(class_2350.class_2351.field_11052));
        level.method_8649((class_1297)new class_1542(level, (double)summonPos.method_10263() + 0.5, (double)summonPos.method_10264(), (double)summonPos.method_10260() + 0.5, detachedDrive));
        BlockEntityUtil.markBlockForUpdate(level, pos);
        return class_9062.method_55644((boolean)level.field_9236);
    }

    public abstract boolean isDesktopPC();

    public boolean isLaptop() {
        return !this.isDesktopPC();
    }

    @Override
    protected void removeTagsForDrop(class_2487 tileEntityTag) {
        tileEntityTag.method_10551("open");
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(new class_2769[]{field_11177});
    }

    public static abstract class Colored
    extends ComputerBlock
    implements ColoredBlock {
        private final class_1767 color;

        protected Colored(class_4970.class_2251 properties, class_1767 color, DeviceType deviceType) {
            super(properties);
            this.color = color;
        }

        @Override
        public class_1767 getColor() {
            return this.color;
        }

        @Override
        public void method_9567(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 placer, @NotNull class_1799 stack) {
            super.method_9567(level, pos, state, placer, stack);
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof Colorable) {
                Colorable colored = (Colorable)blockEntity;
                colored.setColor(this.color);
            }
        }

        @Override
        protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull class_2689.class_2690<class_2248, class_2680> pBuilder) {
            super.method_9515(pBuilder);
        }
    }

    public static enum Type implements class_3542
    {
        BASE,
        SCREEN;


        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

