/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.computer;

import dev.ultreon.devices.block.computer.LaptopBlock;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.init.DeviceBlockEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaptopBlockEntity
extends ComputerBlockEntity {
    private static final int OPENED_ANGLE = 102;
    private int attachmentCooldown;
    private int rotation;
    private int prevRotation;
    private boolean open = false;

    public LaptopBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super((class_2591<? extends ComputerBlockEntity>)((class_2591)DeviceBlockEntities.LAPTOP.get()), pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        super.tick();
        class_1937 level = this.field_11863;
        if (level == null) {
            return;
        }
        if ((Boolean)this.method_11010().method_11654((class_2769)LaptopBlock.OPEN) != this.open) {
            level.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open)), 2);
        }
        if (level.field_9236) {
            this.prevRotation = this.rotation;
            if (!this.open) {
                if (this.rotation > 0) {
                    this.rotation -= 10;
                }
            } else if (this.rotation < 102) {
                this.rotation += 10;
            }
        }
        if (this.attachmentCooldown > 0) {
            --this.attachmentCooldown;
        }
    }

    public float getScreenAngle(float partialTicks) {
        return -102.0f * (((float)this.prevRotation + (float)(this.rotation - this.prevRotation) * partialTicks) / 102.0f);
    }

    @Override
    public void method_11014(@NotNull class_2487 compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        if (compound.method_10545("open")) {
            this.open = compound.method_10577("open");
            class_1937 level = this.method_10997();
            if (level != null) {
                level.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open)), 2);
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        compound.method_10556("open", this.open);
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10556("open", this.open);
        return tag;
    }

    @Override
    public boolean isPoweredOn() {
        return this.isOpen();
    }

    @Override
    public void powerOff() {
        super.powerOff();
        if (this.isOpen()) {
            this.openClose(null);
        }
    }

    public void setAttachmentCooldown(int ticks) {
        this.attachmentCooldown = Math.max(ticks, 0);
    }

    public boolean canChangeAttachment() {
        return this.attachmentCooldown <= 0;
    }

    public void openClose(@Nullable class_1297 entity) {
        class_1937 level = this.field_11863;
        if (level != null) {
            level.method_43276((class_6880)(!this.open ? class_5712.field_28168 : class_5712.field_28169), this.method_11016(), class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
        }
        boolean oldOpen = this.open;
        boolean bl = this.open = (Boolean)this.method_11010().method_11654((class_2769)LaptopBlock.OPEN) == false;
        if (oldOpen != this.open) {
            this.pipeline.method_10556("open", this.open);
            class_2680 d = (class_2680)this.method_11010().method_11657((class_2769)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open));
            this.field_11863.method_8652(this.method_11016(), d, 18);
            this.sync();
        }
        if (level != null) {
            this.markUpdated();
            LaptopBlockEntity.doNeighborUpdates(level, this.method_11016(), this.method_11010());
        }
    }

    public boolean isOpen() {
        return this.open;
    }
}

