/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.block.PaperBlock;
import dev.ultreon.devices.block.entity.PaperBlockEntity;
import dev.ultreon.devices.block.entity.renderer.PrinterRenderer;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public record PaperRenderer(class_5614.class_5615 context) implements class_827<PaperBlockEntity>
{
    private static final int TextureIndex = 0;

    private static void drawPixels(class_4587 poseStack, int[] pixels, int resolution, boolean cut, int packedLight, int packedOverlay, class_4597 bufferSource) {
        class_1043 d = new class_1043(resolution, resolution, true);
        for (int i = 0; i < resolution; ++i) {
            for (int j = 0; j < resolution; ++j) {
                int r = pixels[j + i * resolution] >> 16 & 0xFF;
                int g = pixels[j + i * resolution] >> 8 & 0xFF;
                int b = pixels[j + i * resolution] & 0xFF;
                int a = (int)((double)(pixels[j + i * resolution] >> 24 & 0xFF));
                assert (d.method_4525() != null);
                d.method_4525().method_4305(i, j, new Color(r, g, b, a).getRGB());
            }
        }
        class_2960 resourcelocation = class_310.method_1551().method_1531().method_4617("map/0", d);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        class_4588 vertexconsumer = bufferSource.getBuffer(class_1921.method_23028((class_2960)resourcelocation));
        vertexconsumer.method_22918(matrix4f, 0.0f, 1.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_60803(packedLight);
        vertexconsumer.method_22918(matrix4f, 1.0f, 1.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_60803(packedLight);
        vertexconsumer.method_22918(matrix4f, 1.0f, 0.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_60803(packedLight);
        vertexconsumer.method_22918(matrix4f, 0.0f, 0.0f, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_60803(packedLight);
    }

    public void render(PaperBlockEntity blockEntity, float partialTick, @NotNull class_4587 pose, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2487 data;
        class_2680 state = Objects.requireNonNull(blockEntity.method_10997()).method_8320(blockEntity.method_11016());
        if (blockEntity.method_11010().method_26204() != state.method_26204()) {
            UltreonDevices.LOGGER.error("Paper block mismatch: {} != {}", (Object)blockEntity.method_11010().method_26204(), (Object)state.method_26204());
            return;
        }
        pose.method_22903();
        pose.method_46416((float)blockEntity.method_11016().method_10263(), (float)blockEntity.method_11016().method_10264(), (float)blockEntity.method_11016().method_10260());
        pose.method_22904(0.5, 0.5, 0.5);
        pose.method_22907(((class_2350)state.method_11654((class_2769)PaperBlock.field_11177)).method_23224());
        pose.method_22907(new Quaternionf(0.0f, 0.0f, 1.0f, -blockEntity.getRotation()));
        pose.method_22904(-0.5, -0.5, -0.5);
        IPrint print = blockEntity.getPrint();
        if (print != null && (data = print.toTag()).method_10573("pixels", 11) && data.method_10573("resolution", 3)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)PrinterRenderer.PaperModel.TEXTURE);
            if (!((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() || !data.method_10577("cut")) {
                // empty if block
            }
            pose.method_22904(0.0, 0.0, (Boolean)DeviceConfig.RENDER_PRINTED_3D.get() != false ? 0.0625 : 0.001);
            pose.method_22903();
            IPrint.Renderer renderer = PrintingManager.getRenderer(print);
            renderer.render(pose, data);
            pose.method_22909();
            pose.method_22903();
            if (((Boolean)DeviceConfig.RENDER_PRINTED_3D.get()).booleanValue() && data.method_10577("cut")) {
                class_2487 tag = print.toTag();
                PaperRenderer.drawPixels(pose, tag.method_10561("pixels"), tag.method_10550("resolution"), tag.method_10577("cut"), packedLight, packedOverlay, bufferSource);
            }
            pose.method_22909();
        }
        pose.method_22909();
    }
}

