/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Device {
    protected UUID id;
    protected String name;
    protected class_2338 pos;

    protected Device() {
    }

    public Device(@NotNull DeviceBlockEntity device) {
        this.id = device.getId();
        this.update(device);
    }

    public Device(@NotNull UUID id, @NotNull String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(@Nullable class_2338 pos) {
        this.pos = pos;
    }

    public void update(@NotNull DeviceBlockEntity device) {
        this.name = device.getCustomName();
        this.pos = device.method_11016();
    }

    @Nullable
    public DeviceBlockEntity getDevice(@NotNull class_1937 level) {
        DeviceBlockEntity deviceBlockEntity;
        if (this.pos == null) {
            return null;
        }
        class_2586 blockEntity = level.method_8321(this.pos);
        if (blockEntity instanceof DeviceBlockEntity && (deviceBlockEntity = (DeviceBlockEntity)blockEntity).getId().equals(this.getId())) {
            return deviceBlockEntity;
        }
        return null;
    }

    public class_2487 toTag(boolean includePos) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", this.getId().toString());
        tag.method_10582("name", this.getName());
        if (includePos) {
            tag.method_10544("pos", this.pos.method_10063());
        }
        return tag;
    }

    public static Device fromTag(class_2487 tag) {
        Device device = new Device();
        device.id = UUID.fromString(tag.method_10558("id"));
        device.name = tag.method_10558("name");
        if (tag.method_10573("pos", 4)) {
            device.pos = class_2338.method_10092((long)tag.method_10537("pos"));
        }
        return device;
    }
}

