/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.core.io.drive.ExternalDrive;
import dev.ultreon.devices.core.io.drive.InternalDrive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import org.jetbrains.annotations.ApiStatus;

public class DriveManager {
    private static final Map<UUID, ExternalDrive> EXTERNAL_DRIVES = new ConcurrentHashMap<UUID, ExternalDrive>();
    private static final Map<UUID, InternalDrive> INTERNAL_DRIVES = new ConcurrentHashMap<UUID, InternalDrive>();
    private static final Map<UUID, Long> LAST_ACCESS_TIMES = new ConcurrentHashMap<UUID, Long>();

    public static InternalDrive getInternalDrive(UUID uuid) {
        return INTERNAL_DRIVES.computeIfAbsent(uuid, id -> InternalDrive.load(id, AbstractDrive.getDrivePath(id)));
    }

    public static ExternalDrive getExternalDrive(UUID uuid) {
        return EXTERNAL_DRIVES.computeIfAbsent(uuid, id -> ExternalDrive.load(id, AbstractDrive.getDrivePath(id)));
    }

    public static void registerExternalDrive(ExternalDrive externalDrive) {
        EXTERNAL_DRIVES.put(externalDrive.getUuid(), externalDrive);
    }

    public static void registerInternalDrive(InternalDrive internalDrive) {
        INTERNAL_DRIVES.put(internalDrive.getUuid(), internalDrive);
    }

    public static void removeDrive(UUID uuid) {
        INTERNAL_DRIVES.remove(uuid);
        EXTERNAL_DRIVES.remove(uuid);
        AbstractDrive.deleteDrivePath(uuid);
    }

    @ApiStatus.Internal
    public static void loadDriveMeta() {
        Path resolve = UltreonDevices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drive_meta.dat");
        if (Files.exists(resolve, new LinkOption[0])) {
            class_2487 driveMeta = null;
            try {
                driveMeta = class_2507.method_30613((Path)resolve, (class_2505)class_2505.method_53898());
            }
            catch (IOException e) {
                UltreonDevices.LOGGER.error("Failed to load drive meta!", (Throwable)e);
            }
            if (driveMeta != null) {
                class_2487 driveMetaInternal = driveMeta.method_10562("Internal");
                for (String key : driveMetaInternal.method_10541()) {
                    long lastAccessed = driveMetaInternal.method_10537(key);
                    if (lastAccessed <= 0L) continue;
                    UUID uuid = UUID.fromString(key);
                    LAST_ACCESS_TIMES.put(uuid, lastAccessed);
                }
                class_2487 driveMetaExternal = driveMeta.method_10562("External");
                for (String key : driveMetaExternal.method_10541()) {
                    long lastAccessed = driveMetaExternal.method_10537(key);
                    if (lastAccessed <= 0L) continue;
                    UUID uuid = UUID.fromString(key);
                    LAST_ACCESS_TIMES.put(uuid, lastAccessed);
                }
            }
        }
    }

    public static void saveDriveMeta() {
        class_2487 driveMeta = new class_2487();
        class_2487 driveMetaInternal = new class_2487();
        for (UUID uUID : INTERNAL_DRIVES.keySet()) {
            long lastAccessed = INTERNAL_DRIVES.get(uUID).getLastAccessed();
            if (lastAccessed <= 0L) continue;
            driveMetaInternal.method_10544(uUID.toString(), lastAccessed);
        }
        driveMeta.method_10566("Internal", (class_2520)driveMetaInternal);
        class_2487 driveMetaExternal = new class_2487();
        for (UUID uuid : EXTERNAL_DRIVES.keySet()) {
            long lastAccessed = EXTERNAL_DRIVES.get(uuid).getLastAccessed();
            if (lastAccessed <= 0L) continue;
            driveMetaExternal.method_10544(uuid.toString(), lastAccessed);
        }
        driveMeta.method_10566("External", (class_2520)driveMetaExternal);
        Path path = UltreonDevices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drive_meta.dat");
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                UltreonDevices.LOGGER.error("Failed to create drive meta directory!", (Throwable)e);
            }
        }
        try {
            class_2507.method_30614((class_2487)driveMeta, (Path)path);
        }
        catch (IOException e) {
            UltreonDevices.LOGGER.error("Failed to save drive meta!", (Throwable)e);
        }
    }

    @Deprecated
    public static void removeAllDrives() {
        for (UUID uuid : INTERNAL_DRIVES.keySet()) {
            DriveManager.removeDrive(uuid);
        }
        for (UUID uuid : EXTERNAL_DRIVES.keySet()) {
            DriveManager.removeDrive(uuid);
        }
    }

    public static void removeOldDrives(Duration duration) {
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Long> entry : LAST_ACCESS_TIMES.entrySet()) {
            if (now - entry.getValue() <= duration.toMillis()) continue;
            DriveManager.removeDrive(entry.getKey());
        }
    }

    public static void updateLastAccessed(UUID uuid, long lastAccessed) {
        LAST_ACCESS_TIMES.put(uuid, lastAccessed);
    }
}

