/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Wrappable;
import dev.ultreon.devices.gui.GuiButtonClose;
import dev.ultreon.devices.util.GLHelper;
import java.awt.Color;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class Window<T extends Wrappable> {
    public static final class_2960 WINDOW_GUI = class_2960.method_60654((String)"devices:textures/gui/application.png");
    public static final int COLOR_WINDOW_DARK = new Color(0.0f, 0.0f, 0.0f, 0.25f).getRGB();
    final ComputerScreen computerScreen;
    double dragFromX;
    double dragFromY;
    protected GuiButtonClose btnClose;
    T content;
    int width;
    int height;
    int offsetX;
    int offsetY;
    Window<Dialog> dialogWindow = null;
    Window<? extends Wrappable> parent = null;
    protected boolean removed;
    protected final class_310 minecraft = class_310.method_1551();

    public Window(T wrappable, ComputerScreen computerScreen) {
        this.content = wrappable;
        this.computerScreen = computerScreen;
        ((Wrappable)wrappable).setWindow(this);
    }

    void setWidth(int width) {
        this.width = width + 2;
        if (this.width > ComputerScreen.getScreenWidth()) {
            this.width = ComputerScreen.getScreenWidth();
        }
    }

    void setHeight(int height) {
        this.height = height + 14;
        if (this.height > 178) {
            this.height = 178;
        }
    }

    void init(int x, int y, @Nullable class_2487 intent) {
        try {
            this.btnClose = new GuiButtonClose(x + this.offsetX + this.width - 12, y + this.offsetY + 1);
            ((Wrappable)this.content).init(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            Dialog.Message message = new Dialog.Message(this, "Error initializing window:\n" + e.getMessage()){

                @Override
                public void onClose() {
                    super.onClose();
                }
            };
            this.closeDialog();
            this.openDialog(message);
        }
    }

    public void onTick() {
        if (this.dialogWindow != null) {
            this.dialogWindow.onTick();
        }
        ((Wrappable)this.content).onTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_332 graphics, ComputerScreen gui, class_310 mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        if (((Wrappable)this.content).isPendingLayoutUpdate()) {
            this.setWidth(((Wrappable)this.content).getWidth());
            this.setHeight(((Wrappable)this.content).getHeight());
            this.offsetX = (ComputerScreen.getScreenWidth() - this.width) / 2;
            this.offsetY = (ComputerScreen.getScreenHeight() - 18 - this.height) / 2;
            this.updateComponents(x, y);
            ((Wrappable)this.content).clearPendingLayout();
        }
        graphics.method_51448().method_22903();
        GLHelper.pushScissor(x + this.offsetX, y + this.offsetY, this.width, this.height);
        try {
            this.minecraft.field_1773.method_57796(partialTicks);
            this.minecraft.method_1522().method_1235(false);
            graphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getWindowBackgroundColor(), true);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW_GUI);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            graphics.method_25302(WINDOW_GUI, x + this.offsetX, y + this.offsetY, 0, 0, 1, 1);
            graphics.method_25302(WINDOW_GUI, x + this.offsetX + this.width - 13, y + this.offsetY, 2, 0, 13, 13);
            graphics.method_25302(WINDOW_GUI, x + this.offsetX + this.width - 1, y + this.offsetY + this.height - 1, 14, 14, 1, 1);
            graphics.method_25302(WINDOW_GUI, x + this.offsetX, y + this.offsetY + this.height - 1, 0, 14, 1, 1);
            graphics.method_25293(WINDOW_GUI, x + this.offsetX + 1, y + this.offsetY, this.width - 14, 13, 1.0f, 0.0f, 1, 13, 256, 256);
            graphics.method_25293(WINDOW_GUI, x + this.offsetX + this.width - 1, y + this.offsetY + 13, 1, this.height - 14, 14.0f, 13.0f, 1, 1, 256, 256);
            graphics.method_25293(WINDOW_GUI, x + this.offsetX + 1, y + this.offsetY + this.height - 1, this.width - 2, 1, 1.0f, 14.0f, 13, 1, 256, 256);
            graphics.method_25293(WINDOW_GUI, x + this.offsetX, y + this.offsetY + 13, 1, this.height - 14, 0.0f, 13.0f, 1, 1, 256, 256);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)(color.getAlpha() == 0 ? 1.0f : (float)color.getAlpha() / 255.0f));
            graphics.method_25293(WINDOW_GUI, x + this.offsetX + 1, y + this.offsetY + 13, this.width - 2, this.height - 14, 1.0f, 13.0f, 13, 1, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String windowTitle = ((Wrappable)this.content).getWindowTitle();
            if (mc.field_1772.method_1727(windowTitle) > this.width - 2 - 13 - 3) {
                windowTitle = mc.field_1772.method_27523(windowTitle, this.width - 2 - 13 - 3);
            }
            graphics.method_51433(mc.field_1772, windowTitle, x + this.offsetX + 3, y + this.offsetY + 3, Color.WHITE.getRGB(), true);
            this.btnClose.method_48579(graphics, mouseX, mouseY, partialTicks);
            RenderSystem.disableBlend();
            ((Wrappable)this.content).render(graphics, gui, mc, x + this.offsetX + 1, y + this.offsetY + 13, mouseX, mouseY, active && this.dialogWindow == null, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        }
        finally {
            GLHelper.popScissor();
        }
        graphics.method_51448().method_22909();
    }

    public final void renderOverlay(class_332 graphics, ComputerScreen gui, class_310 mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        if (this.dialogWindow != null) {
            graphics.method_25294(x + this.offsetX, y + this.offsetY, x + this.offsetX + this.width, y + this.offsetY + this.height, COLOR_WINDOW_DARK);
            this.dialogWindow.render(graphics, gui, mc, x, y, mouseX, mouseY, active, partialTicks);
        }
    }

    @Deprecated
    public void handleKeyTyped(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyTyped(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyTyped(character, code);
    }

    @Deprecated
    public void handleKeyReleased(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyReleased(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyReleased(character, code);
    }

    public void handleCharTyped(char codePoint, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleCharTyped(codePoint, modifiers);
            return;
        }
        ((Wrappable)this.content).handleCharTyped(codePoint, modifiers);
    }

    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyPressed(keyCode, scanCode, modifiers);
            return;
        }
        ((Wrappable)this.content).handleKeyPressed(keyCode, scanCode, modifiers);
    }

    public void handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyReleased(keyCode, scanCode, modifiers);
            return;
        }
        ((Wrappable)this.content).handleKeyReleased(keyCode, scanCode, modifiers);
    }

    public void handleWindowMove(int screenStartX, int screenStartY, int newX, int newY) {
        this.offsetX = newX >= 0 && newX <= ComputerScreen.getScreenWidth() - this.width ? newX : (newX < 0 ? 0 : ComputerScreen.getScreenWidth() - this.width);
        this.offsetY = newY >= 0 && newY <= ComputerScreen.getScreenHeight() - 18 - this.height ? newY : (newY < 0 ? 0 : ComputerScreen.getScreenHeight() - 18 - this.height);
        this.updateComponents(screenStartX, screenStartY);
    }

    void handleMouseClick(ComputerScreen gui, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.btnClose.method_49606()) {
            if (this.content instanceof Application) {
                gui.closeApplication(((Application)this.content).getInfo());
                return;
            }
            if (this.parent != null) {
                this.parent.closeDialog();
            } else {
                this.close();
            }
        }
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseClick(gui, x, y, mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseClick(mouseX, mouseY, mouseButton);
    }

    void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseDrag(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseRelease(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    void handleMouseScroll(int mouseX, int mouseY, double delta, boolean direction) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseScroll(mouseX, mouseY, delta, direction);
            return;
        }
        ((Wrappable)this.content).handleMouseScroll(mouseX, mouseY, delta, direction);
    }

    public void handleClose() {
        ((Wrappable)this.content).onClose();
    }

    private void updateComponents(int x, int y) {
        ((Wrappable)this.content).updateComponents(x + this.offsetX + 1, y + this.offsetY + 13);
        this.btnClose.method_46421(x + this.offsetX + this.width - 12);
        this.btnClose.method_46419(y + this.offsetY + 1);
    }

    public void setPosition(int x, int y) {
        ((Wrappable)this.content).updateComponents(x + this.offsetX + 1, y + this.offsetY + 13);
        this.btnClose.method_46421(x + this.offsetX + this.width - 12);
        this.btnClose.method_46419(y + this.offsetY + 1);
    }

    public void openDialog(Dialog dialog) {
        if (this.dialogWindow != null) {
            this.dialogWindow.openDialog(dialog);
        } else {
            this.dialogWindow = new Window<Dialog>(dialog, null);
            this.dialogWindow.init(0, 0, null);
            this.dialogWindow.setParent(this);
        }
    }

    public void closeDialog() {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleClose();
            this.dialogWindow = null;
        }
    }

    public Window<Dialog> getDialogWindow() {
        return this.dialogWindow;
    }

    public final void close() {
        this.removed = true;
        if (this.content instanceof Application) {
            this.computerScreen.closeApplication(((Application)this.content).getInfo());
            return;
        }
        if (this.parent != null) {
            this.parent.closeDialog();
        }
    }

    public Window<?> getParent() {
        return this.parent;
    }

    public void setParent(Window<?> parent) {
        this.parent = parent;
    }

    public T getContent() {
        return this.content;
    }
}

