/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.action;

import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.action.ModNbtUtils;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3902;

public record FileAction<T>(Type type, class_2487 data, Function<class_2487, T> deserializer) {
    public static final Function<class_2487, Object> NULL = tag1 -> null;

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("type", this.type.ordinal());
        tag.method_10566("data", (class_2520)this.data);
        return tag;
    }

    public static FileAction<?> fromTag(class_2487 tag) {
        Type type = Type.values()[tag.method_10550("type")];
        class_2487 data = tag.method_10562("data");
        return new FileAction<Object>(type, data, NULL);
    }

    @Override
    public String toString() {
        return "FileAction{type=" + String.valueOf((Object)this.type) + "}";
    }

    public T deserialize(class_2487 data) {
        if (this.deserializer == NULL) {
            throw new UnsupportedOperationException();
        }
        return this.deserializer.apply(data);
    }

    public static enum Type {
        NEW_FILE,
        NEW_FOLDER,
        DELETE,
        RENAME,
        WRITE,
        EXISTS,
        READ,
        LIST_DIR,
        INFO,
        MOVE,
        COPY,
        EXTRA_INFO,
        NEW_FOLDERS,
        COPY_CUT;

    }

    public static class Factory {
        public static FileAction<FileInfo> makeNewFile(Path parent, String name, boolean override) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", parent.resolve(name).toString());
            vars.method_10556("override", override);
            vars.method_10570("data", new byte[0]);
            return new FileAction<FileInfo>(Type.NEW_FILE, vars, FileInfo::fromTag);
        }

        public static FileAction<FileInfo> makeNewFolder(Path parent, String name, boolean override) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", parent.resolve(name).toString());
            vars.method_10556("override", override);
            return new FileAction<FileInfo>(Type.NEW_FOLDER, vars, FileInfo::fromTag);
        }

        public static FileAction<class_3902> makeDelete(Path file) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", file.toString());
            return new FileAction<class_3902>(Type.DELETE, vars, tag -> class_3902.field_17274);
        }

        public static FileAction<class_3902> makeRename(Path file, String newFileName) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", file.toString());
            vars.method_10582("new_file_name", newFileName);
            return new FileAction<class_3902>(Type.RENAME, vars, tag -> class_3902.field_17274);
        }

        @Deprecated
        public static FileAction<class_3902> makeData(Path file, class_2487 data) throws IOException {
            class_2487 vars = new class_2487();
            vars.method_10582("path", file.toString());
            vars.method_10570("data", ModNbtUtils.toBytes((class_2520)data));
            return new FileAction<class_3902>(Type.WRITE, vars, tag -> class_3902.field_17274);
        }

        public static FileAction<FileInfo> makeWrite(Path file, long offset, byte[] data) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", file.toString());
            vars.method_10544("offset", offset);
            vars.method_10570("data", data);
            return new FileAction<FileInfo>(Type.WRITE, vars, FileInfo::fromTag);
        }

        @Deprecated
        public static FileAction<class_3902> makeCopyCut(Path source, DataPath destination, boolean override, boolean cut) {
            class_2487 vars = new class_2487();
            vars.method_10582("source", source.toString());
            vars.method_10582("destination_drive", destination.drive().toString());
            vars.method_10582("destination_folder", destination.path().toString());
            vars.method_10556("override", override);
            vars.method_10556("cut", cut);
            return new FileAction<class_3902>(Type.COPY_CUT, vars, tag -> class_3902.field_17274);
        }

        public static FileAction<Boolean> makeExists(Path path) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            return new FileAction<Boolean>(Type.EXISTS, vars, tag -> tag.method_10577("exists"));
        }

        public static FileAction<byte[]> makeRead(Path path) {
            return Factory.makeRead(path, -1L, -1);
        }

        public static FileAction<byte[]> makeRead(Path path, long offset, int length) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            vars.method_10544("offset", offset);
            vars.method_10569("length", length);
            return new FileAction<byte[]>(Type.READ, vars, tag -> tag.method_10547("data"));
        }

        public static FileAction<List<FileInfo>> makeList(Path path) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            return new FileAction<List<FileInfo>>(Type.LIST_DIR, vars, tag -> {
                ArrayList<FileInfo> list = new ArrayList<FileInfo>();
                class_2499 listTag = tag.method_10554("files", 10);
                for (class_2520 tag1 : listTag) {
                    if (!(tag1 instanceof class_2487)) continue;
                    class_2487 compoundTag = (class_2487)tag1;
                    list.add(FileInfo.fromTag(compoundTag));
                }
                return list;
            });
        }

        public static FileAction<FileInfo> makeInfo(Path path) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            return new FileAction<FileInfo>(Type.INFO, vars, FileInfo::fromTag);
        }

        public static FileAction<class_3902> makeMove(Path source, Path destination, boolean override) {
            class_2487 vars = new class_2487();
            vars.method_10582("source", source.toString());
            vars.method_10582("destination", destination.toString());
            vars.method_10556("override", override);
            return new FileAction<class_3902>(Type.MOVE, vars, tag -> class_3902.field_17274);
        }

        public static FileAction<FileInfo> makeCopy(Path source, Path destination, boolean override) {
            class_2487 vars = new class_2487();
            vars.method_10582("source", source.toString());
            vars.method_10582("destination", destination.toString());
            vars.method_10556("override", override);
            return new FileAction<FileInfo>(Type.COPY, vars, FileInfo::fromTag);
        }

        public static FileAction<class_2487> makeExtraInfo(Path path) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            return new FileAction<class_2487>(Type.EXTRA_INFO, vars, Function.identity());
        }

        public static FileAction<FileInfo> makeNewFolders(Path path) {
            class_2487 vars = new class_2487();
            vars.method_10582("path", path.toString());
            return new FileAction<FileInfo>(Type.NEW_FOLDERS, vars, FileInfo::fromTag);
        }
    }
}

