/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.DriveManager;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jnode.fs.FileSystemException;

public final class InternalDrive
extends AbstractDrive {
    public InternalDrive(String name) {
        super(name);
        DriveManager.registerInternalDrive(this);
    }

    public InternalDrive(String name, UUID uuid) {
        super(uuid);
        DriveManager.registerInternalDrive(this);
    }

    @Override
    protected void setup() {
        super.setup();
        try {
            this.createDirectory(Path.of("/Home"));
            this.createDirectory(Path.of("/ApplicationData"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InternalDrive(UUID uuid, java.nio.file.Path drivePath) throws FileSystemException, IOException {
        super(uuid, drivePath);
    }

    @ApiStatus.Internal
    @NotNull
    public static AbstractDrive fromTag(class_2487 driveTag) {
        String string = driveTag.toString();
        System.out.println("string = " + string);
        if (!driveTag.method_10545("uuid")) {
            if (!driveTag.method_10545("name")) {
                return new InternalDrive("Drive");
            }
            return new InternalDrive(driveTag.method_10558("name"));
        }
        if (!driveTag.method_10545("name")) {
            return new InternalDrive("Drive", class_2512.method_25930((class_2520)driveTag.method_10562("uuid")));
        }
        try {
            class_2520 uuid1 = driveTag.method_10580("uuid");
            if (!(uuid1 instanceof class_2495)) {
                UltreonDevices.LOGGER.warn("Invalid uuid tag in drive tag: {}", (Object)uuid1);
                return new InternalDrive(driveTag.method_10545("name") ? driveTag.method_10558("name") : "Drive");
            }
            UUID uuid2 = class_2512.method_25930((class_2520)uuid1);
            return DriveManager.getInternalDrive(uuid2);
        }
        catch (Exception e) {
            return new InternalDrive("Drive");
        }
    }

    @Deprecated
    public static InternalDrive load(UUID uuid, java.nio.file.Path drivePath) {
        try {
            return new InternalDrive(uuid, drivePath);
        }
        catch (IOException | FileSystemException e) {
            return null;
        }
    }

    @Override
    public class_2487 toTag() {
        class_2487 driveTag = new class_2487();
        driveTag.method_10582("name", this.name);
        driveTag.method_10566("uuid", (class_2520)class_2512.method_25929((UUID)this.uuid));
        return driveTag;
    }

    @Override
    public AbstractDrive.Type getType() {
        return AbstractDrive.Type.INTERNAL;
    }
}

