/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_7225;

public class TaskGetFiles
extends Task {
    private String uuid;
    private Path path;
    private class_2338 pos;
    private List<String> files;
    private String error;

    public TaskGetFiles() {
    }

    public TaskGetFiles(DataPath path, class_2338 pos) {
        this();
        this.uuid = path.drive().toString();
        this.path = path.path();
        this.pos = pos;
    }

    @Override
    public void prepareRequest(class_7225.class_7874 provider, class_2487 tag) {
        tag.method_10582("uuid", this.uuid);
        tag.method_10582("path", this.path.toString());
        tag.method_10544("pos", this.pos.method_10063());
    }

    @Override
    public void processRequest(class_7225.class_7874 provider, class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092((long)tag.method_10537("pos"))).method_12201(class_2338.method_10092((long)tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (!(tileEntity instanceof ComputerBlockEntity)) {
            return;
        }
        ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
        FileSystem fileSystem = laptop.getFileSystem();
        UUID uuid = UUID.fromString(tag.method_10558("uuid"));
        AbstractDrive serverDrive = fileSystem.getAvailableDrives(level, true).get(uuid);
        if (serverDrive == null) {
            return;
        }
        String path = tag.method_10558("path");
        try {
            Iterator<String> stringIterator = serverDrive.listDirectory(Path.of(path));
            this.files = new ArrayList<String>();
            while (stringIterator.hasNext()) {
                String name = stringIterator.next();
                this.files.add(name);
            }
            this.setSuccessful();
        }
        catch (IOException e) {
            this.error = e.getMessage();
        }
    }

    @Override
    public void prepareResponse(class_7225.class_7874 provider, class_2487 tag) {
        if (this.error != null) {
            tag.method_10582("error", this.error);
            return;
        }
        if (this.files != null) {
            class_2499 list = new class_2499();
            list.addAll(this.files.stream().map(class_2519::method_23256).toList());
            tag.method_10566("files", (class_2520)list);
        }
    }

    @Override
    public void processResponse(class_7225.class_7874 provider, class_2487 tag) {
    }
}

