/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.debug.DebugLog;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_7225;

public class TaskSetupFileBrowser
extends Task {
    private class_2338 pos;
    private boolean includeMain;
    private AbstractDrive mainDrive;
    private Map<UUID, AbstractDrive> availableDrives;

    public TaskSetupFileBrowser() {
    }

    public TaskSetupFileBrowser(class_2338 pos, boolean includeMain) {
        this();
        this.pos = pos;
        this.includeMain = includeMain;
    }

    @Override
    public void prepareRequest(class_7225.class_7874 provider, class_2487 tag) {
        tag.method_10544("pos", this.pos.method_10063());
        tag.method_10556("include_main", this.includeMain);
    }

    @Override
    public void processRequest(class_7225.class_7874 provider, class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092((long)tag.method_10537("pos"))).method_12201(class_2338.method_10092((long)tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity laptop = (ComputerBlockEntity)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            if (tag.method_10577("include_main")) {
                this.mainDrive = fileSystem.getMainDrive();
            }
            this.availableDrives = fileSystem.getAvailableDrives(level, false);
            this.setSuccessful();
        } else {
            UltreonDevices.LOGGER.warn("BlockEntity at pos " + String.valueOf(class_2338.method_10092((long)tag.method_10537("pos"))) + " is not a ComputerBlockEntity");
        }
    }

    @Override
    public void prepareResponse(class_7225.class_7874 provider, class_2487 tag) {
        if (this.isSuccessful()) {
            if (this.mainDrive != null) {
                class_2487 mainDriveTag = new class_2487();
                mainDriveTag.method_10582("name", this.mainDrive.getName());
                mainDriveTag.method_25927("uuid", this.mainDrive.getUuid());
                mainDriveTag.method_10582("type", this.mainDrive.getType().toString());
                tag.method_10566("main_drive", (class_2520)mainDriveTag);
            }
            class_2499 driveList = new class_2499();
            this.availableDrives.forEach((k, v) -> {
                DebugLog.log("k = " + String.valueOf(k));
                DebugLog.log("v.getUuid() = " + String.valueOf(v.getUuid()));
                class_2487 driveTag = new class_2487();
                driveTag.method_10582("name", v.getName());
                driveTag.method_25927("uuid", v.getUuid());
                driveTag.method_10582("type", v.getType().toString());
                driveList.add((Object)driveTag);
            });
            tag.method_10566("available_drives", (class_2520)driveList);
        }
    }

    @Override
    public void processResponse(class_7225.class_7874 provider, class_2487 tag) {
    }
}

