/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.laptop.common;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.core.laptop.client.ClientLaptop;
import dev.ultreon.devices.programs.system.object.ColorScheme;
import java.awt.Color;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TaskBar {
    public static final class_2960 APP_BAR_GUI = UltreonDevices.res("textures/gui/application_bar.png");
    public static final int BAR_HEIGHT = 18;
    private static final int APPS_DISPLAYED = UltreonDevices.DEVELOPER_MODE ? 18 : 10;
    private final ClientLaptop laptop;
    private final int offset = 0;
    private final int pingTimer = 0;
    private static final Marker MARKER = MarkerFactory.getMarker((String)"TaskBar");

    public TaskBar(ClientLaptop laptop) {
        this.laptop = laptop;
    }

    public void render(class_332 graphics, ClientLaptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)APP_BAR_GUI);
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.resetDefault();
        Color bgColor = new Color(colorScheme.getBackgroundColor());
        float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
        bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
        int trayItemsWidth = 0;
        graphics.method_25293(APP_BAR_GUI, x, y, 1, 18, 0.0f, 0.0f, 1, 18, 256, 256);
        graphics.method_25293(APP_BAR_GUI, x + 1, y, 328 - trayItemsWidth, 18, 1.0f, 0.0f, 1, 18, 256, 256);
        graphics.method_25293(APP_BAR_GUI, x + 364 - 35 - trayItemsWidth, y, 35 + trayItemsWidth, 18, 2.0f, 0.0f, 1, 18, 256, 256);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (mc.field_1687 == null || mc.field_1724 != null);
        graphics.method_51433(mc.field_1772, this.timeToString(mc.field_1687 != null ? mc.field_1687.method_8532() : 0L), x + 334, y + 5, Color.WHITE.getRGB(), true);
        int startX = x + 317;
        RenderSystem.setShaderTexture((int)0, (class_2960)APP_BAR_GUI);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void handleClick(ClientLaptop laptop, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16)) {
            UltreonDevices.LOGGER.debug(MARKER, "Clicked on task bar");
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public String timeToString(long time) {
        int hours = (int)((Math.floor((double)time / 1000.0) + 6.0) % 24.0);
        int minutes = (int)Math.floor((double)(time % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }

    public ClientLaptop getLaptop() {
        return this.laptop;
    }
}

