/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.init;

import com.google.common.collect.Lists;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.block.OfficeChairBlock;
import dev.ultreon.devices.block.PaperBlock;
import dev.ultreon.devices.block.PrinterBlock;
import dev.ultreon.devices.block.RouterBlock;
import dev.ultreon.devices.block.computer.LaptopBlock;
import dev.ultreon.devices.block.computer.MacMaxXBlock;
import dev.ultreon.devices.block.computer.MacMaxXBlockPart;
import dev.ultreon.devices.util.DyeableRegistration;
import dev.ultreon.mods.xinexlib.registrar.Registrar;
import dev.ultreon.mods.xinexlib.registrar.RegistrySupplier;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_7924;

public class DeviceBlocks {
    private static final Registrar<class_2248> REGISTER = UltreonDevices.REGISTRIES.get().getRegistrar(class_7924.field_41254);
    public static final DyeableRegistration<LaptopBlock, class_2248> LAPTOPS = new DyeableRegistration<LaptopBlock, class_2248>(){

        @Override
        public RegistrySupplier<LaptopBlock, class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_laptop", () -> new LaptopBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };
    public static final RegistrySupplier<MacMaxXBlock, class_2248> MAC_MAX_X = REGISTER.register("mac_max_x", MacMaxXBlock::new);
    public static final RegistrySupplier<MacMaxXBlockPart, class_2248> MAC_MAX_X_PART = REGISTER.register("mac_max_x_part", MacMaxXBlockPart::new);
    public static final DyeableRegistration<PrinterBlock, class_2248> PRINTERS = new DyeableRegistration<PrinterBlock, class_2248>(){

        @Override
        public RegistrySupplier<PrinterBlock, class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_printer", () -> new PrinterBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<RouterBlock, class_2248> ROUTERS = new DyeableRegistration<RouterBlock, class_2248>(){

        @Override
        public RegistrySupplier<RouterBlock, class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_router", () -> new RouterBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<OfficeChairBlock, class_2248> OFFICE_CHAIRS = new DyeableRegistration<OfficeChairBlock, class_2248>(){

        @Override
        public RegistrySupplier<OfficeChairBlock, class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_office_chair", () -> new OfficeChairBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };
    public static final RegistrySupplier<PaperBlock, class_2248> PAPER = REGISTER.register("paper", PaperBlock::new);

    public static void register() {
        REGISTER.load();
    }

    public static Stream<class_2248> getAllBlocks() {
        return Lists.newArrayList(REGISTER).stream().map(RegistrySupplier::get);
    }

    public static List<LaptopBlock> getAllLaptops() {
        return DeviceBlocks.getAllBlocks().filter(block -> block instanceof LaptopBlock).map(block -> (LaptopBlock)block).toList();
    }

    public static List<PrinterBlock> getAllPrinters() {
        return DeviceBlocks.getAllBlocks().filter(block -> block instanceof PrinterBlock).map(block -> (PrinterBlock)block).toList();
    }

    public static List<RouterBlock> getAllRouters() {
        return DeviceBlocks.getAllBlocks().filter(block -> block instanceof RouterBlock).map(block -> (RouterBlock)block).toList();
    }

    public static List<OfficeChairBlock> getAllOfficeChairs() {
        return DeviceBlocks.getAllBlocks().filter(block -> block instanceof OfficeChairBlock).map(block -> (OfficeChairBlock)block).toList();
    }
}

