/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.exception.WorldLessException;
import dev.ultreon.devices.object.Player;
import dev.ultreon.devices.object.tiles.Tile;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class Game
extends Component {
    public static final class_2960 ICONS = UltreonDevices.res("textures/gui/mine_racer.png");
    private static final Map<Integer, Tile> registeredTiles = new HashMap<Integer, Tile>();
    private final Player player;
    public int mapWidth;
    public int mapHeight;
    private Tile[][] tiles;
    private boolean editorMode = false;
    private Tile currentTile = Tile.grass;
    private Layer currentLayer = Layer.BACKGROUND;
    private boolean renderBackground = true;
    private final boolean renderMidgroundLow = true;
    private final boolean renderMidgroundHigh = true;
    private boolean renderForeground = true;
    private boolean renderPlayer = true;

    public Game(int left, int top, int mapWidth, int mapHeight) throws Exception {
        super(left, top);
        if (ComputerScreen.isWorldLess()) {
            throw new WorldLessException("The game can only exist if the universe exists.");
        }
        if (mapWidth % 8 != 0 || mapHeight % 6 != 0) {
            throw new Exception("Width and height need to be a multiple of 8");
        }
        this.player = new Player(this);
        this.mapWidth = mapWidth / 8;
        this.mapHeight = mapHeight / 6;
        this.tiles = new Tile[4][this.mapWidth * this.mapHeight];
    }

    public static void registerTile(int id, Tile tile) {
        registeredTiles.put(id, tile);
    }

    public static Map<Integer, Tile> getRegisteredtiles() {
        return registeredTiles;
    }

    public void setEditorMode(boolean editorMode) {
        this.editorMode = editorMode;
    }

    public boolean loadMap(int width, int height, int[][] data) {
        if (data.length != 4) {
            return false;
        }
        if (data[0].length != width * height) {
            return false;
        }
        this.mapWidth = width;
        this.mapHeight = height;
        this.tiles = new Tile[4][this.mapWidth * this.mapHeight];
        for (int layer = 0; layer < data.length; ++layer) {
            for (int tile = 0; tile < data[0].length; ++tile) {
                this.tiles[layer][tile] = registeredTiles.get(data[layer][tile]);
            }
        }
        return true;
    }

    @Override
    public void handleTick() {
        if (this.renderPlayer) {
            this.player.tick();
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int endY;
        int endX;
        int startY;
        int startX;
        if (this.editorMode && GuiHelper.isMouseInside(mouseX, mouseY, startX = this.xPosition, startY = this.yPosition, endX = startX + this.mapWidth * 8, endY = startY + this.mapHeight * 6)) {
            int pixelX = (mouseX - startX) / 8;
            int pixelY = (mouseY - startY) / 6;
            if (mouseButton == 0) {
                this.placeTile(pixelX, pixelY, this.currentTile);
            } else if (mouseButton == 1) {
                this.placeTile(pixelX, pixelY, null);
            }
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        int endY;
        int endX;
        int startY;
        int startX;
        if (this.editorMode && GuiHelper.isMouseInside(mouseX, mouseY, startX = this.xPosition, startY = this.yPosition, endX = startX + this.mapWidth * 8, endY = startY + this.mapHeight * 6)) {
            int pixelX = (mouseX - startX) / 8;
            int pixelY = (mouseY - startY) / 6;
            if (mouseButton == 0) {
                this.placeTile(pixelX, pixelY, this.currentTile);
            } else if (mouseButton == 1) {
                this.placeTile(pixelX, pixelY, null);
            }
        }
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        Tile tile;
        int i;
        if (this.editorMode) {
            graphics.method_25294(this.xPosition - 1, this.yPosition - 1, this.xPosition + this.mapWidth * 8 + 1, this.yPosition + this.mapHeight * 6 + 1, Color.DARK_GRAY.getRGB());
        }
        graphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
        if (this.renderBackground) {
            for (i = 0; i < this.tiles[0].length; ++i) {
                tile = this.tiles[0][i];
                if (tile == null) continue;
                tile.render(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.BACKGROUND);
            }
            for (i = 0; i < this.tiles[0].length; ++i) {
                tile = this.tiles[0][i];
                if (tile == null) continue;
                tile.renderForeground(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.BACKGROUND);
            }
        }
        for (i = 0; i < this.tiles[1].length; ++i) {
            tile = this.tiles[1][i];
            if (tile == null) continue;
            tile.render(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.MIDGROUND_LOW);
        }
        for (i = 0; i < this.tiles[1].length; ++i) {
            tile = this.tiles[1][i];
            if (tile == null) continue;
            tile.renderForeground(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.MIDGROUND_LOW);
        }
        if (this.renderPlayer) {
            this.player.render(graphics, this.xPosition, this.yPosition, partialTicks);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
        for (i = 0; i < this.tiles[2].length; ++i) {
            tile = this.tiles[2][i];
            if (tile == null) continue;
            tile.render(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.MIDGROUND_HIGH);
        }
        for (i = 0; i < this.tiles[2].length; ++i) {
            tile = this.tiles[2][i];
            if (tile == null) continue;
            tile.renderForeground(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.MIDGROUND_HIGH);
        }
        if (this.renderForeground) {
            for (i = 0; i < this.tiles[3].length; ++i) {
                tile = this.tiles[3][i];
                if (tile == null) continue;
                tile.render(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.FOREGROUND);
            }
            for (i = 0; i < this.tiles[3].length; ++i) {
                tile = this.tiles[3][i];
                if (tile == null) continue;
                tile.renderForeground(graphics, this, i % this.mapWidth, i / this.mapWidth, Layer.FOREGROUND);
            }
        }
        graphics.method_51448().method_22909();
    }

    public boolean placeTile(int x, int y, Tile tile) {
        int index = x + y * this.mapWidth;
        if (index >= 0 && index < this.mapWidth * this.mapHeight) {
            this.tiles[this.currentLayer.layer][index] = tile;
            return true;
        }
        return false;
    }

    public Tile getTile(Layer layer, int x, int y) {
        if (x < 0) {
            return null;
        }
        if (x >= this.mapWidth) {
            return null;
        }
        int index = x + y * this.mapWidth;
        if (index >= 0 && index < this.mapWidth * this.mapHeight) {
            return this.tiles[layer.layer][index];
        }
        return null;
    }

    public boolean isFullTile(Layer layer, int x, int y) {
        Tile tile;
        if (x < 0) {
            return true;
        }
        if (x >= this.mapWidth) {
            return true;
        }
        int index = x + y * this.mapWidth;
        if (index >= 0 && index < this.mapWidth * this.mapHeight && (tile = this.tiles[layer.layer][index]) != null) {
            return tile.isFullTile();
        }
        return true;
    }

    public Tile getCurrentTile() {
        return this.currentTile;
    }

    public void setCurrentTile(Tile currentTile) {
        this.currentTile = currentTile;
    }

    public Layer getCurrentLayer() {
        return this.currentLayer;
    }

    public void setCurrentLayer(Layer currentLayer) {
        this.currentLayer = currentLayer;
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public void setRenderForeground(boolean renderForeground) {
        this.renderForeground = renderForeground;
    }

    public void setRenderPlayer(boolean renderPlayer) {
        this.renderPlayer = renderPlayer;
    }

    public void nextLayer() {
        int next = this.currentLayer.layer + 1;
        if (next <= Layer.values().length - 1) {
            this.currentLayer = Layer.values()[next];
        }
    }

    public void prevLayer() {
        int prev = this.currentLayer.layer - 1;
        if (prev >= 0) {
            this.currentLayer = Layer.values()[prev];
        }
    }

    public void fill(Tile tile) {
        for (int i = 0; i < this.tiles[0].length; ++i) {
            this.tiles[0][i] = tile;
        }
    }

    public static enum Layer {
        BACKGROUND(0, 0.0),
        MIDGROUND_LOW(1, 0.0),
        MIDGROUND_HIGH(2, 20.0),
        FOREGROUND(3, 30.0);

        public int layer;
        public double zLevel;

        private Layer(int layer, double zLevel) {
            this.layer = layer;
            this.zLevel = zLevel;
        }

        public Layer up() {
            if (this.layer + 1 <= Layer.values().length - 1) {
                return Layer.values()[this.layer + 1];
            }
            return this;
        }

        public Layer down() {
            if (this.layer - 1 >= 0) {
                return Layer.values()[this.layer - 1];
            }
            return this;
        }
    }
}

