/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.CheckBox;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.exception.WorldLessException;
import dev.ultreon.devices.object.Game;
import dev.ultreon.devices.object.TileGrid;
import dev.ultreon.devices.object.tiles.Tile;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class BoatRacersApp
extends Application {
    private Layout layoutLevelEditor;
    private Game game;
    private TileGrid tileGrid;
    private Label labelLayer;
    private Button btnNextLayer;
    private Button btnPrevLayer;
    private CheckBox checkBoxForeground;
    private CheckBox checkBoxBackground;
    private CheckBox checkBoxPlayer;

    public BoatRacersApp() {
        this.setDefaultWidth(320);
        this.setDefaultHeight(160);
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutLevelEditor = new Layout(364, 178);
        try {
            this.game = new Game(4, 4, 256, 144);
            this.game.setEditorMode(true);
            this.game.setRenderPlayer(false);
            this.game.fill(Tile.grass);
            this.layoutLevelEditor.addComponent(this.game);
        }
        catch (WorldLessException e) {
            this.setCurrentLayout(new Layout(320, 160));
            Dialog.Message message = new Dialog.Message(e.getMessage()){

                @Override
                public void onClose() {
                    super.onClose();
                    BoatRacersApp.this.getWindow().close();
                }
            };
            message.setTitle("Error");
            this.openDialog(message);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tileGrid = new TileGrid(266, 3, this.game);
        this.layoutLevelEditor.addComponent(this.tileGrid);
        this.labelLayer = new Label("1", 280, 108);
        this.layoutLevelEditor.addComponent(this.labelLayer);
        this.btnNextLayer = new Button(266, 106, Icons.CHEVRON_RIGHT);
        this.btnNextLayer.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.game.nextLayer();
            this.labelLayer.setText(Integer.toString(this.game.getCurrentLayer().layer + 1));
        });
        this.layoutLevelEditor.addComponent(this.btnNextLayer);
        this.btnPrevLayer = new Button(314, 106, Icons.CHEVRON_LEFT);
        this.btnPrevLayer.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.game.prevLayer();
            this.labelLayer.setText(Integer.toString(this.game.getCurrentLayer().layer + 1));
        });
        this.layoutLevelEditor.addComponent(this.btnPrevLayer);
        this.checkBoxBackground = new CheckBox("Background", 3, 151);
        this.checkBoxBackground.setClickListener((mouseX, mouseY, mouseButton) -> this.game.setRenderBackground(this.checkBoxBackground.isSelected()));
        this.checkBoxBackground.setSelected(true);
        this.layoutLevelEditor.addComponent(this.checkBoxBackground);
        this.checkBoxForeground = new CheckBox("Foreground", 80, 151);
        this.checkBoxForeground.setClickListener((mouseX, mouseY, mouseButton) -> this.game.setRenderForeground(this.checkBoxForeground.isSelected()));
        this.checkBoxForeground.setSelected(true);
        this.layoutLevelEditor.addComponent(this.checkBoxForeground);
        this.checkBoxPlayer = new CheckBox("Player", 160, 151);
        this.checkBoxPlayer.setClickListener((mouseX, mouseY, mouseButton) -> this.game.setRenderPlayer(this.checkBoxPlayer.isSelected()));
        this.layoutLevelEditor.addComponent(this.checkBoxPlayer);
        this.setCurrentLayout(this.layoutLevelEditor);
    }

    @Override
    public void onTick() {
        if (ComputerScreen.isWorldLess()) {
            return;
        }
        super.onTick();
    }

    @Override
    public void load(class_2487 tagCompound) {
    }

    @Override
    public void save(class_2487 tagCompound) {
    }
}

