/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.ButtonToggle;
import dev.ultreon.devices.api.app.component.CheckBox;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.RadioGroup;
import dev.ultreon.devices.api.app.component.Slider;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.object.Canvas;
import dev.ultreon.devices.object.ColorGrid;
import dev.ultreon.devices.object.Picture;
import dev.ultreon.devices.programs.system.component.FileInfo;
import dev.ultreon.devices.programs.system.layout.StandardLayout;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class PixelPainterApp
extends Application {
    private static final class_2960 PIXEL_PAINTER_ICONS = class_2960.method_60654((String)"devices:textures/gui/pixel_painter.png");
    private static final Color ITEM_BACKGROUND = new Color(170, 176, 194);
    private static final Color ITEM_SELECTED = new Color(200, 176, 174);
    private static final Color AUTHOR_TEXT = new Color(114, 120, 138);
    private StandardLayout layoutMainMenu;
    private Label labelLogo;
    private Button btnNewPicture;
    private Button btnLoadPicture;
    private Layout layoutNewPicture;
    private Label labelName;
    private TextField fieldName;
    private Label labelAuthor;
    private TextField fieldAuthor;
    private Label labelSize;
    private CheckBox checkBox16x;
    private CheckBox checkBox32x;
    private Button btnCreatePicture;
    private Layout layoutLoadPicture;
    private ItemList<Picture> listPictures;
    private Button btnLoadSavedPicture;
    private Button btnBrowseSavedPicture;
    private Button btnDeleteSavedPicture;
    private Button btnBackSavedPicture;
    private Layout layoutDraw;
    private Canvas canvas;
    private ButtonToggle btnPencil;
    private ButtonToggle btnBucket;
    private ButtonToggle btnEraser;
    private ButtonToggle btnEyeDropper;
    private Button btnCancel;
    private Button btnSave;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private Component colorDisplay;
    private ColorGrid colorGrid;
    private CheckBox displayGrid;

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutMainMenu = new StandardLayout("Main Menu", 201, 125, this, null);
        this.layoutMainMenu.setIcon(Icons.HOME);
        ItemList<Picture> pictureList = new ItemList<Picture>(5, 43, 80, 4);
        pictureList.setListItemRenderer(new ListItemRenderer<Picture>(this, 18){

            @Override
            public void render(class_332 graphics, Picture picture, class_310 mc, int x, int y, int width, int height, boolean selected) {
                RenderUtil.drawStringClipped(graphics, "Henlo", x, y, 100, AUTHOR_TEXT.getRGB(), true);
            }
        });
        this.layoutMainMenu.addComponent(pictureList);
        this.btnNewPicture = new Button(5, 25, "New", Icons.PICTURE);
        this.btnNewPicture.setSize(40, 16);
        this.btnNewPicture.setToolTip("New Picture", "Start a new masterpiece!");
        this.btnNewPicture.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(this.layoutNewPicture);
            }
        });
        this.layoutMainMenu.addComponent(this.btnNewPicture);
        this.btnLoadPicture = new Button(48, 25, Icons.IMPORT);
        this.btnLoadPicture.setToolTip("Load External", "Open a picture from file");
        this.btnLoadPicture.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutLoadPicture));
        this.layoutMainMenu.addComponent(this.btnLoadPicture);
        Button btnDeletePicture = new Button(67, 25, Icons.TRASH);
        btnDeletePicture.setToolTip("Delete", "Removes the selected image");
        this.layoutMainMenu.addComponent(btnDeletePicture);
        this.layoutNewPicture = new Layout(180, 65);
        this.labelName = new Label("Name", 5, 5);
        this.layoutNewPicture.addComponent(this.labelName);
        this.fieldName = new TextField(5, 15, 100);
        this.layoutNewPicture.addComponent(this.fieldName);
        this.labelAuthor = new Label("Author", 5, 35);
        this.layoutNewPicture.addComponent(this.labelAuthor);
        this.fieldAuthor = new TextField(5, 45, 100);
        this.layoutNewPicture.addComponent(this.fieldAuthor);
        this.labelSize = new Label("Size", 110, 5);
        this.layoutNewPicture.addComponent(this.labelSize);
        RadioGroup sizeGroup = new RadioGroup();
        this.checkBox16x = new CheckBox("16x", 110, 17);
        this.checkBox16x.setSelected(true);
        this.checkBox16x.setRadioGroup(sizeGroup);
        this.layoutNewPicture.addComponent(this.checkBox16x);
        this.checkBox32x = new CheckBox("32x", 145, 17);
        this.checkBox32x.setRadioGroup(sizeGroup);
        this.layoutNewPicture.addComponent(this.checkBox32x);
        this.btnCreatePicture = new Button(110, 40, "Create");
        this.btnCreatePicture.setSize(65, 20);
        this.btnCreatePicture.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.setCurrentLayout(this.layoutDraw);
            this.canvas.createPicture(this.fieldName.getText(), this.fieldAuthor.getText(), this.checkBox16x.isSelected() ? Picture.Size.X16 : Picture.Size.X32);
        });
        this.layoutNewPicture.addComponent(this.btnCreatePicture);
        this.layoutLoadPicture = new Layout(165, 116);
        this.layoutLoadPicture.setInitListener(() -> {
            this.listPictures.setLoading(true);
            this.listPictures.removeAll();
            FileSystem.getApplicationFolder(this, response -> {
                if (response.success()) {
                    FileInfo data = (FileInfo)response.data();
                    data.list(response2 -> {
                        if (response2.success()) {
                            for (FileInfo fileInfo : (List)response2.data()) {
                                if (!fileInfo.getName().endsWith(".pic")) continue;
                                Picture picture = new Picture(fileInfo);
                                this.listPictures.addItem(picture);
                            }
                        } else {
                            this.openDialog(new Dialog.Message(response2.message()));
                        }
                    });
                }
            });
        });
        this.listPictures = new ItemList(5, 5, 80, 5);
        this.listPictures.setListItemRenderer(new ListItemRenderer<Picture>(this, 20){

            @Override
            public void render(class_332 graphics, Picture picture, class_310 mc, int x, int y, int width, int height, boolean selected) {
                graphics.method_25294(x, y, x + width, y + height, selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB());
                graphics.method_51433(mc.field_1772, picture.getName(), x + 2, y + 2, Color.WHITE.getRGB(), false);
                graphics.method_51433(mc.field_1772, picture.getAuthor(), x + 2, y + 11, AUTHOR_TEXT.getRGB(), false);
            }
        });
        this.listPictures.setItemClickListener((picture, index, mouseButton) -> {
            if (mouseButton == 0) {
                this.btnLoadSavedPicture.setEnabled(true);
                this.btnDeleteSavedPicture.setEnabled(true);
            }
        });
        this.layoutLoadPicture.addComponent(this.listPictures);
        this.btnLoadSavedPicture = new Button(110, 5, "Load");
        this.btnLoadSavedPicture.setSize(50, 20);
        this.btnLoadSavedPicture.setEnabled(false);
        this.btnLoadSavedPicture.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.listPictures.getSelectedIndex() != -1) {
                this.canvas.setPicture(Objects.requireNonNull(this.listPictures.getSelectedItem()));
                this.setCurrentLayout(this.layoutDraw);
            }
        });
        this.layoutLoadPicture.addComponent(this.btnLoadSavedPicture);
        this.btnBrowseSavedPicture = new Button(110, 30, "Browse");
        this.btnBrowseSavedPicture.setSize(50, 20);
        this.btnBrowseSavedPicture.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.OpenFile dialog = new Dialog.OpenFile(this);
            dialog.setResponseHandler((success, file) -> {
                if (file.getName().endsWith(".pic")) {
                    Picture picture = Picture.fromFile(file);
                    this.canvas.setPicture(picture);
                    this.setCurrentLayout(this.layoutDraw);
                    return true;
                }
                Dialog.Message dialog2 = new Dialog.Message("Invalid file for Pixel Painter");
                this.openDialog(dialog2);
                return false;
            });
            this.openDialog(dialog);
        });
        this.layoutLoadPicture.addComponent(this.btnBrowseSavedPicture);
        this.btnDeleteSavedPicture = new Button(110, 55, "Delete");
        this.btnDeleteSavedPicture.setSize(50, 20);
        this.btnDeleteSavedPicture.setEnabled(false);
        this.btnDeleteSavedPicture.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.listPictures.getSelectedIndex() != -1) {
                Picture picture = this.listPictures.getSelectedItem();
                assert (picture != null);
                FileInfo file = picture.getSource();
                if (file != null) {
                    file.delete(response -> {
                        if (response.success()) {
                            this.listPictures.removeItem(this.listPictures.getSelectedIndex());
                            this.btnDeleteSavedPicture.setEnabled(false);
                            this.btnLoadSavedPicture.setEnabled(false);
                        } else {
                            this.openDialog(new Dialog.Message(response.message()));
                        }
                    });
                } else {
                    this.openDialog(new Dialog.Message("The file/folder you are trying to delete does not exist."));
                }
            }
        });
        this.layoutLoadPicture.addComponent(this.btnDeleteSavedPicture);
        this.btnBackSavedPicture = new Button(110, 80, "Back");
        this.btnBackSavedPicture.setSize(50, 20);
        this.btnBackSavedPicture.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutMainMenu));
        this.layoutLoadPicture.addComponent(this.btnBackSavedPicture);
        this.layoutDraw = new Layout(213, 140);
        this.canvas = new Canvas(5, 5);
        this.layoutDraw.addComponent(this.canvas);
        RadioGroup toolGroup = new RadioGroup();
        this.btnPencil = new ButtonToggle(138, 5, PIXEL_PAINTER_ICONS, 0, 0, 10, 10);
        this.btnPencil.setClickListener((mouseX, mouseY, mouseButton) -> this.canvas.setCurrentTool(Canvas.PENCIL));
        this.btnPencil.setRadioGroup(toolGroup);
        this.layoutDraw.addComponent(this.btnPencil);
        this.btnBucket = new ButtonToggle(138, 24, PIXEL_PAINTER_ICONS, 10, 0, 10, 10);
        this.btnBucket.setClickListener((mouseX, mouseY, mouseButton) -> this.canvas.setCurrentTool(Canvas.BUCKET));
        this.btnBucket.setRadioGroup(toolGroup);
        this.layoutDraw.addComponent(this.btnBucket);
        this.btnEraser = new ButtonToggle(138, 43, PIXEL_PAINTER_ICONS, 20, 0, 10, 10);
        this.btnEraser.setClickListener((mouseX, mouseY, mouseButton) -> this.canvas.setCurrentTool(Canvas.ERASER));
        this.btnEraser.setRadioGroup(toolGroup);
        this.layoutDraw.addComponent(this.btnEraser);
        this.btnEyeDropper = new ButtonToggle(138, 62, PIXEL_PAINTER_ICONS, 30, 0, 10, 10);
        this.btnEyeDropper.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.canvas.setCurrentTool(Canvas.EYE_DROPPER);
            Color color = new Color(this.canvas.getCurrentColor());
            this.redSlider.setPercentage((float)color.getRed() / 255.0f);
            this.greenSlider.setPercentage((float)color.getGreen() / 255.0f);
            this.blueSlider.setPercentage((float)color.getBlue() / 255.0f);
        });
        this.btnEyeDropper.setRadioGroup(toolGroup);
        this.layoutDraw.addComponent(this.btnEyeDropper);
        Button button = new Button(138, 81, Icons.PRINTER);
        button.setClickListener((mouseX, mouseY, mouseButton) -> {
            DebugLog.log("Print action triggered in pixel painter");
            if (mouseButton == 0) {
                Dialog.Print dialog = new Dialog.Print(new PicturePrint(this.canvas.picture.getName(), this.canvas.getPixels(), this.canvas.picture.getWidth()));
                this.openDialog(dialog);
            }
        });
        this.layoutDraw.addComponent(button);
        this.btnCancel = new Button(138, 100, PIXEL_PAINTER_ICONS, 50, 0, 10, 10);
        this.btnCancel.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.canvas.isExistingImage()) {
                this.setCurrentLayout(this.layoutLoadPicture);
            } else {
                this.setCurrentLayout(this.layoutMainMenu);
            }
            this.canvas.clear();
        });
        this.layoutDraw.addComponent(this.btnCancel);
        this.btnSave = new Button(138, 119, PIXEL_PAINTER_ICONS, 40, 0, 10, 10);
        this.btnSave.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.canvas.picture.pixels = this.canvas.copyPixels();
            if (this.canvas.isExistingImage()) {
                FileInfo file = this.canvas.picture.getSource();
                if (file != null) {
                    this.canvas.picture.writeToFile(file, result -> {
                        if (result.success()) {
                            this.openDialog(new Dialog.Message("File saved successfully"));
                        } else {
                            this.openDialog(new Dialog.Message(result.message()));
                        }
                    });
                }
            } else {
                this.saveFile();
            }
        });
        this.layoutDraw.addComponent(this.btnSave);
        this.redSlider = new Slider(158, 30, 50);
        this.redSlider.setSlideListener(percentage -> this.canvas.setRed(percentage));
        this.layoutDraw.addComponent(this.redSlider);
        this.greenSlider = new Slider(158, 46, 50);
        this.greenSlider.setSlideListener(percentage -> this.canvas.setGreen(percentage));
        this.layoutDraw.addComponent(this.greenSlider);
        this.blueSlider = new Slider(158, 62, 50);
        this.blueSlider.setSlideListener(percentage -> this.canvas.setBlue(percentage));
        this.layoutDraw.addComponent(this.blueSlider);
        this.colorDisplay = new Component(158, 5){

            @Override
            public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
                graphics.method_25294(this.xPosition, this.yPosition, this.xPosition + 50, this.yPosition + 20, Color.DARK_GRAY.getRGB());
                graphics.method_25294(this.xPosition + 1, this.yPosition + 1, this.xPosition + 49, this.yPosition + 19, PixelPainterApp.this.canvas.getCurrentColor());
            }
        };
        this.layoutDraw.addComponent(this.colorDisplay);
        this.colorGrid = new ColorGrid(157, 82, 50, this.canvas, this.redSlider, this.greenSlider, this.blueSlider);
        this.layoutDraw.addComponent(this.colorGrid);
        this.displayGrid = new CheckBox("Grid", 166, 120);
        this.displayGrid.setClickListener((mouseX, mouseY, mouseButton) -> this.canvas.setShowGrid(this.displayGrid.isSelected()));
        this.layoutDraw.addComponent(this.displayGrid);
        this.setCurrentLayout(this.layoutMainMenu);
    }

    private void saveFile() {
        Dialog.SaveFile dialog = new Dialog.SaveFile(this);
        dialog.setResponseHandler((success, file) -> {
            if (success) {
                this.canvas.picture.writeToFile((FileInfo)file, response -> {
                    if (response.success()) {
                        this.canvas.clear();
                        this.setCurrentLayout(this.layoutLoadPicture);
                        return;
                    }
                    this.openDialog(new Dialog.Message(response.message()));
                });
            } else {
                this.openDialog(new Dialog.Message("File could not be saved"));
            }
            return true;
        });
        this.openDialog(dialog);
    }

    @Override
    public void load(class_2487 tagCompound) {
    }

    @Override
    public void save(class_2487 tagCompound) {
    }

    @Override
    public void onClose() {
        super.onClose();
        this.listPictures.removeAll();
    }

    public static class PicturePrint
    implements IPrint {
        private String name;
        private int[] pixels;
        private int resolution;
        private boolean cut;

        public PicturePrint() {
        }

        public PicturePrint(String name, int[] pixels, int resolution) {
            this.name = name;
            this.setPicture(pixels);
        }

        private void setPicture(int[] pixels) {
            int resolution = (int)Math.sqrt(pixels.length);
            Picture.Size size = Picture.Size.getFromSize(resolution);
            if (size == null) {
                throw new IllegalArgumentException("Invalid pixels");
            }
            this.resolution = resolution;
            this.pixels = pixels;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int speed() {
            return this.resolution;
        }

        @Override
        public boolean requiresColor() {
            for (int pixel : this.pixels) {
                int r = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                int b = pixel & 0xFF;
                if (r == g && r == b) continue;
                return true;
            }
            return false;
        }

        @Override
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("name", this.name);
            tag.method_10539("pixels", this.pixels);
            tag.method_10569("resolution", this.resolution);
            if (this.cut) {
                tag.method_10556("cut", true);
            }
            return tag;
        }

        @Override
        public void fromTag(class_2487 tag) {
            this.name = tag.method_10558("name");
            this.cut = tag.method_10577("cut");
            this.setPicture(tag.method_10561("pixels"));
        }

        @Override
        public Class<? extends IPrint.Renderer> getRenderer() {
            return PictureRenderer.class;
        }
    }

    public static class PictureRenderer
    implements IPrint.Renderer {
        public static final class_2960 TEXTURE = class_2960.method_60655((String)"devices", (String)"textures/model/paper.png");

        @Override
        public boolean render(class_4587 pose, class_2487 data) {
            if (data.method_10573("pixels", 11) && data.method_10573("resolution", 3)) {
                int[] pixels = data.method_10561("pixels");
                int resolution = data.method_10550("resolution");
                boolean cut = data.method_10577("cut");
                if (pixels.length != resolution * resolution) {
                    return false;
                }
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                pose.method_22907(new Quaternionf(0.0f, 1.0f, 0.0f, 180.0f));
                if (!cut) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                    RenderUtil.drawRectWithTexture(TEXTURE, pose, -1.0, 0.0, 0.0f, 0.0f, 1, 1, (float)resolution, (float)resolution, resolution, resolution);
                }
                class_1011 image = new class_1011(resolution, resolution, false);
                for (int i = 0; i < resolution; ++i) {
                    for (int j = 0; j < resolution; ++j) {
                        image.method_4305(resolution - i - 1, resolution - j - 1, pixels[i + j * resolution]);
                    }
                }
                int textureId = TextureUtil.generateTextureId();
                TextureUtil.prepareImage((int)textureId, (int)resolution, (int)resolution);
                RenderSystem.setShaderTexture((int)0, (int)textureId);
                RenderUtil.drawRectWithTexture(null, pose, -1.0, 0.0, 0.0f, 0.0f, 1, 1, (float)resolution, (float)resolution, resolution, resolution);
                RenderSystem.deleteTexture((int)textureId);
                RenderSystem.disableBlend();
                return true;
            }
            return false;
        }
    }
}

