/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction;

import dev.ultreon.devices.programs.auction.object.AuctionItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class AuctionManager {
    public static final AuctionManager INSTANCE = new AuctionManager();
    private final List<AuctionItem> items = new ArrayList<AuctionItem>();

    private AuctionManager() {
    }

    public void addItem(AuctionItem item) {
        if (!this.containsItem(item.getId())) {
            this.items.add(item);
        }
    }

    public boolean containsItem(UUID id) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public AuctionItem getItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            return item;
        }
        return null;
    }

    public void removeItem(UUID uuid) {
        for (AuctionItem item : this.items) {
            if (!item.getId().equals(uuid)) continue;
            this.items.remove(item);
            return;
        }
    }

    public List<AuctionItem> getItems() {
        return this.items;
    }

    public void tick() {
        for (AuctionItem item : this.items) {
            item.decrementTime();
        }
    }

    public void writeToNBT(class_7225.class_7874 provider, class_2487 tag) {
        class_2499 tagList = new class_2499();
        this.items.stream().filter(AuctionItem::isValid).forEach(i -> {
            class_2487 itemTag = new class_2487();
            i.writeToNBT(itemTag, provider);
            tagList.add((Object)itemTag);
        });
        tag.method_10566("auctionItems", (class_2520)tagList);
    }

    public void readFromNBT(class_7225.class_7874 provider, class_2487 tag) {
        this.items.clear();
        class_2499 tagList = (class_2499)tag.method_10580("auctionItems");
        if (tagList != null) {
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 itemTag = tagList.method_10602(i);
                AuctionItem item = AuctionItem.readFromNBT(provider, itemTag);
                this.items.add(item);
            }
        }
    }

    public List<AuctionItem> getItemsForSeller(UUID seller) {
        return this.items.stream().filter(i -> i.getSellerId().equals(seller)).collect(Collectors.toList());
    }
}

