/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Inventory;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.NumberSelector;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.BankUtil;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.programs.auction.AuctionManager;
import dev.ultreon.devices.programs.auction.object.AuctionItem;
import dev.ultreon.devices.programs.auction.task.TaskAddAuction;
import dev.ultreon.devices.programs.auction.task.TaskBuyItem;
import dev.ultreon.devices.programs.auction.task.TaskGetAuctions;
import dev.ultreon.devices.programs.system.layout.StandardLayout;
import dev.ultreon.devices.util.TimeUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class MineBayApp
extends Application {
    private static final class_2960 CHEST_GUI_TEXTURE = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    private static final class_2960 MINEBAY_ASSETS = UltreonDevices.res("textures/gui/minebay.png");
    private static final class_1799 EMERALD = new class_1799((class_1935)class_1802.field_8687);
    private final String[] categories = new String[]{"Building", "Combat", "Tools", "Food", "Materials", "Redstone", "Alchemy", "Rare", "Misc"};
    private Layout layoutMyAuctions;
    private ItemList<AuctionItem> items;
    private Layout layoutSelectItem;
    private Inventory inventory;
    private Button buttonAddCancel;
    private Button buttonAddNext;
    private Layout layoutAmountAndPrice;
    private Label labelAmount;
    private NumberSelector selectorAmount;
    private Label labelPrice;
    private NumberSelector selectorPrice;
    private Button buttonAmountAndPriceBack;
    private Button buttonAmountAndPriceCancel;
    private Button buttonAmountAndPriceNext;
    private Layout layoutDuration;
    private Label labelHours;
    private Label labelMinutes;
    private Label labelSeconds;
    private NumberSelector selectorHours;
    private NumberSelector selectorMinutes;
    private NumberSelector selectorSeconds;
    private Button buttonDurationBack;
    private Button buttonDurationCancel;
    private Button buttonDurationAdd;

    private static void renderItemSelBackground(class_332 graphics, class_310 mc, int x, int y, int width, int height, int mouseX, int mouseY, boolean windowActive) {
        graphics.method_25294(x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
        graphics.method_25294(x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
        graphics.method_25303(mc.field_1772, "Select an Item...", x + 5, y + 7, Color.WHITE.getRGB());
    }

    @Override
    public void onTick() {
        super.onTick();
        AuctionManager.INSTANCE.tick();
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        StandardLayout layoutMain = new StandardLayout(String.valueOf(class_124.field_1067) + "Icons", 330, 153, this, null);
        this.setCurrentLayout(layoutMain);
        this.getCurrentLayout().setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            graphics.method_25294(x, y, x + width, y + 25, Color.GRAY.getRGB());
            graphics.method_25294(x, y + 24, x + width, y + 25, Color.DARK_GRAY.getRGB());
            graphics.method_25294(x, y + 25, x + 95, y + height, Color.LIGHT_GRAY.getRGB());
            graphics.method_25294(x + 94, y + 25, x + 95, y + height, Color.GRAY.getRGB());
            RenderSystem.setShaderTexture((int)0, (class_2960)MINEBAY_ASSETS);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawRectWithTexture(MINEBAY_ASSETS, graphics, x + 5, y + 6, 0.0f, 0.0f, 61, 11, 61.0f, 12.0f);
        });
        Button btnAddItem = new Button(70, 5, "Add Item");
        btnAddItem.setSize(60, 15);
        btnAddItem.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        layoutMain.addComponent(btnAddItem);
        Button btnViewItem = new Button(135, 5, "Your Auctions");
        btnViewItem.setSize(80, 15);
        btnViewItem.setClickListener(this::onYourActionsClick);
        layoutMain.addComponent(btnViewItem);
        Label labelBalance = new Label("Balance", 295, 3);
        labelBalance.setAlignment(1);
        layoutMain.addComponent(labelBalance);
        Label labelMoney = new Label("$0", 295, 13);
        labelMoney.setAlignment(1);
        labelMoney.setScale(1.0);
        labelMoney.setShadow(false);
        layoutMain.addComponent(labelMoney);
        Label labelCategories = new Label("Categories", 5, 29);
        labelCategories.setShadow(false);
        layoutMain.addComponent(labelCategories);
        ItemList<String> categories = new ItemList<String>(5, 40, 70, 7);
        for (String category : this.categories) {
            categories.addItem(category);
        }
        layoutMain.addComponent(categories);
        Label labelItems = new Label("Items", 100, 29);
        labelItems.setShadow(false);
        layoutMain.addComponent(labelItems);
        this.items = new ItemList(100, 40, 180, 4);
        this.items.setListItemRenderer(new ListItemRenderer<AuctionItem>(this, 20){

            @Override
            public void render(class_332 graphics, AuctionItem e, class_310 mc, int x, int y, int width, int height, boolean selected) {
                if (selected) {
                    graphics.method_25294(x, y, x + width, y + height, Color.DARK_GRAY.getRGB());
                } else {
                    graphics.method_25294(x, y, x + width, y + height, Color.GRAY.getRGB());
                }
                RenderUtil.renderItem(graphics, x + 2, y + 2, e.getStack(), true);
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)(x + 24), (float)(y + 4), 0.0f);
                graphics.method_51448().method_22905(0.666f, 0.666f, 0.0f);
                graphics.method_51439(mc.field_1772, e.getStack().method_7954(), 0, 0, Color.WHITE.getRGB(), false);
                graphics.method_51433(mc.field_1772, TimeUtil.getTotalRealTime(e.getTimeLeft()), 0, 11, Color.LIGHT_GRAY.getRGB(), false);
                graphics.method_51448().method_22909();
                String price = "$" + e.getPrice();
                graphics.method_51433(mc.field_1772, price, x - mc.field_1772.method_1727(price) + width - 5, y + 6, Color.YELLOW.getRGB(), false);
            }
        });
        layoutMain.addComponent(this.items);
        Button btnBuy = new Button(100, 127, "Buy");
        btnBuy.setSize(50, 15);
        btnBuy.setClickListener(this::onBuyClick);
        layoutMain.addComponent(btnBuy);
        this.layoutSelectItem = new Layout(172, 87);
        this.layoutSelectItem.setTitle("Add Item");
        this.layoutSelectItem.setBackground(MineBayApp::renderItemSelBackground);
        this.inventory = new Inventory(5, 28);
        this.inventory.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.inventory.getSelectedSlotIndex() != -1) {
                assert (class_310.method_1551().field_1724 != null);
                class_1799 stack = class_310.method_1551().field_1724.method_31548().method_5438(this.inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    this.buttonAddNext.setEnabled(true);
                    this.selectorAmount.setMax(stack.method_7947());
                    this.selectorAmount.setNumber(stack.method_7947());
                } else {
                    this.buttonAddNext.setEnabled(false);
                }
            }
        });
        this.layoutSelectItem.addComponent(this.inventory);
        this.buttonAddCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonAddCancel.setToolTip("Cancel", "Go back to main page");
        this.buttonAddCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutSelectItem.addComponent(this.buttonAddCancel);
        this.buttonAddNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        this.buttonAddNext.setToolTip("Next Page", "Set price and amount");
        this.buttonAddNext.setEnabled(false);
        this.buttonAddNext.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.selectorAmount.updateButtons();
            this.selectorPrice.updateButtons();
            this.setCurrentLayout(this.layoutAmountAndPrice);
        });
        this.layoutSelectItem.addComponent(this.buttonAddNext);
        this.layoutAmountAndPrice = new Layout(172, 87);
        this.layoutAmountAndPrice.setTitle("Add Item");
        this.layoutAmountAndPrice.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            graphics.method_25294(x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
            graphics.method_25294(x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
            graphics.method_25303(mc.field_1772, "Set amount and price...", x + 5, y + 7, Color.WHITE.getRGB());
            int offsetX = 14;
            int offsetY = 40;
            graphics.method_25294(x + offsetX, y + offsetY, x + offsetX + 38, y + offsetY + 38, Color.BLACK.getRGB());
            graphics.method_25294(x + offsetX + 1, y + offsetY + 1, x + offsetX + 37, y + offsetY + 37, Color.DARK_GRAY.getRGB());
            offsetX = 90;
            graphics.method_25294(x + offsetX, y + offsetY, x + offsetX + 38, y + offsetY + 38, Color.BLACK.getRGB());
            graphics.method_25294(x + offsetX + 1, y + offsetY + 1, x + offsetX + 37, y + offsetY + 37, Color.DARK_GRAY.getRGB());
            if (this.inventory.getSelectedSlotIndex() != -1) {
                assert (mc.field_1724 != null);
                class_1799 stack = mc.field_1724.method_31548().method_5438(this.inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416((float)(x + 17), (float)(y + 43), 0.0f);
                    graphics.method_51448().method_22905(2.0f, 2.0f, 0.0f);
                    RenderUtil.renderItem(graphics, 0, 0, stack, false);
                    graphics.method_51448().method_22909();
                }
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(x + 92), (float)(y + 43), 0.0f);
            graphics.method_51448().method_22905(2.0f, 2.0f, 0.0f);
            RenderUtil.renderItem(graphics, 0, 0, EMERALD, false);
            graphics.method_51448().method_22909();
        });
        this.buttonAmountAndPriceBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        this.buttonAmountAndPriceBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutSelectItem));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceBack);
        this.buttonAmountAndPriceCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonAmountAndPriceCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.restoreDefaultLayout());
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceCancel);
        this.buttonAmountAndPriceNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        this.buttonAmountAndPriceNext.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutDuration));
        this.layoutAmountAndPrice.addComponent(this.buttonAmountAndPriceNext);
        this.labelAmount = new Label("Amount", 16, 30);
        this.layoutAmountAndPrice.addComponent(this.labelAmount);
        this.selectorAmount = new NumberSelector(55, 42, 18);
        this.selectorAmount.setMax(64);
        this.layoutAmountAndPrice.addComponent(this.selectorAmount);
        this.labelPrice = new Label("Price", 96, 30);
        this.layoutAmountAndPrice.addComponent(this.labelPrice);
        this.selectorPrice = new NumberSelector(131, 42, 24);
        this.selectorPrice.setMax(999);
        this.layoutAmountAndPrice.addComponent(this.selectorPrice);
        this.layoutDuration = new Layout(172, 87);
        this.layoutDuration.setTitle("Add Item");
        this.layoutDuration.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            graphics.method_25294(x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
            graphics.method_25294(x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
            graphics.method_25303(mc.field_1772, "Set duration...", x + 5, y + 7, Color.WHITE.getRGB());
        });
        this.buttonDurationBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        this.buttonDurationBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutAmountAndPrice));
        this.layoutDuration.addComponent(this.buttonDurationBack);
        this.buttonDurationCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        this.buttonDurationCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(layoutMain));
        this.layoutDuration.addComponent(this.buttonDurationCancel);
        this.buttonDurationAdd = new Button(154, 4, MINEBAY_ASSETS, 24, 12, 8, 8);
        this.buttonDurationAdd.setClickListener((mouseX, mouseY, mouseButton) -> {
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setMessageText("Are you sure you want to auction this item?");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                int ticks = (int)TimeUtil.getRealTimeToTicks(this.selectorHours.getNumber(), this.selectorMinutes.getNumber(), this.selectorSeconds.getNumber());
                TaskAddAuction task = new TaskAddAuction(this.inventory.getSelectedSlotIndex(), this.selectorAmount.getNumber(), this.selectorPrice.getNumber(), ticks);
                task.setCallback((nbt, success) -> {
                    if (success) {
                        List<AuctionItem> auctionItems = AuctionManager.INSTANCE.getItems();
                        this.items.addItem(auctionItems.getLast());
                    }
                });
                TaskManager.sendTask(task);
                dialog.close();
                this.init(intent);
            });
            this.openDialog(dialog);
        });
        this.layoutDuration.addComponent(this.buttonDurationAdd);
        this.labelHours = new Label("Hrs", 45, 30);
        this.layoutDuration.addComponent(this.labelHours);
        this.labelMinutes = new Label("Mins", 76, 30);
        this.layoutDuration.addComponent(this.labelMinutes);
        this.labelSeconds = new Label("Secs", 105, 30);
        this.layoutDuration.addComponent(this.labelSeconds);
        DecimalFormat format = new DecimalFormat("00");
        this.selectorHours = new NumberSelector(45, 42, 20);
        this.selectorHours.setMax(23);
        this.selectorHours.setMin(0);
        this.selectorHours.setFormat(format);
        this.layoutDuration.addComponent(this.selectorHours);
        this.selectorMinutes = new NumberSelector(76, 42, 20);
        this.selectorMinutes.setMax(59);
        this.selectorMinutes.setMin(0);
        this.selectorMinutes.setFormat(format);
        this.layoutDuration.addComponent(this.selectorMinutes);
        this.selectorSeconds = new NumberSelector(107, 42, 20);
        this.selectorSeconds.setMax(59);
        this.selectorSeconds.setMin(1);
        this.selectorSeconds.setFormat(format);
        this.layoutDuration.addComponent(this.selectorSeconds);
        BankUtil.getBalance((nbt, success) -> {
            if (success) {
                labelMoney.setText("$" + Objects.requireNonNull(nbt, "Expected to get a tag from the get-balance task response.").method_10550("balance"));
            }
        });
        TaskGetAuctions task = new TaskGetAuctions();
        task.setCallback((nbt, success) -> {
            this.items.removeAll();
            for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                this.items.addItem(item);
            }
        });
        TaskManager.sendTask(task);
    }

    @Override
    public void load(class_2487 tagCompound) {
    }

    @Override
    public void save(class_2487 tagCompound) {
    }

    private void onYourActionsClick(int mouseX, int mouseY, int mouseButton) {
        assert (class_310.method_1551().field_1724 != null);
        TaskGetAuctions task = new TaskGetAuctions(class_310.method_1551().field_1724.method_5667());
        task.setCallback((nbt, success) -> {
            this.items.removeAll();
            for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                this.items.addItem(item);
            }
        });
        TaskManager.sendTask(task);
    }

    private void onBuyClick(int mouseX, int mouseY, int mouseButton) {
        Dialog.Confirmation dialog = new Dialog.Confirmation();
        dialog.setPositiveText("Buy");
        dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
            int index = this.items.getSelectedIndex();
            if (index == -1) {
                return;
            }
            AuctionItem item = this.items.getItem(index);
            if (item != null) {
                TaskBuyItem task = new TaskBuyItem(item.getId());
                task.setCallback((nbt, success) -> {
                    if (success) {
                        this.items.removeItem(index);
                    }
                });
                TaskManager.sendTask(task);
            }
        });
        dialog.setNegativeText("Cancel");
        dialog.setNegativeListener((mouseX1, mouseY1, mouseButton1) -> dialog.close());
        this.openDialog(dialog);
    }
}

