/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.auction.object;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class AuctionItem {
    private final UUID id;
    private final class_1799 stack;
    private final int price;
    private long timeLeft;
    private final UUID sellerId;

    public AuctionItem(class_1799 stack, int price, long timeLeft, UUID sellerId) {
        this.id = UUID.randomUUID();
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public AuctionItem(UUID id, class_1799 stack, int price, long timeLeft, UUID sellerId) {
        this.id = id;
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public static AuctionItem readFromNBT(class_7225.class_7874 provider, class_2487 tag) {
        UUID id = UUID.fromString(tag.method_10558("id"));
        class_2487 item = tag.method_10562("item");
        class_1799 stack = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)item);
        int price = tag.method_10550("price");
        long timeLeft = tag.method_10537("time");
        UUID sellerId = UUID.fromString(tag.method_10558("seller"));
        return new AuctionItem(id, stack, price, timeLeft, sellerId);
    }

    public UUID getId() {
        return this.id;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public int getPrice() {
        return this.price;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public boolean isValid() {
        return this.timeLeft > 0L;
    }

    public void decrementTime() {
        if (this.timeLeft > 0L) {
            --this.timeLeft;
        }
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setSold() {
        this.timeLeft = 0L;
    }

    public void writeToNBT(class_2487 tag, class_7225.class_7874 access) {
        tag.method_10582("id", this.id.toString());
        class_2487 item = new class_2487();
        item = this.stack.method_57376(access, (class_2520)item);
        tag.method_10566("item", (class_2520)item);
        tag.method_10569("price", this.price);
        tag.method_10544("time", this.timeLeft);
        tag.method_10582("seller", this.sellerId.toString());
    }

    public String toString() {
        return "{ " + String.valueOf(this.id) + ", " + String.valueOf(this.stack) + ", " + this.price + ", " + this.timeLeft + ", " + String.valueOf(this.sellerId) + " }";
    }
}

