/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.debug;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.ButtonToggle;
import dev.ultreon.devices.api.app.component.TextArea;
import dev.ultreon.devices.api.app.interfaces.IHighlight;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class TextAreaApp
extends Application {
    public static final IHighlight JAVA_HIGHLIGHT = text -> {
        if (text.startsWith("@")) {
            return TextAreaApp.asArray(class_124.field_1054);
        }
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return TextAreaApp.asArray(class_124.field_1075);
        }
        return switch (text) {
            case "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void.json", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "record", "sealed" -> TextAreaApp.asArray(class_124.field_1078);
            default -> TextAreaApp.asArray(class_124.field_1068);
        };
    };

    @SafeVarargs
    private static <T> T[] asArray(T ... t) {
        return t;
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        Layout layout = new Layout(250, 150);
        TextArea textArea = new TextArea(5, 25, 240, 120);
        textArea.setScrollBarSize(5);
        layout.addComponent(textArea);
        ButtonToggle buttonWordWrap = new ButtonToggle(5, 5, Icons.ALIGN_JUSTIFY);
        buttonWordWrap.setToolTip("Word Wrap", "Break the lines to fit in the view");
        buttonWordWrap.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                textArea.setWrapText(!buttonWordWrap.isSelected());
            }
        });
        layout.addComponent(buttonWordWrap);
        ButtonToggle buttonDebug = new ButtonToggle(24, 5, Icons.HELP);
        buttonDebug.setToolTip("Debug Mode", "Show invisible characters");
        buttonDebug.setClickListener((mouseX, mouseY, mouseButton) -> {});
        layout.addComponent(buttonDebug);
        ButtonToggle buttonHighlight = new ButtonToggle(43, 5, Icons.FONT);
        buttonHighlight.setToolTip("Highlight", "Set text highlighting to Java");
        buttonHighlight.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (!buttonHighlight.isSelected()) {
                    textArea.setHighlight(JAVA_HIGHLIGHT);
                } else {
                    textArea.setHighlight(null);
                }
            }
        });
        layout.addComponent(buttonHighlight);
        this.setCurrentLayout(layout);
    }

    @Override
    public void load(class_2487 tagCompound) {
    }

    @Override
    public void save(class_2487 tagCompound) {
    }
}

