/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.email;

import com.google.common.collect.HashBiMap;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Notification;
import dev.ultreon.devices.programs.email.object.Email;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EmailManager
implements WorldSavedData {
    public static final EmailManager INSTANCE = new EmailManager();
    private final HashBiMap<UUID, String> uuidToName = HashBiMap.create();
    private final Map<String, List<Email>> nameToInbox = new HashMap<String, List<Email>>();
    private List<Email> inbox;

    public boolean addEmailToInbox(Email email, String to) {
        if (this.nameToInbox.containsKey(to)) {
            this.nameToInbox.get(to).add(0, email);
            this.sendNotification(to, email);
            return true;
        }
        return false;
    }

    public List<Email> getInbox() {
        if (this.inbox == null) {
            this.inbox = new ArrayList<Email>();
        }
        return this.inbox;
    }

    public List<Email> getEmailsForAccount(class_1657 player) {
        if (this.uuidToName.containsKey((Object)player.method_5667())) {
            return this.nameToInbox.get(this.uuidToName.get((Object)player.method_5667()));
        }
        return new ArrayList<Email>();
    }

    public boolean addAccount(class_1657 player, String name) {
        if (!this.uuidToName.containsKey((Object)player.method_5667()) && !this.uuidToName.containsValue((Object)name)) {
            this.uuidToName.put((Object)player.method_5667(), (Object)name);
            this.nameToInbox.put(name, new ArrayList());
            return true;
        }
        return false;
    }

    public boolean hasAccount(UUID uuid) {
        return this.uuidToName.containsKey((Object)uuid);
    }

    public String getName(class_1657 player) {
        return (String)this.uuidToName.get((Object)player.method_5667());
    }

    @Override
    public void load(class_2487 nbt) {
        this.nameToInbox.clear();
        class_2499 inboxes = (class_2499)nbt.method_10580("Inboxes");
        for (int i = 0; i < inboxes.size(); ++i) {
            class_2487 inbox = inboxes.method_10602(i);
            String name = inbox.method_10558("Name");
            ArrayList<Email> emails = new ArrayList<Email>();
            class_2499 emailTagList = (class_2499)inbox.method_10580("Emails");
            for (int j = 0; j < emailTagList.size(); ++j) {
                class_2487 emailTag = emailTagList.method_10602(j);
                Email email = Email.readFromNBT(emailTag);
                emails.add(email);
            }
            this.nameToInbox.put(name, emails);
        }
        this.uuidToName.clear();
        class_2499 accounts = (class_2499)nbt.method_10580("Accounts");
        for (int i = 0; i < accounts.size(); ++i) {
            class_2487 account = accounts.method_10602(i);
            UUID uuid = UUID.fromString(account.method_10558("UUID"));
            String name = account.method_10558("Name");
            this.uuidToName.put((Object)uuid, (Object)name);
        }
    }

    @Override
    public void save(class_2487 nbt) {
        class_2499 inboxes = new class_2499();
        for (String key : this.nameToInbox.keySet()) {
            class_2487 inbox = new class_2487();
            inbox.method_10582("Name", key);
            class_2499 emailTagList = new class_2499();
            List<Email> emails = this.nameToInbox.get(key);
            for (Email email : emails) {
                class_2487 emailTag = new class_2487();
                email.save(emailTag);
                emailTagList.add((Object)emailTag);
            }
            inbox.method_10566("Emails", (class_2520)emailTagList);
            inboxes.add((Object)inbox);
        }
        nbt.method_10566("Inboxes", (class_2520)inboxes);
        class_2499 accounts = new class_2499();
        for (UUID key : this.uuidToName.keySet()) {
            class_2487 account = new class_2487();
            account.method_10582("UUID", key.toString());
            account.method_10582("Name", Objects.requireNonNull((String)this.uuidToName.get((Object)key)));
            accounts.add((Object)account);
        }
        nbt.method_10566("Accounts", (class_2520)accounts);
    }

    public void clear() {
        this.nameToInbox.clear();
        this.uuidToName.clear();
        this.inbox.clear();
    }

    private void sendNotification(String name, Email email) {
        class_3222 player;
        MinecraftServer server = UltreonDevices.getServer();
        UUID id = (UUID)this.uuidToName.inverse().get((Object)name);
        if (id != null && (player = server.method_3760().method_14602(id)) != null) {
            Notification notification = new Notification(Icons.MAIL, "New Email!", "from " + email.getAuthor());
            notification.pushTo(player);
        }
    }
}

