/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.component;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.ScrollableLayout;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.utils.OnlineRequest;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.programs.gitweb.layout.ModuleLayout;
import dev.ultreon.devices.programs.gitweb.module.AnvilModule;
import dev.ultreon.devices.programs.gitweb.module.AppLinkModule;
import dev.ultreon.devices.programs.gitweb.module.BannerIIModule;
import dev.ultreon.devices.programs.gitweb.module.BannerModule;
import dev.ultreon.devices.programs.gitweb.module.BrewingModule;
import dev.ultreon.devices.programs.gitweb.module.CraftingModule;
import dev.ultreon.devices.programs.gitweb.module.DividerModule;
import dev.ultreon.devices.programs.gitweb.module.DownloadModule;
import dev.ultreon.devices.programs.gitweb.module.FooterModule;
import dev.ultreon.devices.programs.gitweb.module.FurnaceModule;
import dev.ultreon.devices.programs.gitweb.module.HeaderModule;
import dev.ultreon.devices.programs.gitweb.module.LoomModule;
import dev.ultreon.devices.programs.gitweb.module.Module;
import dev.ultreon.devices.programs.gitweb.module.ModuleEntry;
import dev.ultreon.devices.programs.gitweb.module.NavigationModule;
import dev.ultreon.devices.programs.gitweb.module.ParagraphModule;
import dev.ultreon.devices.programs.gitweb.module.RedirectModule;
import dev.ultreon.devices.programs.gitweb.module.ScriptModule;
import dev.ultreon.devices.util.SiteRegistration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;

public class GitWebFrame
extends Component {
    public static final Pattern PATTERN_LINK = Pattern.compile("(?<domain>[a-zA-Z0-9\\p{sc=Han}\\p{InHiragana}\\p{InKatakana}\\-]+)\\.(?<extension>[a-zA-Z0-9\\p{sc=Han}\\p{InHiragana}\\p{InKatakana}]+)(?<directory>(/[a-zA-Z0-9\\p{sc=Han}\\p{InHiragana}\\p{InKatakana}\\-]+)*)(/)?");
    private static final Map<String, Module> MODULES = new HashMap<String, Module>();
    private final Application app;
    public final ScrollableLayout layout;
    private final int width;
    private final int height;
    private boolean allowRemoteUrls = false;
    private boolean initialized = false;
    private String currentWebsite;
    private String pendingWebsite;
    private String pendingUrl;
    private Callback<String> loadingCallback;
    private Callback<String> loadedCallback;

    public GitWebFrame(Application app, int left, int top, int width, int height) {
        super(left, top);
        this.app = app;
        this.width = width;
        this.height = height;
        this.layout = new ScrollableLayout(left, top, width, height, height);
        this.layout.setScrollSpeed(8);
    }

    private static List<ModuleEntry> parseData(String websiteData) {
        websiteData = websiteData.replace("\r", "");
        LinkedList<ModuleEntry> modules = new LinkedList<ModuleEntry>();
        String[] lines = websiteData.trim().split("\\n");
        Module module = null;
        HashMap<String, String> moduleData = null;
        for (String line : lines) {
            if (line.isEmpty()) continue;
            if (line.startsWith("#")) {
                ModuleEntry entry = GitWebFrame.compileEntry(module, moduleData);
                if (entry != null) {
                    modules.add(entry);
                }
                module = MODULES.get(line.substring(1));
                moduleData = new HashMap<String, String>();
                continue;
            }
            if (module != null) {
                String[] data = line.split("=", 2);
                if (data.length != 2) {
                    return null;
                }
                moduleData.put(data[0], data[1]);
                continue;
            }
            modules.clear();
            modules.add(GitWebFrame.createPlainWebsite(websiteData));
            return modules;
        }
        ModuleEntry entry = GitWebFrame.compileEntry(module, moduleData);
        if (entry != null) {
            modules.add(entry);
        }
        return modules;
    }

    private static ModuleEntry compileEntry(Module module, Map<String, String> data) {
        if (module != null && GitWebFrame.verifyModuleEntry(module, data)) {
            ModuleEntry moduleEntry = new ModuleEntry(module, data);
            moduleEntry.setId(data.getOrDefault("id", null));
            return moduleEntry;
        }
        return null;
    }

    private static ModuleEntry createPlainWebsite(String content) {
        Module module = MODULES.get("paragraph");
        HashMap<String, String> data = new HashMap<String, String>(1, 1.0f);
        data.put("text", content);
        return new ModuleEntry(module, data);
    }

    private static boolean verifyModuleEntry(Module module, Map<String, String> data) {
        String[] requiredData;
        for (String s : requiredData = module.getRequiredData()) {
            if (data.containsKey(s)) continue;
            return false;
        }
        return true;
    }

    private static int calculateHeight(List<ModuleEntry> modules, int width) {
        int height = 0;
        for (ModuleEntry entry : modules) {
            height += entry.getModule().calculateHeight(entry.getData(), width);
        }
        return height;
    }

    public static String parseFormatting(String s) {
        return s.replace("&", "\u00a7");
    }

    public static void dumpModules(File file) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String key : MODULES.keySet()) {
                Module module = MODULES.get(key);
                writer.write("#" + key);
                writer.newLine();
                writer.write("Required Data:");
                writer.newLine();
                for (String p : module.getRequiredData()) {
                    writer.write("- " + p);
                    writer.newLine();
                }
                writer.write("Optional Data:");
                writer.newLine();
                for (String p : module.getOptionalData()) {
                    writer.write("- " + p);
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void init(Layout layout) {
        layout.addComponent(this.layout);
    }

    @Override
    protected void handleLoad() {
        this.initialized = true;
        if (this.pendingUrl != null) {
            this.setUrl(this.pendingUrl);
            this.pendingUrl = null;
        } else if (this.pendingWebsite != null) {
            this.setWebsite(this.pendingWebsite);
            this.pendingWebsite = null;
        }
    }

    @Override
    protected void handleUnload() {
        this.initialized = false;
    }

    @Override
    protected void handleTick() {
        for (Component component : this.layout.components) {
            if (component instanceof ModuleLayout) {
                ModuleLayout moduleLayout = (ModuleLayout)component;
                moduleLayout._tick();
                continue;
            }
            DebugLog.log(component);
        }
        if (this.pendingWebsite != null) {
            this.setWebsite(this.pendingWebsite);
            this.pendingWebsite = null;
        } else if (this.pendingUrl != null) {
            this.setUrl(this.pendingUrl);
            this.pendingUrl = null;
        }
    }

    public void setAllowRemoteUrls(boolean allowRemoteUrls) {
        this.allowRemoteUrls = allowRemoteUrls;
    }

    public void scrollToTop() {
        this.layout.resetScroll();
    }

    public void loadRaw(String data) {
        this.layout.clear();
        this.generateLayout(data, false);
    }

    public void loadWebsite(String website) {
        if (this.allowRemoteUrls && (website.startsWith("http") || website.startsWith("https"))) {
            this.pendingUrl = website;
            return;
        }
        this.pendingWebsite = website;
    }

    public void loadUrl(String url) {
        if (this.allowRemoteUrls) {
            this.pendingUrl = url;
        }
    }

    private void setWebsite(String website) {
        String url;
        this.layout.clear();
        Matcher matcher = PATTERN_LINK.matcher(website);
        if (!matcher.matches()) {
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(null, false);
            }
            return;
        }
        this.currentWebsite = website;
        String domain = matcher.group("domain");
        String extension = matcher.group("extension");
        String directory = matcher.group("directory");
        String site = SiteRegistration.getURL(website);
        if (directory == null) {
            url = site + extension + "/" + domain + "/index";
        } else {
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            url = site + extension + "/" + domain + directory + "/index";
        }
        if (this.loadingCallback != null) {
            this.loadingCallback.execute(website, true);
        }
        this.load(url);
    }

    private void setUrl(String url) {
        this.layout.clear();
        try {
            URI.create(url);
        }
        catch (Exception e) {
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(null, false);
            }
            return;
        }
        this.currentWebsite = url;
        if (this.loadingCallback != null) {
            this.loadingCallback.execute(url, true);
        }
        this.load(url);
    }

    private void load(String url) {
        OnlineRequest.getInstance().make(url, (success, response) -> {
            String websiteData = new String(response);
            if (success) {
                this.generateLayout(websiteData, true);
            }
            if (this.loadedCallback != null) {
                this.loadedCallback.execute(websiteData, success);
            }
        });
    }

    public String getCurrentWebsite() {
        return this.currentWebsite;
    }

    private void generateLayout(String websiteData, boolean dynamic) {
        class_310.method_1551().method_18859(() -> {
            List<ModuleEntry> modules = GitWebFrame.parseData(websiteData);
            if (modules == null) {
                return;
            }
            this.layout.clear();
            this.layout.height = GitWebFrame.calculateHeight(modules, this.width);
            int offset = 0;
            for (int i = 0; i < modules.size() - 1; ++i) {
                ModuleEntry entry = modules.get(i);
                Module module = entry.getModule();
                int height = module.calculateHeight(entry.getData(), this.width);
                ModuleLayout moduleLayout = new ModuleLayout(0, offset, this.width, this, entry);
                this.layout.addComponent(moduleLayout);
                offset += height;
            }
            if (!modules.isEmpty()) {
                ModuleEntry entry = modules.getLast();
                Module module = entry.getModule();
                int height = module.calculateHeight(entry.getData(), this.width);
                ModuleLayout moduleLayout = new ModuleLayout(0, offset, this.width, this, entry);
                this.layout.addComponent(moduleLayout);
            }
            if (dynamic || this.initialized) {
                this.layout.handleLoad();
            }
            this.layout.resetScroll();
            this.updateListeners();
        });
    }

    private void updateListeners() {
        Text.WordListener listener = (word, mouseButton) -> {
            if (mouseButton == 0 && PATTERN_LINK.matcher(word).matches()) {
                this.pendingWebsite = word;
            }
        };
        this.addWordListener(this.layout, listener);
    }

    private void addWordListener(Layout layout, Text.WordListener listener) {
        for (Component c : layout.components) {
            Text text;
            if (c instanceof Layout) {
                this.addWordListener((Layout)c, listener);
                continue;
            }
            if (!(c instanceof Text) || (text = (Text)c).hasWordListener()) continue;
            text.setWordListener(listener);
        }
    }

    public void setLoadingCallback(Callback<String> loadingCallback) {
        this.loadingCallback = loadingCallback;
    }

    public void setLoadedCallback(Callback<String> loadedCallback) {
        this.loadedCallback = loadedCallback;
    }

    public Application getApp() {
        return this.app;
    }

    static {
        MODULES.put("header", new HeaderModule());
        MODULES.put("footer", new FooterModule());
        MODULES.put("paragraph", new ParagraphModule());
        MODULES.put("divider", new DividerModule());
        MODULES.put("banner", new BannerModule());
        MODULES.put("navigation", new NavigationModule());
        MODULES.put("crafting", new CraftingModule());
        MODULES.put("furnace", new FurnaceModule());
        MODULES.put("brewing", new BrewingModule());
        MODULES.put("anvil", new AnvilModule());
        MODULES.put("loom", new LoomModule());
        MODULES.put("download", new DownloadModule());
        MODULES.put("redirect", new RedirectModule());
        MODULES.put("applink", new AppLinkModule());
        MODULES.put("credits", new AppLinkModule());
        MODULES.put("script", new ScriptModule());
        MODULES.put("bannerII", new BannerIIModule());
    }
}

