/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public abstract class ContainerBox
extends Component {
    public static final int WIDTH = 128;
    protected static final class_2960 CONTAINER_BOXES_TEXTURE = class_2960.method_60655((String)"devices", (String)"textures/gui/container_boxes.png");
    protected List<Slot> slots = new ArrayList<Slot>();
    protected int boxU;
    protected int boxV;
    protected int height;
    protected class_1799 icon;
    protected String title;

    public ContainerBox(int left, int top, int boxU, int boxV, int height, class_1799 icon, String title) {
        super(left, top);
        this.boxU = boxU;
        this.boxV = boxV;
        this.height = height;
        this.icon = icon;
        this.title = title;
    }

    @Override
    protected void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)CONTAINER_BOXES_TEXTURE);
        RenderUtil.drawRectWithTexture(CONTAINER_BOXES_TEXTURE, graphics, (double)x, (double)(y + 12), (float)this.boxU, (float)this.boxV, 128, this.height, 128.0f, (float)this.height, 256, 256);
        int contentOffset = (128 - (ComputerScreen.getFont().method_1727(this.title) + 8 + 4)) / 2;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(x + contentOffset), (float)y, 0.0f);
        graphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
        RenderUtil.renderItem(graphics, x + contentOffset - 5, y - 4, this.icon, false);
        graphics.method_51448().method_22909();
        RenderUtil.drawStringClipped(graphics, this.title, x + contentOffset + 8 + 4, y, 110, Color.WHITE.getRGB(), true);
        this.slots.forEach(slot -> slot.render(graphics, x, y + 12));
    }

    @Override
    protected void renderOverlay(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        this.slots.forEach(slot -> slot.renderOverlay(graphics, computerScreen, this.xPosition, this.yPosition + 12, mouseX, mouseY));
    }

    protected static class Slot {
        private final int slotX;
        private final int slotY;
        private final class_1799 stack;

        public Slot(int slotX, int slotY, class_1799 stack) {
            this.slotX = slotX;
            this.slotY = slotY;
            this.stack = stack;
        }

        public void render(class_332 graphics, int x, int y) {
            RenderUtil.renderItem(graphics, x + this.slotX, y + this.slotY, this.stack, true);
        }

        public void renderOverlay(class_332 graphics, ComputerScreen computerScreen, int x, int y, int mouseX, int mouseY) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.slotX, y + this.slotY, 16, 16) && !this.stack.method_7960()) {
                graphics.method_51437(class_310.method_1551().field_1772, class_437.method_25408((class_310)class_310.method_1551(), (class_1799)this.stack), Optional.empty(), mouseX, mouseY);
            }
        }

        public class_1799 getStack() {
            return this.stack;
        }
    }
}

