/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.BankUtil;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.programs.system.task.TaskDeposit;
import dev.ultreon.devices.programs.system.task.TaskWithdraw;
import dev.ultreon.devices.util.InventoryUtil;
import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class BankApp
extends Application {
    private static final class_1799 EMERALD = new class_1799((class_1935)class_1802.field_8687);
    private static final class_2960 BANK_ASSETS = class_2960.method_60654((String)"devices:textures/gui/bank.png");
    private Layout layoutStart;
    private Label labelTeller;
    private Text textWelcome;
    private Button btnDepositWithdraw;
    private Button btnTransfer;
    private Layout layoutMain;
    private Label labelBalance;
    private Label labelAmount;
    private TextField amountField;
    private Button btnOne;
    private Button btnTwo;
    private Button btnThree;
    private Button btnFour;
    private Button btnFive;
    private Button btnSix;
    private Button btnSeven;
    private Button btnEight;
    private Button btnNine;
    private Button btnZero;
    private Button btnClear;
    private Button buttonDeposit;
    private Button buttonWithdraw;
    private Label labelEmeraldAmount;
    private Label labelInventory;
    private int emeraldAmount;
    private int rotation;

    @Override
    public void onTick() {
        super.onTick();
        ++this.rotation;
        if (this.rotation >= 100) {
            this.rotation = 0;
        }
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutStart = new Layout();
        this.layoutStart.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            assert (class_310.method_1551().field_1687 != null);
            graphics.method_51448().method_22903();
            RenderSystem.enableDepthTest();
            graphics.method_51448().method_46416((float)(x + 25), (float)(y + 33), 15.0f);
            graphics.method_51448().method_22905(-2.5f, -2.5f, -2.5f);
            float scaleX = (float)(mouseX - x - 25) / (float)width;
            float scaleY = (float)(mouseY - y - 20) / (float)height;
            RenderSystem.disableDepthTest();
            graphics.method_51448().method_22909();
            RenderSystem.setShaderTexture((int)0, (class_2960)BANK_ASSETS);
            RenderUtil.drawRectWithTexture(BANK_ASSETS, graphics, x + 46, y + 19, 0.0f, 0.0f, 146, 52, 146.0f, 52.0f);
        });
        this.labelTeller = new Label(String.valueOf(class_124.field_1054) + "Casey The Teller", 60, 7);
        this.layoutStart.addComponent(this.labelTeller);
        assert (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 != null);
        if (class_310.method_1551().field_1724 != null) {
            this.textWelcome = new Text(String.valueOf(class_124.field_1074) + "Hello " + class_310.method_1551().field_1724.method_7334().getName() + ", welcome to The Emerald Bank! How can I help you?", 62, 25, 125);
        }
        this.layoutStart.addComponent(this.textWelcome);
        this.btnDepositWithdraw = new Button(54, 74, "View Account");
        this.btnDepositWithdraw.setSize(76, 20);
        this.btnDepositWithdraw.setToolTip("View Account", "Shows your balance");
        this.layoutStart.addComponent(this.btnDepositWithdraw);
        this.btnTransfer = new Button(133, 74, "Transfer");
        this.btnTransfer.setSize(58, 20);
        this.btnTransfer.setToolTip("Transfer", "Withdraw and deposit emeralds");
        this.btnTransfer.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(this.layoutMain);
            }
        });
        this.layoutStart.addComponent(this.btnTransfer);
        this.setCurrentLayout(this.layoutStart);
        this.layoutMain = new Layout(120, 143){

            @Override
            public void handleTick() {
                super.handleTick();
                int amount = InventoryUtil.getItemAmount((class_1657)class_310.method_1551().field_1724, class_1802.field_8687);
                BankApp.this.labelEmeraldAmount.setText("x " + amount);
            }
        };
        this.layoutMain.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            graphics.method_25294(x, y, x + width, y + 40, Color.GRAY.getRGB());
            graphics.method_25294(x, y + 39, x + width, y + 40, Color.DARK_GRAY.getRGB());
            graphics.method_25294(x + 62, y + 103, x + 115, y + 138, Color.BLACK.getRGB());
            graphics.method_25294(x + 63, y + 104, x + 114, y + 113, Color.DARK_GRAY.getRGB());
            graphics.method_25294(x + 63, y + 114, x + 114, y + 137, Color.GRAY.getRGB());
            RenderUtil.renderItem(graphics, x + 65, y + 118, EMERALD, false);
        });
        this.labelBalance = new Label("Balance", 60, 5);
        this.labelBalance.setAlignment(2);
        this.labelBalance.setShadow(false);
        this.layoutMain.addComponent(this.labelBalance);
        this.labelAmount = new Label("Loading balance...", 60, 18);
        this.labelAmount.setAlignment(2);
        this.labelAmount.setScale(2.0);
        this.layoutMain.addComponent(this.labelAmount);
        this.amountField = new TextField(5, 45, 110);
        this.amountField.setText("0");
        this.amountField.setEditable(false);
        this.layoutMain.addComponent(this.amountField);
        for (int i = 0; i < 9; ++i) {
            int posX = 5 + i % 3 * 19;
            int posY = 65 + i / 3 * 19;
            Button button = new Button(posX, posY, Integer.toString(i + 1));
            button.setSize(16, 16);
            this.addNumberClickListener(button, this.amountField, i + 1);
            this.layoutMain.addComponent(button);
        }
        this.btnZero = new Button(5, 122, "0");
        this.btnZero.setSize(16, 16);
        this.addNumberClickListener(this.btnZero, this.amountField, 0);
        this.layoutMain.addComponent(this.btnZero);
        this.btnClear = new Button(24, 122, "Clr");
        this.btnClear.setSize(35, 16);
        this.btnClear.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.amountField.setText("0");
            }
        });
        this.layoutMain.addComponent(this.btnClear);
        this.buttonDeposit = new Button(62, 65, "Deposit");
        this.buttonDeposit.setSize(53, 16);
        this.buttonDeposit.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.deposit(amount, (tag, success) -> {
                        if (success) {
                            assert (tag != null);
                            int balance = tag.method_10550("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can deposit is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonDeposit);
        this.buttonWithdraw = new Button(62, 84, "Withdraw");
        this.buttonWithdraw.setSize(53, 16);
        this.buttonWithdraw.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.amountField.getText().equals("0")) {
                    return;
                }
                try {
                    int amount = Integer.parseInt(this.amountField.getText());
                    this.withdraw(amount, (tag, success) -> {
                        if (success) {
                            assert (tag != null);
                            int balance = tag.method_10550("balance");
                            this.labelAmount.setText("$" + balance);
                            this.amountField.setText("0");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    this.amountField.setText("0");
                    this.openDialog(new Dialog.Message("Invalid amount. The maximum that you can withdraw is 2147483647"));
                }
            }
        });
        this.layoutMain.addComponent(this.buttonWithdraw);
        this.labelEmeraldAmount = new Label("x 0", 83, 123);
        this.layoutMain.addComponent(this.labelEmeraldAmount);
        this.labelInventory = new Label("Wallet", 74, 105);
        this.labelInventory.setShadow(false);
        this.layoutMain.addComponent(this.labelInventory);
        BankUtil.getBalance((tag, success) -> {
            if (success) {
                assert (tag != null);
                int balance = tag.method_10550("balance");
                this.labelAmount.setText("$" + balance);
            }
        });
    }

    public void addNumberClickListener(Button btn, TextField field, int number) {
        btn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (!(mouseButton != 0 || field.getText().equals("0") && number == 0)) {
                if (field.getText().equals("0")) {
                    field.clear();
                }
                field.writeText(Integer.toString(number));
            }
        });
    }

    private void deposit(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskDeposit(amount).setCallback(callback));
    }

    private void withdraw(int amount, Callback<class_2487> callback) {
        TaskManager.sendTask(new TaskWithdraw(amount).setCallback(callback));
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }
}

