/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.object;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.programs.system.object.ColorScheme;
import dev.ultreon.devices.programs.system.object.ColorSchemePresetRegistry;
import dev.ultreon.devices.programs.system.object.Preset;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public class ColorSchemePresets {
    public static final Preset DEFAULT = ColorSchemePresets.createPreset("default", new ColorScheme(), colorScheme -> {});
    public static final Preset DARK = ColorSchemePresets.createPreset("dark", new ColorScheme(), scheme -> {
        scheme.buttonColor = 0x303030;
        scheme.backgroundColor = 0x202020;
        scheme.textColor = 0xFFFFFF;
        scheme.backgroundSecondaryColor = 0x303030;
        scheme.textSecondaryColor = 0xA0A0A0;
        scheme.itemBackgroundColor = 0x404040;
        scheme.itemHighlightColor = 0x505050;
        scheme.headerColor = 0x303030;
        scheme.windowBackgroundColor = 0x202020;
    });
    public static final Preset LIGHT = ColorSchemePresets.createPreset("light", new ColorScheme(), scheme -> {
        scheme.buttonColor = 33023;
        scheme.backgroundColor = 0xD0D0D0;
        scheme.textColor = 0;
        scheme.backgroundSecondaryColor = 0xA0A0A0;
        scheme.textSecondaryColor = 0x303030;
        scheme.itemBackgroundColor = 0xB0B0B0;
        scheme.itemHighlightColor = 0xC0C0C0;
        scheme.headerColor = 0xA0A0A0;
        scheme.windowBackgroundColor = 0xE0E0E0;
    });

    private static Preset createPreset(String name, ColorScheme colorScheme, Consumer<ColorScheme> consumer) {
        consumer.accept(colorScheme);
        class_2960 id = UltreonDevices.res(name);
        Preset preset = new Preset(colorScheme, id);
        ColorSchemePresetRegistry.register(id, preset);
        return preset;
    }

    public static void init() {
    }
}

