/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices;

import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.block.entity.renderer.LaptopRenderer;
import dev.ultreon.devices.block.entity.renderer.OfficeChairRenderer;
import dev.ultreon.devices.block.entity.renderer.PaperRenderer;
import dev.ultreon.devices.block.entity.renderer.PrinterRenderer;
import dev.ultreon.devices.block.entity.renderer.RouterRenderer;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.debug.DebugUtils;
import dev.ultreon.devices.debug.DumpType;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.object.ColorSchemePresets;
import dev.ultreon.mods.xinexlib.ModPlatform;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import dev.ultreon.mods.xinexlib.platform.services.EntityRendererRegistry;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClientModEvents {
    private static final Marker SETUP = MarkerFactory.getMarker((String)"SETUP");
    private static final Logger LOGGER = Devices.LOGGER;

    public static void clientSetup() {
        LOGGER.info("Doing some client setup.");
        if (Devices.DEVELOPER_MODE) {
            LOGGER.info(SETUP, "Adding developer wallpaper.");
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/developer_wallpaper.png"));
        } else {
            LOGGER.info(SETUP, "Adding default wallpapers.");
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_1.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_2.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_3.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_4.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_5.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_6.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_7.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_8.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_9.png"));
            ComputerScreen.addWallpaper(class_2960.method_60654((String)"devices:textures/gui/laptop_wallpaper_10.png"));
        }
        ClientModEvents.registerRenderLayers();
        ClientModEvents.registerRenderers();
        ClientModEvents.registerLayerDefinitions();
        if (XinexPlatform.getPlatformName() == ModPlatform.Forge || XinexPlatform.getPlatformName() == ModPlatform.NeoForge) {
            ClientModEvents.generateIconAtlas();
        }
        ClientModEvents.registerOSContent();
    }

    private static void registerOSContent() {
        ColorSchemePresets.init();
    }

    private static void registerRenderLayers() {
    }

    public static void generateIconAtlas() {
        ClientModEvents.generateIconAtlas(class_310.method_1551().method_1478());
    }

    public static void generateIconAtlas(final class_3300 resourceManager) {
        int ICON_SIZE = 14;
        var imageWriter = new Object(){
            final BufferedImage atlas = new BufferedImage(224, 224, 2);
            final Graphics g = this.atlas.createGraphics();
            int index = 0;
            int mode = 0;
            class_3300 rm = resourceManager;

            public void writeImage(AppInfo info, class_2960 location) {
                String path = "/assets/" + location.method_12836() + "/" + location.method_12832();
                try {
                    BufferedImage icon;
                    InputStream input;
                    if (this.rm == null) {
                        this.rm = class_310.method_1551().method_1478();
                    }
                    if ((input = this.getClass().getClassLoader().getResourceAsStream(path)) == null && (input = this.getClass().getResourceAsStream(path)) == null) {
                        class_3298 resource = this.rm.method_14486(location).orElse(null);
                        if (resource == null) {
                            throw new FileNotFoundException("Resource for " + String.valueOf(location) + " wasn't found");
                        }
                        input = resource.method_14482();
                    }
                    if ((icon = ImageIO.read(input)).getWidth() != 14 || icon.getHeight() != 14) {
                        Devices.LOGGER.error("Incorrect icon size for {} (Must be 14 by 14 pixels)", (Object)(info == null ? null : info.getId()));
                        return;
                    }
                    int iconU = this.index % 16 * 14;
                    int iconV = this.index / 16 * 14;
                    this.g.drawImage(icon, iconU, iconV, 14, 14, null);
                    if (info != null) {
                        AppInfo.Icon.Glyph glyph = switch (this.mode) {
                            case 0 -> info.getIcon().getBase();
                            case 1 -> info.getIcon().getOverlay0();
                            case 2 -> info.getIcon().getOverlay1();
                            default -> throw new IllegalStateException("Unexpected value: " + this.mode);
                        };
                        glyph.setU(iconU);
                        glyph.setV(iconV);
                    }
                    ++this.index;
                    Devices.LOGGER.info("Stitching texture: {}", (Object)location);
                }
                catch (FileNotFoundException e) {
                    Devices.LOGGER.error("Unable to load icon for '{}': {}", (Object)(info == null ? null : info.getId()), (Object)e.getMessage());
                }
                catch (Exception e) {
                    Devices.LOGGER.error("Unable to load icon for {}", (Object)(info == null ? null : info.getId()));
                    LOGGER.error("Unable to load icon for {}", (Object)(info == null ? null : info.getId()), (Object)e);
                }
            }

            public void finish() {
                this.g.dispose();
                try {
                    DebugUtils.dump(DumpType.ATLAS, ComputerScreen.ICON_TEXTURES, stream -> ImageIO.write((RenderedImage)this.atlas, "png", stream));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)this.atlas, "png", output);
                    byte[] bytes = output.toByteArray();
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    CompletableFuture completableFuture = class_310.method_1551().method_20493(() -> {
                        try {
                            class_310.method_1551().method_1531().method_4616(ComputerScreen.ICON_TEXTURES, (class_1044)new class_1043(class_1011.method_4309((InputStream)input)));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        imageWriter.writeImage(null, class_2960.method_60655((String)"devices", (String)"textures/app/icon/base/missing.png"));
        for (AppInfo info : ApplicationManager.getAllApplications()) {
            if (info.getIcon() == null) continue;
            imageWriter.mode = 0;
            imageWriter.writeImage(info, info.getIcon().getBase().getResourceLocation());
            imageWriter.mode = 1;
            imageWriter.writeImage(info, info.getIcon().getOverlay0().getResourceLocation());
            imageWriter.mode = 2;
            imageWriter.writeImage(info, info.getIcon().getOverlay1().getResourceLocation());
        }
        imageWriter.mode = 0;
        imageWriter.finish();
    }

    public static void registerRenderers() {
        LOGGER.info("Registering renderers.");
        EntityRendererRegistry entityRendererRegistry = XinexPlatform.client().entityRenderers();
        entityRendererRegistry.register(DeviceBlockEntities.LAPTOP, LaptopRenderer::new);
        entityRendererRegistry.register(DeviceBlockEntities.PRINTER, PrinterRenderer::new);
        entityRendererRegistry.register(DeviceBlockEntities.PAPER, PaperRenderer::new);
        entityRendererRegistry.register(DeviceBlockEntities.ROUTER, RouterRenderer::new);
        entityRendererRegistry.register(DeviceBlockEntities.SEAT, OfficeChairRenderer::new);
    }

    public static void registerLayerDefinitions() {
        LOGGER.info("Registering layer definitions.");
        EntityRendererRegistry entityRendererRegistry = XinexPlatform.client().entityRenderers();
        entityRendererRegistry.registerModel(PrinterRenderer.PaperModel.LAYER_LOCATION, PrinterRenderer.PaperModel::createBodyLayer);
    }

    @ApiStatus.Internal
    public static class ReloaderListener
    implements class_3302 {
        @NotNull
        @ApiStatus.Internal
        public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            LOGGER.debug("Reloading resources from the Device Mod.");
            return CompletableFuture.runAsync(() -> {
                if (!ApplicationManager.getAllApplications().isEmpty()) {
                    ApplicationManager.getAllApplications().forEach(appInfo -> appInfo.reload(resourceManager));
                    ClientModEvents.generateIconAtlas(resourceManager);
                }
            }, gameExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
        }
    }
}

