/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Lifecycle;
import dev.ultreon.devices.ClientModEvents;
import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.DevicesEarlyConfig;
import dev.ultreon.devices.LaunchException;
import dev.ultreon.devices.Reference;
import dev.ultreon.devices.TestManager;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.OnlineRequest;
import dev.ultreon.devices.client.ClientNotification;
import dev.ultreon.devices.client.debug.ClientAppDebug;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.io.task.TaskGetFiles;
import dev.ultreon.devices.core.io.task.TaskGetMainDrive;
import dev.ultreon.devices.core.io.task.TaskSendAction;
import dev.ultreon.devices.core.io.task.TaskSetupFileBrowser;
import dev.ultreon.devices.core.network.task.TaskConnect;
import dev.ultreon.devices.core.network.task.TaskGetDevices;
import dev.ultreon.devices.core.network.task.TaskPing;
import dev.ultreon.devices.core.print.task.TaskPrint;
import dev.ultreon.devices.core.task.TaskInstallApp;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.event.WorldDataHandler;
import dev.ultreon.devices.network.PacketHandler;
import dev.ultreon.devices.network.task.SyncApplicationPacket;
import dev.ultreon.devices.network.task.SyncConfigPacket;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.object.TrayItem;
import dev.ultreon.devices.programs.IconsApp;
import dev.ultreon.devices.programs.PixelPainterApp;
import dev.ultreon.devices.programs.TestApp;
import dev.ultreon.devices.programs.auction.task.TaskAddAuction;
import dev.ultreon.devices.programs.auction.task.TaskBuyItem;
import dev.ultreon.devices.programs.auction.task.TaskGetAuctions;
import dev.ultreon.devices.programs.debug.TextAreaApp;
import dev.ultreon.devices.programs.email.task.TaskCheckEmailAccount;
import dev.ultreon.devices.programs.email.task.TaskDeleteEmail;
import dev.ultreon.devices.programs.email.task.TaskRegisterEmailAccount;
import dev.ultreon.devices.programs.email.task.TaskSendEmail;
import dev.ultreon.devices.programs.email.task.TaskUpdateInbox;
import dev.ultreon.devices.programs.email.task.TaskViewEmail;
import dev.ultreon.devices.programs.example.ExampleApp;
import dev.ultreon.devices.programs.example.task.TaskNotificationTest;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.programs.system.task.TaskAdd;
import dev.ultreon.devices.programs.system.task.TaskDeposit;
import dev.ultreon.devices.programs.system.task.TaskGetBalance;
import dev.ultreon.devices.programs.system.task.TaskPay;
import dev.ultreon.devices.programs.system.task.TaskRemove;
import dev.ultreon.devices.programs.system.task.TaskUpdateApplicationData;
import dev.ultreon.devices.programs.system.task.TaskUpdateSystemData;
import dev.ultreon.devices.programs.system.task.TaskWithdraw;
import dev.ultreon.devices.util.SiteRegistration;
import dev.ultreon.devices.util.Vulnerability;
import dev.ultreon.mods.xinexlib.Env;
import dev.ultreon.mods.xinexlib.EnvExecutor;
import dev.ultreon.mods.xinexlib.ModPlatform;
import dev.ultreon.mods.xinexlib.client.event.LocalPlayerQuitEvent;
import dev.ultreon.mods.xinexlib.event.interact.UseBlockEvent;
import dev.ultreon.mods.xinexlib.event.server.ServerPlayerJoinEvent;
import dev.ultreon.mods.xinexlib.event.server.ServerStartingEvent;
import dev.ultreon.mods.xinexlib.event.server.ServerStoppedEvent;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import dev.ultreon.mods.xinexlib.registrar.RegistrarManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2370;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Devices {
    public static final boolean DEVELOPER_MODE = XinexPlatform.isDevelopmentEnvironment();
    public static final String MOD_ID = "devices";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ultreon Devices Mod");
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> XinexPlatform.getRegistrarManager((String)MOD_ID));
    public static final List<SiteRegistration> SITE_REGISTRATIONS = new ProtectedArrayList<SiteRegistration>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DevicesEarlyConfig EARLY_CONFIG = new DevicesEarlyConfig();
    private static final Pattern DEV_PREVIEW_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+-dev\\d+");
    private static final boolean IS_DEV_PREVIEW = DEV_PREVIEW_PATTERN.matcher(Reference.VERSION).matches();
    private static final String GITWEB_REGISTER_URL = "https://ultreon.gitlab.io/gitweb/site_register.json";
    private static final SiteRegisterStack SITE_REGISTER_STACK = new SiteRegisterStack();
    public static class_2370<TrayItem> trayItemRegistry = new class_2370(class_5321.method_29180((class_2960)Devices.id("tray_item")), Lifecycle.stable());
    static List<AppInfo> allowedApps = new ArrayList<AppInfo>();
    private static List<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
    private static Devices instance;
    private ArrayList<Application> apps;
    private static MinecraftServer server;
    private static TestManager tests;

    public static List<Vulnerability> getVulnerabilities() {
        return vulnerabilities;
    }

    protected Devices() {
        instance = this;
    }

    public static Devices getInstance() {
        return instance;
    }

    public void init() {
        if (XinexPlatform.getPlatformName().equals((Object)ModPlatform.Fabric)) {
            Devices.preInit();
            this.serverSetup();
        }
        WorldDataHandler.init();
        String property = System.getProperty("ultreon.devices.tests");
        tests = new TestManager();
        if (property != null) {
            String[] split = property.split(",");
            tests.load(Set.of(split));
        }
        LOGGER.info("Doing some common setup.");
        PacketHandler.init();
        this.registerApplications();
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            ClientAppDebug.register();
            ClientModEvents.clientSetup();
            Devices.setupSiteRegistrations();
            Devices.checkForVulnerabilities();
        });
        LOGGER.info("Registering events.");
        Devices.setupEvents();
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Devices::setupClientEvents);
        if (XinexPlatform.getPlatformName() != ModPlatform.Forge) {
            this.loadComplete();
        }
    }

    public static void preInit() {
        if (DEVELOPER_MODE && !XinexPlatform.isDevelopmentEnvironment()) {
            throw new LaunchException();
        }
        DeviceConfig.init();
    }

    public static boolean isDevelopmentPreview() {
        return IS_DEV_PREVIEW;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static TestManager getTests() {
        return tests;
    }

    public void serverSetup() {
        LOGGER.info("Doing some server setup.");
    }

    public void loadComplete() {
        LOGGER.info("Doing some load complete handling.");
    }

    private void registerApplications() {
        this.registerApplicationEvent();
        TaskManager.registerTask(TaskUpdateApplicationData::new);
        TaskManager.registerTask(TaskPrint::new);
        TaskManager.registerTask(TaskUpdateSystemData::new);
        TaskManager.registerTask(TaskConnect::new);
        TaskManager.registerTask(TaskPing::new);
        TaskManager.registerTask(TaskGetDevices::new);
        TaskManager.registerTask(TaskSendAction::new);
        TaskManager.registerTask(TaskSetupFileBrowser::new);
        TaskManager.registerTask(TaskGetFiles::new);
        TaskManager.registerTask(TaskGetMainDrive::new);
        TaskManager.registerTask(TaskInstallApp::new);
        TaskManager.registerTask(TaskUpdateInbox::new);
        TaskManager.registerTask(TaskSendEmail::new);
        TaskManager.registerTask(TaskCheckEmailAccount::new);
        TaskManager.registerTask(TaskRegisterEmailAccount::new);
        TaskManager.registerTask(TaskDeleteEmail::new);
        TaskManager.registerTask(TaskViewEmail::new);
        if (XinexPlatform.isDevelopmentEnvironment() || Devices.EARLY_CONFIG.enableBetaApps) {
            TaskManager.registerTask(TaskAddAuction::new);
            TaskManager.registerTask(TaskGetAuctions::new);
            TaskManager.registerTask(TaskBuyItem::new);
            TaskManager.registerTask(TaskDeposit::new);
            TaskManager.registerTask(TaskWithdraw::new);
            TaskManager.registerTask(TaskGetBalance::new);
            TaskManager.registerTask(TaskPay::new);
            TaskManager.registerTask(TaskAdd::new);
            TaskManager.registerTask(TaskRemove::new);
        }
        if (XinexPlatform.isDevelopmentEnvironment() || Devices.EARLY_CONFIG.enableDebugApps) {
            ApplicationManager.registerApplication(class_2960.method_60655((String)MOD_ID, (String)"example"), () -> ExampleApp::new, false);
            ApplicationManager.registerApplication(class_2960.method_60655((String)MOD_ID, (String)"icons"), () -> IconsApp::new, false);
            ApplicationManager.registerApplication(class_2960.method_60655((String)MOD_ID, (String)"text_area"), () -> TextAreaApp::new, false);
            ApplicationManager.registerApplication(class_2960.method_60655((String)MOD_ID, (String)"test"), () -> TestApp::new, false);
            TaskManager.registerTask(TaskNotificationTest::new);
        }
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> PrintingManager.registerPrint(class_2960.method_60655((String)MOD_ID, (String)"picture"), PixelPainterApp.PicturePrint.class));
    }

    public abstract int getBurnTime(class_1799 var1, class_3956<?> var2);

    protected abstract void registerApplicationEvent();

    protected List<Application> loadApps() {
        if (this.apps != null) {
            return this.apps;
        }
        this.apps = new ArrayList();
        ComputerScreen.loadApplications(this.apps::addAll);
        return this.apps;
    }

    public static void setAllowedApps(List<AppInfo> allowedApps) {
        Devices.allowedApps = allowedApps;
    }

    public abstract String getVersion();

    @Nullable
    @ApiStatus.Internal
    public Application registerApplication(class_2960 identifier, ApplicationSupplier app) {
        if ("minecraft".equals(identifier.method_12836())) {
            throw new IllegalArgumentException("Identifier cannot be \"minecraft\"!");
        }
        if (allowedApps == null) {
            allowedApps = new ArrayList<AppInfo>();
        }
        if (app.isSystem()) {
            allowedApps.add(new AppInfo(identifier, true));
        } else {
            allowedApps.add(new AppInfo(identifier, false));
        }
        AtomicReference<Object> application = new AtomicReference<Object>(null);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            Application theAppWeGot = app.get().get();
            List<Application> apps = this.loadApps();
            assert (apps != null);
            apps.add(theAppWeGot);
            AppInfo info = new AppInfo(identifier, SystemApp.class.isAssignableFrom(theAppWeGot.getClass()));
            class_3300 resourceManager = class_310.method_1551().method_1478();
            theAppWeGot.setInfo(info);
            application.set(theAppWeGot);
        });
        return application.get();
    }

    protected abstract Map<String, IPrint.Renderer> getRegisteredRenders();

    protected abstract void setRegisteredRenders(Map<String, IPrint.Renderer> var1);

    public boolean registerPrint(class_2960 identifier, Class<? extends IPrint> classPrint) {
        LOGGER.debug("Registering print: {}", (Object)identifier.toString());
        try {
            Constructor<? extends IPrint> constructor = classPrint.getConstructor(new Class[0]);
            IPrint print = constructor.newInstance(new Object[0]);
            Class<? extends IPrint.Renderer> classRenderer = print.getRenderer();
            try {
                IPrint.Renderer renderer = classRenderer.getConstructor(new Class[0]).newInstance(new Object[0]);
                Map<String, IPrint.Renderer> idToRenderer = this.getRegisteredRenders();
                if (idToRenderer == null) {
                    idToRenderer = new HashMap<String, IPrint.Renderer>();
                    this.setRegisteredRenders(idToRenderer);
                }
                idToRenderer.put(identifier.toString(), renderer);
            }
            catch (InstantiationException e) {
                LOGGER.error("The print renderer '{}' is missing an empty constructor and could not be registered!", (Object)classRenderer.getName());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("The print '{}' is missing an empty constructor and could not be registered!", (Object)classPrint.getName());
            return false;
        }
    }

    public static void showNotification(class_2487 tag) {
        LOGGER.debug("Showing notification");
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            ClientNotification notification = ClientNotification.loadFromTag(tag);
            notification.push();
        });
    }

    public static boolean hasAllowedApplications() {
        return allowedApps != null;
    }

    public static List<AppInfo> getAllowedApplications() {
        if (allowedApps == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(allowedApps);
    }

    public static class_2960 res(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void setupClientEvents() {
        EventSystem.MAIN.on(LocalPlayerQuitEvent.class, event -> {
            LOGGER.debug("Client disconnected from server");
            allowedApps = null;
            DeviceConfig.restore();
        });
    }

    private static void setupEvents() {
        EventSystem.MAIN.on(ServerStartingEvent.class, event -> {
            server = event.getServer();
        });
        EventSystem.MAIN.on(ServerStoppedEvent.class, event -> {
            server = null;
        });
        EventSystem.MAIN.on(UseBlockEvent.class, event -> {});
        EventSystem.MAIN.on(ServerPlayerJoinEvent.class, event -> {
            class_3222 player = event.getPlayer();
            LOGGER.info("Player logged in: {}", (Object)player.method_5477());
            if (allowedApps != null) {
                PacketHandler.sendToClient(new SyncApplicationPacket(allowedApps), player);
            }
            PacketHandler.sendToClient(new SyncConfigPacket(), player);
        });
    }

    private static void setupSiteRegistrations() {
        Devices.setupSiteRegistration(GITWEB_REGISTER_URL);
    }

    private static void checkForVulnerabilities() {
    }

    private static CompletableFuture<Void> setupSiteRegistration(String url) {
        SITE_REGISTER_STACK.push();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        OnlineRequest.getInstance().make(url, (success, response) -> CompletableFuture.runAsync(() -> {
            if (success) {
                JsonElement root = JsonParser.parseString((String)new String(response));
                DebugLog.log("root = " + String.valueOf(root));
                JsonArray rootArray = root.getAsJsonArray();
                block14: for (JsonElement rootRegister : rootArray) {
                    DebugLog.log("rootRegister = " + String.valueOf(rootRegister));
                    JsonObject elem = rootRegister.getAsJsonObject();
                    String registrant = elem.get("registrant") != null ? elem.get("registrant").getAsString() : null;
                    static enum Type {
                        SITE_REGISTER,
                        REGISTRATION;

                    }
                    Type type = Type.REGISTRATION;
                    JsonElement typeElem = elem.get("type");
                    if (typeElem != null && typeElem.isJsonPrimitive() && typeElem.getAsJsonPrimitive().isString()) {
                        switch (typeElem.getAsString()) {
                            case "registration": {
                                break;
                            }
                            case "site-register": {
                                type = Type.SITE_REGISTER;
                                break;
                            }
                            default: {
                                LOGGER.error("Invalid element type: {}", (Object)typeElem.getAsString());
                                continue block14;
                            }
                        }
                    }
                    switch (type.ordinal()) {
                        case 1: {
                            boolean dev = elem.get("dev") != null ? elem.get("dev").getAsBoolean() : false;
                            String site = elem.get("site").getAsString();
                            if (dev && !IS_DEV_PREVIEW) break;
                            for (JsonElement registration : elem.get("registrations").getAsJsonArray()) {
                                Set a = registration.getAsJsonObject().keySet();
                                JsonObject d = registration.getAsJsonObject();
                                for (String string : a) {
                                    String registrationType = d.get(string).getAsString();
                                    SITE_REGISTRATIONS.add(new SiteRegistration(registrant, string, registrationType, site));
                                }
                            }
                            break;
                        }
                        case 0: {
                            if (!elem.has("register") || !elem.get("register").isJsonPrimitive() || !elem.get("register").getAsJsonPrimitive().isString()) break;
                            String registerUrl = elem.get("register").getAsString();
                            try {
                                CompletableFuture<Void> registerFuture = Devices.setupSiteRegistration(registerUrl);
                                registerFuture.join();
                                break;
                            }
                            catch (Exception e) {
                                LOGGER.error("Error when loading site register: {}", (Object)registerUrl);
                            }
                        }
                    }
                }
            } else {
                LOGGER.error("Error occurred when loading site registrations at: {}", (Object)url);
                future.complete(null);
                return;
            }
            future.complete(null);
            SITE_REGISTER_STACK.pop();
        }));
        return future;
    }

    @Deprecated
    public static class_2960 id(String id) {
        return Devices.res(id);
    }

    public static interface ApplicationSupplier {
        public Supplier<Application> get();

        public boolean isSystem();
    }

    private static class SiteRegisterStack
    extends Stack<Object> {
        private SiteRegisterStack() {
        }

        public Object push() {
            return super.push(new Object());
        }

        @Override
        public synchronized Object pop() {
            Object pop = super.pop();
            if (this.isEmpty()) {
                ((ProtectedArrayList)SITE_REGISTRATIONS).freeze();
            }
            return pop;
        }
    }

    private static class ProtectedArrayList<T>
    extends ArrayList<T> {
        private final StackWalker stackWalker = StackWalker.getInstance(EnumSet.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
        private boolean frozen = false;

        private ProtectedArrayList() {
        }

        private void freeze() {
            this.frozen = true;
        }

        private void freezeCheck() {
            if (this.frozen) {
                throw new IllegalStateException("Already frozen!");
            }
        }

        @Override
        public boolean add(T t) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.add(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.addAll(c);
        }

        @Override
        public void add(int index, T element) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            super.add(index, element);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            super.removeRange(fromIndex, toIndex);
        }

        @Override
        public boolean remove(Object o) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.removeIf(filter);
        }

        @Override
        public T remove(int index) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return (T)super.remove(index);
        }
    }
}

