/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Permission;
import dev.ultreon.devices.core.PermissionManager;
import dev.ultreon.devices.core.Window;
import dev.ultreon.devices.core.Wrappable;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.component.FileInfo;
import dev.ultreon.devices.util.DataHandler;
import dev.ultreon.devices.util.GLHelper;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3902;
import org.jetbrains.annotations.Nullable;

public abstract class Application
extends Wrappable
implements DataHandler {
    protected AppInfo info = null;
    private final Layout defaultLayout = new Layout();
    private class_2338 laptopPositon;
    private int width;
    private int height;
    private Layout currentLayout;
    private boolean needsDataUpdate = false;
    private boolean pendingLayoutUpdate = false;

    public void setInfo(AppInfo info) {
        if (StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().equals(Devices.class)) {
            this.info = info;
            return;
        }
        throw new IllegalStateException();
    }

    public AppInfo getInfo() {
        return this.info;
    }

    public final void install() throws AccessDeniedException {
        if (!PermissionManager.hasPermission(Permission.SOFTWARE_MANAGEMENT)) {
            throw new AccessDeniedException("You do not have permission to install applications");
        }
        if (ComputerScreen.getInstance().isApplicationInstalled(this.info)) {
            throw new AccessDeniedException("Application is already installed");
        }
    }

    protected void onInstall() {
    }

    protected final void addComponent(Component c) {
        if (c != null) {
            this.defaultLayout.addComponent(c);
        }
    }

    public final Layout getCurrentLayout() {
        return this.currentLayout;
    }

    public final void setCurrentLayout(Layout layout) {
        if (this.currentLayout != null) {
            this.currentLayout.handleUnload();
        }
        this.currentLayout = layout;
        this.width = layout.width;
        this.height = layout.height;
        this.pendingLayoutUpdate = true;
        this.currentLayout.handleLoad();
    }

    public final void restoreDefaultLayout() {
        this.setCurrentLayout(this.defaultLayout);
    }

    @Override
    public abstract void init(@Nullable class_2487 var1);

    @Override
    public void onTick() {
        this.currentLayout.handleTick();
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        GLHelper.pushScissor(x, y, this.width, this.height);
        this.currentLayout.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, active, partialTicks);
        GLHelper.popScissor();
        this.currentLayout.renderOverlay(graphics, computerScreen, mc, mouseX, mouseY, active);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        this.currentLayout.handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, double delta, boolean direction) {
        this.currentLayout.handleMouseScroll(mouseX, mouseY, direction);
    }

    @Override
    @Deprecated
    public void handleKeyTyped(char character, int code) {
        this.currentLayout.handleKeyTyped(character, code);
    }

    @Override
    @Deprecated
    public void handleKeyReleased(char character, int code) {
        this.currentLayout.handleKeyReleased(character, code);
    }

    @Override
    public void handleCharTyped(char character, int modifiers) {
        this.currentLayout.handleCharTyped(character, modifiers);
    }

    @Override
    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        this.currentLayout.handleKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        this.currentLayout.handleKeyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public final void updateComponents(int x, int y) {
        this.currentLayout.updateComponents(x, y);
    }

    @Override
    public void onClose() {
        this.defaultLayout.clear();
        this.currentLayout = null;
    }

    @Override
    public abstract void load(class_2487 var1);

    @Override
    public abstract void save(class_2487 var1);

    protected final void setDefaultWidth(int width) {
        if (width < 20) {
            throw new IllegalArgumentException("Width must be larger than 20");
        }
        this.defaultLayout.width = width;
    }

    protected final void setDefaultHeight(int height) {
        if (height < 20) {
            throw new IllegalArgumentException("Height must be larger than 20");
        }
        this.defaultLayout.height = height;
    }

    protected void markDirty() {
        this.needsDataUpdate = true;
    }

    public final boolean isDirty() {
        return this.needsDataUpdate;
    }

    public final void clean() {
        this.needsDataUpdate = false;
    }

    @Override
    public final void markForLayoutUpdate() {
        this.pendingLayoutUpdate = true;
    }

    @Override
    public final boolean isPendingLayoutUpdate() {
        return this.pendingLayoutUpdate;
    }

    @Override
    public final void clearPendingLayout() {
        this.pendingLayoutUpdate = false;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public String getWindowTitle() {
        if (this.currentLayout.hasTitle()) {
            return this.currentLayout.getTitle();
        }
        return Objects.requireNonNull(this.info).getName();
    }

    public Path getApplicationFolderPath() {
        return Path.of(String.valueOf(FileSystem.DIR_APPLICATION_DATA) + "/" + Objects.requireNonNull(this.info).getFormattedId(), new String[0]);
    }

    @Nullable
    public Window<Dialog> getActiveDialog() {
        Window<Dialog> dialogWindow = this.getWindow().getDialogWindow();
        if (dialogWindow != null) {
            while (true) {
                if (dialogWindow.getDialogWindow() == null) {
                    return dialogWindow;
                }
                dialogWindow = dialogWindow.getDialogWindow();
            }
        }
        return dialogWindow;
    }

    public boolean handleFile(FileInfo file, Callback<class_3902> callback) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application app = (Application)obj;
        return Objects.requireNonNull(app.info).getFormattedId().equals(Objects.requireNonNull(this.info).getFormattedId());
    }

    public boolean isOpen() {
        return this.getWindow() != null;
    }
}

