/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GLHelper;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ScrollableLayout
extends Layout {
    protected int placeholderColor = new Color(1.0f, 1.0f, 1.0f, 0.35f).getRGB();
    protected int scroll;
    private final int visibleHeight;
    private int scrollSpeed = 5;

    public ScrollableLayout(int width, int height, int visibleHeight) {
        super(width, height);
        this.visibleHeight = visibleHeight;
    }

    public ScrollableLayout(int left, int top, int width, int height, int visibleHeight) {
        super(left, top, Math.max(13, width), Math.max(1, height));
        this.visibleHeight = visibleHeight;
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) {
            return;
        }
        GLHelper.pushScissor(x, y, this.width, this.visibleHeight);
        super.render(graphics, computerScreen, mc, x, y - this.scroll, mouseX, mouseY, windowActive, partialTicks);
        GLHelper.popScissor();
    }

    @Override
    public void renderOverlay(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        if (!this.visible) {
            return;
        }
        super.renderOverlay(graphics, computerScreen, mc, mouseX, mouseY, windowActive);
        if (this.height > this.visibleHeight) {
            int visibleScrollBarHeight = this.visibleHeight;
            int scrollBarHeight = Math.max(20, (int)((float)this.visibleHeight / (float)this.height * (float)visibleScrollBarHeight));
            float scrollPercentage = class_3532.method_15363((float)((float)this.scroll / (float)(this.height - this.visibleHeight)), (float)0.0f, (float)1.0f);
            int scrollBarY = (int)((float)(visibleScrollBarHeight - scrollBarHeight) * scrollPercentage);
            int scrollY = this.yPosition + scrollBarY;
            graphics.method_25294(this.xPosition + this.width - 5, scrollY, this.xPosition + this.width - 2, scrollY + scrollBarHeight, this.placeholderColor);
        }
    }

    @Override
    public void updateComponents(int x, int y) {
        this.xPosition = x + this.left;
        this.yPosition = y + this.top;
        for (Component c : this.components) {
            c.updateComponents(x + this.left, y + this.top - this.scroll);
        }
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight) && this.height > this.visibleHeight) {
            this.scroll += direction ? -this.scrollSpeed : this.scrollSpeed;
            if (this.scroll + this.visibleHeight > this.height) {
                this.scroll = this.height - this.visibleHeight;
            } else if (this.scroll < 0) {
                this.scroll = 0;
            }
            this.updateComponents(this.xPosition - this.left, this.yPosition - this.top);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseRelease(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseDrag(mouseX, mouseY, mouseButton);
        }
    }

    public static ScrollableLayout create(int left, int top, int width, int visibleHeight, String text) {
        return ScrollableLayout.create(left, top, width, visibleHeight, text, false);
    }

    public static ScrollableLayout create(int left, int top, int width, int visibleHeight, String text, boolean shadow) {
        Text t = new Text(text, 0, 0, width);
        t.setShadow(shadow);
        ScrollableLayout layout = new ScrollableLayout(left, top, t.getWidth(), t.getHeight(), visibleHeight);
        layout.addComponent(t);
        return layout;
    }

    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public void resetScroll() {
        this.scroll = 0;
        this.updateComponents(this.xPosition - this.left, this.yPosition - this.top);
    }
}

