/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.LauncherResponse;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.core.Settings;
import dev.ultreon.devices.core.Window;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public interface System {
    public void openContext(Layout var1, int var2, int var3);

    public boolean hasContext();

    public void closeContext();

    public Settings getSettings();

    public Application launchApp(AppInfo var1);

    public Application launchApp(AppInfo var1, class_2487 var2);

    default public void launchApp(AppInfo info, FileInfo path, Consumer<LauncherResponse> callback) {
        @Nullable Drive drive = path.getDrive();
        if (drive == null) {
            callback.accept(new LauncherResponse("Drive not found", null, false));
            return;
        }
        Application application = this.loadApp(info);
        if (application == null) {
            callback.accept(new LauncherResponse("Application not found", null, false));
            return;
        }
        if (application.isOpen()) {
            callback.accept(new LauncherResponse("Application already open", null, false));
            return;
        }
        application.handleFile(path, (unit, success) -> {
            if (!success) {
                callback.accept(new LauncherResponse("Failed to open file", null, false));
                @Nullable Window<?> window = application.getWindow();
                return;
            }
            callback.accept(new LauncherResponse(null, application, true));
        });
    }

    public Application loadApp(AppInfo var1);

    public void closeApplication(AppInfo var1);

    public Collection<AppInfo> getInstalledApplications();

    public void openDialog(Dialog var1);
}

