/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.IIcon;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import dev.ultreon.devices.util.StringUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public class Button
extends Component {
    protected static final int TOOLTIP_DELAY = 20;
    protected String text;
    protected String toolTip;
    protected String toolTipTitle;
    protected int toolTipTick;
    protected boolean hovered;
    protected int padding = 5;
    protected int width;
    protected int height;
    protected boolean explicitSize = false;
    protected class_2960 iconResource;
    protected int iconU;
    protected int iconV;
    protected int iconWidth;
    protected int iconHeight;
    protected int iconSourceWidth;
    protected int iconSourceHeight;
    protected int iconUHeight = this.iconHeight;
    protected int iconVWidth = this.iconWidth;
    protected ClickListener clickListener = null;

    public void setIconU(int u, int v) {
        this.iconVWidth = u;
        this.iconUHeight = v;
    }

    public Button(int left, int top, String text) {
        super(left, top);
        this.width = Button.getTextWidth(text) + this.padding * 2;
        this.height = 16;
        this.text = text;
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.text = text;
    }

    public Button(int left, int top, IIcon icon) {
        super(left, top);
        this.padding = 3;
        this.width = icon.getIconSize() + this.padding * 2;
        this.height = icon.getIconSize() + this.padding * 2;
        this.setIcon(icon);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, IIcon icon) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(icon);
    }

    public void setIconSource(int iconSourceWidth, int iconSourceHeight) {
        this.iconSourceWidth = iconSourceWidth;
        this.iconSourceHeight = iconSourceHeight;
    }

    public Button(int left, int top, String text, IIcon icon) {
        this(left, top, text);
        this.setIcon(icon);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text, IIcon icon) {
        super(left, top);
        this.text = text;
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(icon);
    }

    public Button(int left, int top, class_2960 iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.padding = 3;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, class_2960 iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, String text, class_2960 iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.text = text;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text, class_2960 iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.text = text;
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public static int getTextWidth(String text) {
        boolean flag = (Boolean)class_310.method_1551().field_1690.method_42437().method_41753();
        class_310.method_1551().field_1690.method_42437().method_41748((Object)false);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int width = fontRenderer.method_1727(text);
        class_310.method_1551().field_1690.method_42437().method_41748((Object)flag);
        return width;
    }

    @Override
    protected void handleTick() {
        this.toolTipTick = this.hovered ? (this.toolTipTick = this.toolTipTick + 1) : 0;
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShaderTexture((int)0, (class_2960)Component.COMPONENTS_GUI);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getButtonColor());
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            this.hovered = GuiHelper.isMouseWithin(mouseX, mouseY, x, y, this.width, this.height) && windowActive;
            int i = this.getHoverState(this.hovered);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.blendFunc((int)770, (int)771);
            graphics.method_25293(Component.COMPONENTS_GUI, x, y, 2, 2, (float)(96 + i * 5), 12.0f, 2, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + this.width - 2, y, 2, 2, (float)(99 + i * 5), 12.0f, 2, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + this.width - 2, y + this.height - 2, 2, 2, (float)(99 + i * 5), 15.0f, 2, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x, y + this.height - 2, 2, 2, (float)(96 + i * 5), 15.0f, 2, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + 2, y, this.width - 4, 2, (float)(98 + i * 5), 12.0f, 1, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + this.width - 2, y + 2, 2, this.height - 4, (float)(99 + i * 5), 14.0f, 2, 1, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + 2, y + this.height - 2, this.width - 4, 2, (float)(98 + i * 5), 15.0f, 1, 2, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x, y + 2, 2, this.height - 4, (float)(96 + i * 5), 14.0f, 2, 1, 256, 256);
            graphics.method_25293(Component.COMPONENTS_GUI, x + 2, y + 2, this.width - 4, this.height - 4, (float)(98 + i * 5), 14.0f, 1, 1, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hovered) {
                graphics.method_49601(x, y, this.width, this.height, ComputerScreen.getSystem().getSettings().getColorScheme().getButtonOutlineColor());
            }
            int contentWidth = (this.iconResource != null ? this.iconWidth : 0) + Button.getTextWidth(this.text);
            if (this.iconResource != null && !StringUtils.isNotNullOrEmpty(this.text)) {
                contentWidth += 3;
            }
            int contentX = (int)Math.ceil((double)(this.width - contentWidth) / 2.0);
            if (this.iconResource != null) {
                int iconY = (this.height - this.iconHeight) / 2;
                RenderSystem.setShaderTexture((int)0, (class_2960)this.iconResource);
                graphics.method_25293(this.iconResource, x + contentX, y + iconY, this.iconWidth, this.iconHeight, (float)this.iconU, (float)this.iconV, this.iconVWidth, this.iconUHeight, this.iconSourceWidth, this.iconSourceHeight);
            }
            if (!StringUtils.isNullOrEmpty(this.text)) {
                Objects.requireNonNull(mc.field_1772);
                int textY = (this.height - 9) / 2 + 1;
                int textOffsetX = this.iconResource != null ? this.iconWidth + 3 : 0;
                int textColor = !this.enabled ? 0xA0A0A0 : 0xE0E0E0;
                graphics.method_25303(mc.field_1772, this.text, x + contentX + textOffsetX, y + textY, textColor);
            }
        }
    }

    @Override
    public void renderOverlay(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        if (this.hovered && this.toolTip != null && this.toolTipTick >= 20) {
            computerScreen.renderComponentTooltip(graphics, Arrays.asList(class_2561.method_43470((String)this.toolTipTitle).method_27692(class_124.field_1065), class_2561.method_43470((String)this.toolTip)), mouseX, mouseY);
        }
    }

    public void forceClick(int mouseX, int mouseY, int mouseButton) {
        if (this.clickListener != null) {
            this.clickListener.onClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (this.hovered) {
            if (this.clickListener != null) {
                this.clickListener.onClick(mouseX, mouseY, mouseButton);
            }
            this.playClickSound(class_310.method_1551().method_1483());
        }
    }

    public final void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    protected void playClickSound(class_1144 manager) {
        manager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    protected boolean isInside(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void setSize(int width, int height) {
        this.explicitSize = true;
        this.width = width;
        this.height = height;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.updateSize();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.updateSize();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setIcon(class_2960 iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        this.iconU = iconU;
        this.iconV = iconV;
        this.iconResource = iconResource;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconSourceWidth = 256;
        this.iconSourceHeight = 256;
        this.iconUHeight = iconHeight;
        this.iconVWidth = iconWidth;
        this.updateSize();
    }

    public void setIcon(IIcon icon) {
        this.iconU = icon.getU();
        this.iconV = icon.getV();
        this.iconResource = icon.getIconAsset();
        this.iconWidth = icon.getIconSize();
        this.iconHeight = icon.getIconSize();
        this.iconSourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.iconSourceHeight = icon.getGridHeight() * icon.getIconSize();
        this.iconUHeight = this.iconHeight;
        this.iconVWidth = this.iconWidth;
        this.updateSize();
    }

    public void removeIcon() {
        this.iconResource = null;
        this.updateSize();
    }

    private void updateSize() {
        if (this.explicitSize) {
            return;
        }
        int height = this.padding * 2;
        int width = this.padding * 2;
        if (this.iconResource != null) {
            width += this.iconWidth;
            height += this.iconHeight;
        }
        if (this.text != null) {
            width += Button.getTextWidth(this.text);
            height = 16;
        }
        if (this.iconResource != null && this.text != null) {
            width += 3;
            height = this.iconHeight + this.padding * 2;
        }
        this.width = width;
        this.height = height;
    }

    public void setToolTip(String toolTipTitle, String toolTip) {
        this.toolTipTitle = toolTipTitle;
        this.toolTip = toolTip;
    }
}

