/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.io;

import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.File;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.programs.system.component.FileBrowser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class Folder
extends File {
    protected List<File> files = new ArrayList<File>();
    private boolean synced = false;

    public Folder(String name) {
        this(name, false);
    }

    private Folder(String name, boolean protect) {
        this.name = name;
        this.protect = protect;
    }

    public static Folder fromTag(String name, class_2487 folderTag) {
        Folder folder = new Folder(name);
        if (folderTag.method_10573("protected", 1)) {
            folder.protect = folderTag.method_10577("protected");
        }
        class_2487 fileList = folderTag.method_10562("files");
        for (String fileName : fileList.method_10541()) {
            File file;
            class_2487 fileTag = fileList.method_10562(fileName);
            if (fileTag.method_10545("files")) {
                file = Folder.fromTag(fileName, fileTag);
                file.parent = folder;
                folder.files.add(file);
                continue;
            }
            file = File.fromTag(fileName, fileTag);
            file.parent = folder;
            folder.files.add(file);
        }
        return folder;
    }

    public void add(File file) {
        this.add(file, false, null);
    }

    public void add(File file, @Nullable Callback<FileSystem.Response> callback) {
        this.add(file, false, callback);
    }

    public void add(File file, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before you can add files to it");
        }
        if (file == null) {
            DebugLog.log("File is null");
            if (callback != null) {
                DebugLog.log("Callback is not null");
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        DebugLog.log("Adding file " + file.name + " to folder " + this.name);
        if (!FileSystem.PATTERN_FILE_NAME.matcher(file.name).matches()) {
            DebugLog.log("File name is invalid");
            if (callback != null) {
                DebugLog.log("Callback is not null");
                callback.execute(FileSystem.createResponse(5, "Invalid file name"), true);
            }
            return;
        }
        if (this.hasFile(file.name)) {
            DebugLog.log("File already exists");
            if (!override) {
                DebugLog.log("File already exists and override is false");
                if (callback != null) {
                    DebugLog.log("Callback is not null");
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), true);
                }
                return;
            }
            if (Objects.requireNonNull(this.getFile(file.name)).isProtected()) {
                DebugLog.log("File already exists and override is true and file is protected");
                if (callback != null) {
                    DebugLog.log("Callback is not null");
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), true);
                }
                return;
            }
        }
        DebugLog.log("File is valid");
        FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeNewFile(Path.of(file.getPath(), new String[0]), file.name, override), (response, success) -> {
            DebugLog.log("Received response");
            if (success) {
                DebugLog.log("File added successfully");
                if (override) {
                    this.files.remove(this.getFile(file.name));
                }
                file.setDrive(this.drive);
                file.valid = true;
                file.parent = this;
                this.files.add(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                DebugLog.log("Callback is not null");
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public void delete(String name) {
        this.delete(name, null);
    }

    public void delete(String name, @Nullable Callback<FileSystem.Response> callback) {
        this.delete(this.getFile(name), callback);
    }

    public void delete(File file) {
        this.delete(file, null);
    }

    public void delete(File file, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before you can delete files");
        }
        if (file == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        if (!this.files.contains(file)) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "The file does not exist in this folder"), false);
            }
            return;
        }
        if (file.isProtected()) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot delete protected files"), false);
            }
            return;
        }
        FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeDelete(Path.of(file.getPath(), new String[0])), (response, success) -> {
            if (success) {
                file.drive = null;
                file.valid = false;
                file.parent = null;
                this.files.remove(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public void copyInto(File file, boolean override, boolean cut, @Nullable Callback<FileSystem.Response> callback) {
        if (file == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        if (!file.valid || file.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (this.hasFile(file.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), true);
                }
                return;
            }
            if (Objects.requireNonNull(this.getFile(file.name)).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), true);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeCopyCut(Path.of(this.getPath(), new String[0]), new DataPath(file.drive.getUUID(), Path.of(file.getPath(), new String[0])), false, cut), (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 1 && file.isFolder()) {
                file.copy();
            }
        });
    }

    public boolean hasFile(String name) {
        return this.valid && this.files.stream().anyMatch(file -> file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public File getFile(String name) {
        return this.files.stream().filter(file -> file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public void getFile(String name, Callback<File> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before retrieve files");
        }
        if (!this.isSynced()) {
            this.sync((folder, success) -> callback.execute(this.getFile(name), success));
        } else {
            callback.execute(this.getFile(name), true);
        }
    }

    public boolean hasFolder(String name) {
        return this.valid && this.files.stream().anyMatch(file -> file.isFolder() && file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public Folder getFolder(String name) {
        return this.files.stream().filter(file -> file.isFolder() && file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public void getFolder(String name, Callback<Folder> callback) {
        Folder requestedFolder = this.getFolder(name);
        if (requestedFolder == null) {
            callback.execute(null, false);
            return;
        }
        if (!requestedFolder.isSynced()) {
            this.sync((folder, success) -> callback.execute(requestedFolder, success));
        } else {
            callback.execute(requestedFolder, true);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> search(Predicate<File> conditions) {
        class_2371 found = class_2371.method_10211();
        this.search((List<File>)found, conditions);
        return found;
    }

    private void search(List<File> results, Predicate<File> conditions) {
        this.files.forEach(file -> {
            if (conditions.test((File)file)) {
                results.add((File)file);
            }
        });
    }

    @Override
    @Deprecated
    public boolean isFolder() {
        return true;
    }

    @Override
    public void setData(@NotNull class_2487 data) {
    }

    @Override
    public void setData(@NotNull class_2487 data, Callback<FileSystem.Response> callback) {
        if (callback != null) {
            callback.execute(FileSystem.createResponse(0, "Can not set data of a folder"), false);
        }
    }

    @Override
    void setDrive(Drive drive) {
        this.drive = drive;
        this.files.forEach(f -> f.setDrive(drive));
    }

    public void syncFiles(class_2499 list) {
        this.files.removeIf(f -> !f.isFolder());
        for (int i = 0; i < list.size(); ++i) {
            class_2487 fileTag = list.method_10602(i);
            File file = File.fromTag(fileTag.method_10558("file_name"), fileTag.method_10562("data"));
            file.drive = this.drive;
            file.valid = true;
            file.parent = this;
            this.files.add(file);
        }
        this.synced = true;
    }

    public void sync(@Nullable Callback<Folder> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before it can be synced");
        }
        if (!this.isSynced()) {
            class_2338 pos = ComputerScreen.getPos();
            if (pos == null) {
                if (callback != null) {
                    callback.execute(this, false);
                }
                return;
            }
            Task task = this.files(callback, pos);
            TaskManager.sendTask(task);
        } else if (callback != null) {
            callback.execute(this, true);
        }
    }

    @NotNull
    private Task files(@Nullable Callback<Folder> callback, class_2338 pos) {
        throw new UnsupportedOperationException();
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void refresh() {
        this.synced = false;
    }

    public void validate() {
        if (!this.synced) {
            this.valid = true;
            this.files.forEach(f -> {
                if (f.isFolder()) {
                    ((Folder)f).validate();
                } else {
                    f.valid = true;
                }
            });
        }
    }

    @Override
    public class_2487 toTag() {
        class_2487 folderTag = new class_2487();
        class_2487 fileList = new class_2487();
        this.files.forEach(file -> fileList.method_10566(file.getName(), (class_2520)file.toTag()));
        folderTag.method_10566("files", (class_2520)fileList);
        if (this.protect) {
            folderTag.method_10556("protected", true);
        }
        return folderTag;
    }

    @Override
    public File copy() {
        Folder folder = new Folder(this.name);
        this.files.forEach(f -> {
            File copy = f.copy();
            copy.protect = false;
            folder.files.add(copy);
        });
        return folder;
    }

    @Override
    public File copy(String newName) {
        Folder folder = new Folder(newName);
        this.files.forEach(f -> {
            File copy = f.copy();
            copy.protect = false;
            folder.files.add(copy);
        });
        return folder;
    }
}

