/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.task;

import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.network.PacketHandler;
import dev.ultreon.devices.network.task.RequestPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_310;

public final class TaskManager {
    private static TaskManager instance = null;
    private final Map<String, Task> registeredRequests = new HashMap<String, Task>();
    private final Map<Integer, Task> requests = new HashMap<Integer, Task>();
    private int currentId = 0;

    private TaskManager() {
    }

    private static TaskManager get() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    public static void registerTask(Supplier<Task> clazz) {
        Task task = clazz.get();
        try {
            Devices.LOGGER.info("Registering task '{}'", (Object)task.getName());
            TaskManager.get().registeredRequests.put(task.getName(), task);
        }
        catch (Exception e) {
            Devices.LOGGER.error("Failed to register task:", (Throwable)e);
        }
    }

    public static void sendTask(Task task) {
        TaskManager manager = TaskManager.get();
        if (!manager.registeredRequests.containsKey(task.getName())) {
            throw new RuntimeException("Unregistered Task: " + task.getClass().getName() + ". Use TaskManager#requestRequest to register your task.");
        }
        int requestId = manager.currentId++;
        manager.requests.put(requestId, task);
        if (class_310.method_1551().method_1562() != null) {
            PacketHandler.sendToServer(new RequestPacket(requestId, task));
        }
    }

    public static Task getTask(String name) {
        return TaskManager.get().registeredRequests.get(name);
    }

    public static Task getTaskAndRemove(int id) {
        return TaskManager.get().requests.remove(id);
    }
}

