/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtil {
    public static void renderItem(class_332 graphics, int x, int y, class_1799 stack, boolean overlay) {
        RenderSystem.disableDepthTest();
        class_308.method_24210();
        class_4587.class_4665 last = graphics.method_51448().method_23760();
        Matrix4f _4d = last.method_23761();
        Matrix3f _3d = last.method_23762();
        graphics.method_51448().method_34426();
        graphics.method_51427(stack, x, y);
        if (overlay) {
            graphics.method_51431(class_310.method_1551().field_1772, stack, x, y);
        }
        graphics.method_51448().method_23760().method_23761().normal(_4d);
        graphics.method_51448().method_23760().method_23762().normal(_3d);
    }

    public static void drawIcon(class_332 graphics, double x, double y, AppInfo info, int width, int height) {
        if (info == null || info.getIcon().getBase().getU() == -1 && info.getIcon().getBase().getV() == -1) {
            RenderSystem.setShaderTexture((int)0, (class_2960)ComputerScreen.ICON_TEXTURES);
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, 0.0f, 0.0f, width, height, 14.0f, 14.0f, 224, 224);
            return;
        }
        RenderSystem.enableBlend();
        AppInfo.Icon.Glyph[] glyphs = new AppInfo.Icon.Glyph[]{info.getIcon().getBase(), info.getIcon().getOverlay0(), info.getIcon().getOverlay1()};
        RenderSystem.setShaderTexture((int)0, (class_2960)ComputerScreen.ICON_TEXTURES);
        for (AppInfo.Icon.Glyph glyph : glyphs) {
            if (glyph.getU() == -1 || glyph.getV() == -1) continue;
            Color col = new Color(info.getTint(glyph.getType()));
            int[] tint = new int[]{col.getRed(), col.getGreen(), col.getBlue()};
            RenderSystem.setShaderColor((float)((float)tint[0] / 255.0f), (float)((float)tint[1] / 255.0f), (float)((float)tint[2] / 255.0f), (float)1.0f);
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, (float)glyph.getU(), (float)glyph.getV(), width, height, 14.0f, 14.0f, 224, 224);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRectWithTexture(class_2960 location, class_332 graphics, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(location, graphics, x, y, 0.0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(class_2960 location, class_332 graphics, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(location, graphics.method_51448(), x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(class_2960 location, class_4587 pose, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float scale = 0.00390625f;
        Matrix4f e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float)x, (float)(y + (double)height), (float)z).method_22913(u * scale, (v + textureHeight) * scale);
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), (float)z).method_22913((u + textureWidth) * scale, (v + textureHeight) * scale);
        buffer.method_22918(e, (float)(x + (double)width), (float)y, (float)z).method_22913((u + textureWidth) * scale, v * scale);
        buffer.method_22918(e, (float)x, (float)y, (float)z).method_22913(u * scale, v * scale);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawRectWithFullTexture(class_332 graphics, double x, double y, float u, float v, int width, int height) {
        Matrix4f e = graphics.method_51448().method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float)x, (float)(y + (double)height), 0.0f).method_22913(0.0f, 1.0f);
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).method_22913(1.0f, 1.0f);
        buffer.method_22918(e, (float)(x + (double)width), (float)y, 0.0f).method_22913(1.0f, 0.0f);
        buffer.method_22918(e, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f);
        class_286.method_43433((class_9801)Objects.requireNonNull(buffer.method_60794()));
    }

    public static void drawRectWithTexture(class_2960 location, class_332 graphics, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        RenderUtil.drawRectWithTexture(location, graphics.method_51448(), x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
    }

    public static void drawRectWithTexture(class_2960 location, class_4587 pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        float scaleWidth = 1.0f / (float)sourceWidth;
        float scaleHeight = 1.0f / (float)sourceHeight;
        Matrix4f e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float)x, (float)(y + (double)height), 0.0f).method_22913(u * scaleWidth, (v + textureHeight) * scaleHeight);
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).method_22913((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight);
        buffer.method_22918(e, (float)(x + (double)width), (float)y, 0.0f).method_22913((u + textureWidth) * scaleWidth, v * scaleHeight);
        buffer.method_22918(e, (float)x, (float)y, 0.0f).method_22913(u * scaleWidth, v * scaleHeight);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawApplicationIcon(class_332 graphics, @Nullable AppInfo info, double x, double y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)ComputerScreen.ICON_TEXTURES);
        if (info != null) {
            RenderUtil.drawIcon(graphics, x, y, info, 14, 14);
        } else {
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f, 224, 224);
        }
    }

    public static void drawStringClipped(class_332 graphics, String text, int x, int y, int width, int color, boolean shadow) {
        if (shadow) {
            graphics.method_25303(ComputerScreen.getFont(), RenderUtil.clipStringToWidth(text, width) + String.valueOf(class_124.field_1070), x, y, color);
        } else {
            graphics.method_51433(ComputerScreen.getFont(), ComputerScreen.getFont().method_27523(text, width) + String.valueOf(class_124.field_1070), x, y, color, false);
        }
    }

    public static String clipStringToWidth(String text, int width) {
        Object clipped;
        class_327 fontRenderer = ComputerScreen.getFont();
        if (fontRenderer.method_1727((String)(clipped = text)) > width) {
            clipped = fontRenderer.method_27523((String)clipped, width - 8) + "...";
        }
        return clipped;
    }

    public static boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static int color(int color, int defaultColor) {
        return color > 0 ? color : defaultColor;
    }
}

