/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.SyncBlockEntity;
import dev.ultreon.devices.util.Colorable;
import dev.ultreon.devices.util.Tickable;
import java.util.UUID;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DeviceBlockEntity
extends SyncBlockEntity
implements Tickable {
    private class_1767 color = class_1767.field_7964;
    private UUID deviceId;
    private String name;

    public DeviceBlockEntity(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @NotNull
    public final UUID getId() {
        if (this.deviceId == null) {
            this.deviceId = UUID.randomUUID();
        }
        return this.deviceId;
    }

    public abstract String getDeviceName();

    public String getCustomName() {
        return this.hasCustomName() ? this.name : this.getDeviceName();
    }

    public void setCustomName(String name) {
        this.name = name;
    }

    public boolean hasCustomName() {
        return this.name != null && StringUtils.isEmpty((CharSequence)this.name);
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)this.getCustomName());
    }

    protected void method_11007(@NotNull class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10582("deviceId", this.getId().toString());
        if (this.hasCustomName()) {
            tag.method_10582("name", this.name);
        }
        tag.method_10567("color", (byte)this.color.method_7789());
    }

    public void method_11014(@NotNull class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573("deviceId", 8)) {
            this.deviceId = UUID.fromString(tag.method_10558("deviceId"));
        }
        if (tag.method_10573("name", 8)) {
            this.name = tag.method_10558("name");
        }
        if (tag.method_10573("color", 1)) {
            this.color = class_1767.method_7791((int)tag.method_10571("color"));
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = new class_2487();
        if (this.hasCustomName()) {
            tag.method_10582("name", this.name);
        }
        tag.method_10567("color", (byte)this.color.method_7789());
        return tag;
    }

    public class_2248 getBlock() {
        return this.method_11010().method_26204();
    }

    public DeviceBlock getDeviceBlock() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof DeviceBlock) {
            DeviceBlock deviceBlock = (DeviceBlock)block;
            return deviceBlock;
        }
        return null;
    }

    public static abstract class Colored
    extends DeviceBlockEntity
    implements Colorable {
        private class_1767 color = class_1767.field_7964;

        public Colored(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
            super(pType, pWorldPosition, pBlockState);
        }

        @Override
        public void method_11014(@NotNull class_2487 tag, class_7225.class_7874 provider) {
            super.method_11014(tag, provider);
            if (tag.method_10573("color", 1)) {
                this.color = class_1767.method_7791((int)tag.method_10571("color"));
            }
        }

        @Override
        protected void method_11007(@NotNull class_2487 tag, class_7225.class_7874 provider) {
            super.method_11007(tag, provider);
            tag.method_10567("color", (byte)this.color.method_7789());
        }

        @Override
        public class_2487 saveSyncTag() {
            class_2487 tag = super.saveSyncTag();
            tag.method_10567("color", (byte)this.color.method_7789());
            return tag;
        }

        @Override
        public class_1767 getColor() {
            return this.color;
        }

        @Override
        public void setColor(class_1767 color) {
            this.color = color;
        }
    }
}

