/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.api.event.PrinterPrintQueuedEvent;
import dev.ultreon.devices.api.event.PrinterPrintedEvent;
import dev.ultreon.devices.api.event.PrinterStartPrintingEvent;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.devices.init.DeviceSounds;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class PrinterBlockEntity
extends NetworkDeviceBlockEntity.Colored {
    private State state = State.IDLE;
    private final Deque<IPrint> printQueue = new ArrayDeque<IPrint>();
    private IPrint currentPrint;
    private int totalPrintTime;
    private int remainingPrintTime;
    private int paperCount = 0;

    public PrinterBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super((class_2591)DeviceBlockEntities.PRINTER.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void tick() {
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236) {
            if (this.remainingPrintTime > 0) {
                if (this.remainingPrintTime % 20 == 0 || this.state == State.LOADING_PAPER) {
                    this.pipeline.method_10569("remainingPrintTime", this.remainingPrintTime);
                    this.sync();
                    if (this.remainingPrintTime != 0 && this.state == State.PRINTING) {
                        this.field_11863.method_8396(null, this.field_11867, (class_3414)DeviceSounds.PRINTER_PRINTING.get(), class_3419.field_15245, 0.5f, 1.0f);
                    }
                }
                --this.remainingPrintTime;
            } else {
                this.setState(this.state.next());
            }
        }
        if (this.state == State.IDLE && this.remainingPrintTime == 0 && this.currentPrint != null) {
            if (!this.field_11863.field_9236) {
                class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264() + 0.0625, (double)this.field_11867.method_10260(), IPrint.generateItem(this.currentPrint));
                entity.method_18799(new class_243(0.0, 0.0, 0.0));
                this.field_11863.method_8649((class_1297)entity);
            }
            EventSystem.MAIN.publish((Object)new PrinterPrintedEvent(this, this.currentPrint));
            this.currentPrint = null;
        }
        if (this.state == State.IDLE && this.currentPrint == null && !this.printQueue.isEmpty() && this.paperCount > 0) {
            this.print(this.printQueue.poll());
        }
    }

    @Override
    public String getDeviceName() {
        return "Printer";
    }

    @Override
    public void method_11014(@NotNull class_2487 compound, class_7225.class_7874 provider) {
        super.method_11014(compound, provider);
        if (compound.method_10573("currentPrint", 10)) {
            this.currentPrint = IPrint.load(compound.method_10562("currentPrint"));
        }
        if (compound.method_10573("totalPrintTime", 3)) {
            this.totalPrintTime = compound.method_10550("totalPrintTime");
        }
        if (compound.method_10573("remainingPrintTime", 3)) {
            this.remainingPrintTime = compound.method_10550("remainingPrintTime");
        }
        if (compound.method_10573("state", 3)) {
            this.state = State.values()[compound.method_10550("state")];
        }
        if (compound.method_10573("paperCount", 3)) {
            this.paperCount = compound.method_10550("paperCount");
        }
        if (compound.method_10573("queue", 9)) {
            this.printQueue.clear();
            class_2499 queue = compound.method_10554("queue", 10);
            for (int i = 0; i < queue.size(); ++i) {
                IPrint print = IPrint.load(queue.method_10602(i));
                this.printQueue.offer(print);
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10569("totalPrintTime", this.totalPrintTime);
        tag.method_10569("remainingPrintTime", this.remainingPrintTime);
        tag.method_10569("state", this.state.ordinal());
        tag.method_10569("paperCount", this.paperCount);
        if (this.currentPrint != null) {
            tag.method_10566("currentPrint", (class_2520)IPrint.save(this.currentPrint));
        }
        if (!this.printQueue.isEmpty()) {
            class_2499 queue = new class_2499();
            this.printQueue.forEach(print -> queue.add((Object)IPrint.save(print)));
            tag.method_10566("queue", (class_2520)queue);
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10569("paperCount", this.paperCount);
        return tag;
    }

    public void setState(State newState) {
        if (newState == null) {
            return;
        }
        this.state = newState;
        this.remainingPrintTime = this.state == State.PRINTING ? (((Boolean)DeviceConfig.OVERRIDE_PRINT_SPEED.get()).booleanValue() ? (Integer)DeviceConfig.CUSTOM_PRINT_SPEED.get() * 20 : this.currentPrint.speed() * 20) : this.state.animationTime;
        this.totalPrintTime = this.remainingPrintTime;
        this.pipeline.method_10569("state", this.state.ordinal());
        this.pipeline.method_10569("totalPrintTime", this.totalPrintTime);
        this.pipeline.method_10569("remainingPrintTime", this.remainingPrintTime);
        this.sync();
    }

    public void addToQueue(IPrint print) {
        EventSystem.MAIN.publish((Object)new PrinterPrintQueuedEvent(this, print));
        this.printQueue.offer(print);
    }

    private void print(IPrint print) {
        assert (this.field_11863 != null);
        this.field_11863.method_8396(null, this.field_11867, (class_3414)DeviceSounds.PRINTER_LOADING_PAPER.get(), class_3419.field_15245, 0.5f, 1.0f);
        this.setState(State.LOADING_PAPER);
        this.currentPrint = print;
        --this.paperCount;
        this.pipeline.method_10569("paperCount", this.paperCount);
        this.pipeline.method_10566("currentPrint", (class_2520)IPrint.save(this.currentPrint));
        EventSystem.MAIN.publish((Object)new PrinterStartPrintingEvent(this, print));
        this.sync();
    }

    public boolean isLoading() {
        return this.state == State.LOADING_PAPER;
    }

    public boolean isPrinting() {
        return this.state == State.PRINTING;
    }

    public int getTotalPrintTime() {
        return this.totalPrintTime;
    }

    public int getRemainingPrintTime() {
        return this.remainingPrintTime;
    }

    public boolean addPaper(class_1799 stack, boolean addAll) {
        if (!stack.method_7960() && stack.method_7909() == class_1802.field_8407 && this.paperCount < (Integer)DeviceConfig.MAX_PAPER_COUNT.get()) {
            if (!addAll) {
                ++this.paperCount;
                stack.method_7934(1);
            } else {
                this.paperCount += stack.method_7947();
                stack.method_7939(Math.max(0, this.paperCount - 64));
                this.paperCount = Math.min(64, this.paperCount);
            }
            this.pipeline.method_10569("paperCount", this.paperCount);
            this.sync();
            assert (this.field_11863 != null);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14585, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean hasPaper() {
        return this.paperCount > 0;
    }

    public int getPaperCount() {
        return this.paperCount;
    }

    public IPrint getPrint() {
        return this.currentPrint;
    }

    public static enum State {
        LOADING_PAPER(30),
        PRINTING(0),
        IDLE(0);

        final int animationTime;

        private State(int time) {
            this.animationTime = time;
        }

        public State next() {
            if (this.ordinal() + 1 >= State.values().length) {
                return null;
            }
            return State.values()[this.ordinal() + 1];
        }
    }
}

