/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.computer;

import dev.ultreon.devices.block.entity.DriveInfo;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.computer.BiosImpl;
import dev.ultreon.devices.core.Bios;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.util.BlockEntityUtil;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public abstract class ComputerBlockEntity
extends NetworkDeviceBlockEntity.Colored {
    private class_2487 applicationData = new class_2487();
    private class_2487 systemData = new class_2487();
    private FileSystem fileSystem;
    private class_1767 externalDriveColor;

    protected ComputerBlockEntity(class_2591<? extends ComputerBlockEntity> type, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(type, pWorldPosition, pBlockState);
    }

    @Override
    public String getDeviceName() {
        return "Laptop";
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void method_11014(@NotNull class_2487 compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        if (compound.method_10573("system_data", 10)) {
            this.systemData = compound.method_10562("system_data");
        }
        if (compound.method_10573("application_data", 10)) {
            this.applicationData = compound.method_10562("application_data");
        }
        if (compound.method_10545("file_system")) {
            this.fileSystem = new FileSystem(this, compound.method_10562("file_system"));
        }
        if (compound.method_10573("external_drive_color", 1)) {
            this.externalDriveColor = null;
            if (compound.method_10571("external_drive_color") != -1) {
                this.externalDriveColor = class_1767.method_7791((int)compound.method_10571("external_drive_color"));
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        if (this.systemData != null) {
            compound.method_10566("system_data", (class_2520)this.systemData);
        }
        if (this.applicationData != null) {
            compound.method_10566("application_data", (class_2520)this.applicationData);
        }
        if (this.fileSystem != null) {
            compound.method_10566("file_system", (class_2520)this.fileSystem.toTag());
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10566("system_data", (class_2520)this.getSystemData());
        if (this.getFileSystem().getAttachedDrive() != null) {
            tag.method_10567("external_drive_color", (byte)this.getFileSystem().getAttachedDriveColor().method_7789());
        } else {
            tag.method_10567("external_drive_color", (byte)-1);
        }
        return tag;
    }

    protected static void doNeighborUpdates(class_1937 level, class_2338 pos, class_2680 state) {
        state.method_30101((class_1936)level, pos, 3);
    }

    public class_2487 getApplicationData() {
        return this.applicationData != null ? this.applicationData : new class_2487();
    }

    public class_2487 getSystemData() {
        if (this.systemData == null) {
            this.systemData = new class_2487();
        }
        return this.systemData;
    }

    public void setSystemData(class_2487 systemData) {
        this.systemData = systemData;
        this.method_5431();
        assert (this.field_11863 != null);
        BlockEntityUtil.markBlockForUpdate(this.field_11863, this.field_11867);
    }

    public FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = new FileSystem(this);
        }
        return this.fileSystem;
    }

    public void setApplicationData(String appId, class_2487 applicationData) {
        this.applicationData = applicationData;
        this.method_5431();
        assert (this.field_11863 != null);
        BlockEntityUtil.markBlockForUpdate(this.field_11863, this.field_11867);
    }

    public boolean isExternalDriveAttached() {
        return this.externalDriveColor != null;
    }

    public class_1767 getExternalDriveColor() {
        return this.externalDriveColor;
    }

    public Map<UUID, DriveInfo> getDriveInfo() {
        return this.getFileSystem().getDrives();
    }

    public Bios getBios() {
        return new BiosImpl(this);
    }

    public boolean isPoweredOn() {
        return true;
    }

    public void powerOff() {
    }
}

