/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.block.PrinterBlock;
import dev.ultreon.devices.block.entity.PrinterBlockEntity;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public record PrinterRenderer(class_5614.class_5615 context) implements class_827<PrinterBlockEntity>
{
    private static final Quaternionf tmpQ = new Quaternionf();
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final double PIXEL_SIZE = 0.015625;

    public void render(PrinterBlockEntity blockEntity, float partialTick, @NotNull class_4587 pose, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay) {
        PaperModel paperModel = new PaperModel(class_310.method_1551().method_31974().method_32072(PaperModel.LAYER_LOCATION));
        class_2680 state = Objects.requireNonNull(blockEntity.method_10997()).method_8320(blockEntity.method_11016());
        if (state.method_26204() != blockEntity.getBlock()) {
            return;
        }
        pose.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (blockEntity.hasPaper()) {
            pose.method_22903();
            PrinterRenderer.renderPaper(pose, bufferSource, packedLight, state, paperModel);
            pose.method_22909();
        }
        pose.method_22903();
        PrinterRenderer.renderPrint(blockEntity, pose, state, bufferSource, packedLight, packedOverlay, paperModel);
        pose.method_22909();
        pose.method_22903();
        PrinterRenderer.renderDisplay(blockEntity, pose, bufferSource, state);
        pose.method_22909();
        pose.method_22909();
    }

    private static void renderPaper(@NotNull class_4587 pose, @NotNull class_4597 bufferSource, int packedLight, class_2680 state, PaperModel paperModel) {
        pose.method_22904(0.5, 0.5, 0.5);
        pose.method_22907(((class_2350)state.method_11654((class_2769)PrinterBlock.field_11177)).method_23224());
        pose.method_22907(new Quaternionf().rotateX(1.1780972f));
        pose.method_22904(0.0, 0.0, 0.4);
        pose.method_22904(-0.203125, -0.203125, -0.015625);
        pose.method_22905(0.3f, 0.3f, 0.3f);
        PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
    }

    private static void renderPrint(PrinterBlockEntity blockEntity, @NotNull class_4587 pose, class_2680 state, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay, PaperModel paperModel) {
        if (blockEntity.isLoading()) {
            pose.method_22904(0.5, 0.5, 0.5);
            pose.method_22907(((class_2350)state.method_11654((class_2769)PrinterBlock.field_11177)).method_23224());
            pose.method_22907(tmpQ.identity().rotateX(1.1780972f));
            double progress = Math.max(-0.4, -0.4 + 0.4 * ((double)(blockEntity.getRemainingPrintTime() - 10) / 20.0));
            pose.method_22904(0.0, -progress, 0.4);
            pose.method_22904(-0.203125, -0.203125, -0.015625);
            pose.method_22905(0.3f, 0.3f, 0.3f);
            PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
        } else if (blockEntity.isPrinting()) {
            pose.method_22904(0.5, 0.078125, 0.5);
            pose.method_22907(((class_2350)state.method_11654((class_2769)PrinterBlock.field_11177)).method_23224());
            double progress = -0.35 + (double)(blockEntity.getRemainingPrintTime() - 20) / (double)blockEntity.getTotalPrintTime();
            pose.method_22904(0.0, -progress, 0.0);
            pose.method_22904(-0.203125, -0.203125, -0.0078125);
            pose.method_22905(0.3f, 0.3f, 0.3f);
            PrinterRenderer.drawBuffer(pose, bufferSource, packedLight, paperModel);
            pose.method_22904(0.4, 0.085, -0.001);
            pose.method_22907(tmpQ.identity().rotateY((float)Math.PI));
            IPrint print = blockEntity.getPrint();
            if (print != null) {
                pose.method_22903();
                pose.method_22904(-0.9375, 0.46875, 0.0);
                pose.method_22905(6.1035156E-5f, 6.1035156E-5f, 6.1035156E-5f);
                pose.method_22905(0.6666667f, 0.6666667f, 0.6666667f);
                IPrint.Renderer renderer = PrintingManager.getRenderer(print);
                class_4588 buffer = bufferSource.getBuffer(paperModel.method_23500(PaperModel.TEXTURE));
                renderer.render(pose, print.toTag());
                pose.method_22909();
            }
        }
    }

    private static void drawBuffer(@NotNull class_4587 pose, @NotNull class_4597 bufferSource, int packedLight, PaperModel paperModel) {
        class_4588 buffer = bufferSource.getBuffer(paperModel.method_23500(PaperModel.TEXTURE));
        paperModel.method_2828(pose, buffer, packedLight, class_4608.field_21444, -1);
    }

    private static void renderDisplay(PrinterBlockEntity blockEntity, @NotNull class_4587 pose, @NotNull class_4597 bufferSource, class_2680 state) {
        RenderSystem.depthMask((boolean)false);
        pose.method_22904(0.5, 0.5, 0.5);
        pose.method_22907(((class_2350)state.method_11654((class_2769)PrinterBlock.field_11177)).method_23224());
        pose.method_22907(tmpQ.identity().rotateY((float)Math.PI));
        pose.method_22904(0.0675, 0.005, -0.032);
        pose.method_22904(0.13437500000000002, 0.1875, -0.265625);
        pose.method_22903();
        pose.method_22905(-0.010416667f, -0.010416667f, -0.010416667f);
        pose.method_22907(tmpQ.identity().rotateX(1.9634954f));
        class_327 class_3272 = class_310.method_1551().field_1772;
        String string = Integer.toString(blockEntity.getPaperCount());
        float f = -class_310.method_1551().field_1772.method_1727(Integer.toString(blockEntity.getPaperCount()));
        Objects.requireNonNull(class_310.method_1551().field_1772);
        class_3272.method_27521(string, f, (float)(-9), Color.WHITE.getRGB(), false, pose.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        pose.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    public static class PaperModel
    extends class_3879 {
        public static final class_2960 TEXTURE = class_2960.method_60655((String)"devices", (String)"textures/model/paper.png");
        public static final class_5601 LAYER_LOCATION = new class_5601(Devices.res("paper_model"), "main");
        private final class_630 root;
        private final class_630 main;

        public PaperModel(class_630 pRoot) {
            super(class_1921::method_23572);
            this.root = pRoot;
            this.main = pRoot.method_32086("main");
        }

        public static class_5607 createBodyLayer() {
            class_5609 meshdefinition = new class_5609();
            class_5610 partdefinition = meshdefinition.method_32111();
            partdefinition.method_32117("main", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 22.0f, 30.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
            return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)32);
        }

        public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int i, int i1, int i2) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            this.root.method_22699(poseStack, vertexConsumer, i, i1, i2);
        }

        public class_630 getMain() {
            return this.main;
        }
    }
}

